.hpf hyphen.local
.P1
.de PT
.tl 'TC01 - TC-11/TU56 DEC TAPE INTERFACE'\*[CH]'PD-1C303-01'
.tl 'File: tc.c''Section 11'
.tl '''Issue 1, January 1976'
..
.2C
.ne 10
.
.LP
.LG
.B tcclose
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
tcclose(dev)
.br
int dev;
.sp 1n
.
.LP
.I RETURNS
.
.LP
No value returned.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Logically closes the TC11 DECtape.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
Tcclose is the device close routine for DECtape. It accomplishes its
function by merely forcing all of the write behind buffers for the device
"dev" to be written (see bio.c/bflush).
.sp 1m
.ne 10
.
.LP
.LG
.B tcintr
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
tcintr()
.sp 1n
.
.LP
.I RETURNS
.
.LP
No value returned.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Handles interrupts from the TC11 DECtape.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
As the interrupt handler for DECtape, tcintr's first responsibility is to
determine if an error occurrred on the controller command. If this is the
case and it is the twentieth error to occur for the current DECtape I/O
request, then the I/O is marked as complete but in error and abandoned as
hopeless. Otherwise, the error is handled by issuing a read block number
command for the block for which the transfer failed. This necessitates
reversing the tape's direction, which in essence means that the block
search is reinitiated for the block number of the I/O request. Tcintr then
returns, as it will receive control again when the read block number
command completes and causes an interrupt.
.
.LP
In most cases, however, an error will not occur. Tcintr continues the block
search that was initiated by tc.c/tcstart, or, as described above, by
tcintr itself. This entails merely comparing the current block number with
that of the current pending I/O request, and issuing a read block number
command for the forward or reverse direction as appropriate. Thus, the tape
is advanced in the proper direction to locate the desired block. Since a
DECtape interrupt is gencrated anew for each read block number command, it
is necessary for tcintr to return after each such command to prevent
recursive stacking of tcintr calls.
.
.LP
When the block number of the desired block is encountered while advancing
the tape in the forward direction, a command to actually read or write the
user's data is issued and tcintr returns. If the tape block search is
proceeding in the reverse direction, then the search is actually made for
the desired block number minus three. When this block is encountered, the
tape direction is reversed (to the forward direction) and the search
resumed. Of course, the desired block is found almost immediately and the
I/O is performed as previously described. This three block tactic is vital
to ensure that the tape is up to speed in the forward direction before
attempting the actual I/O.
.
.LP
When tcintr receives control after a completed read or write, the I/O
request is marked as completed and, if there are any requests remaining on
the queue, tc.c/tcstart is called to initiate I/O for the next request in
the queue.
.sp 1m
.ne 10
.
.LP
.LG
.B tcstart
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
tcstart()
.sp 1n
.
.LP
.I RETURNS
.
.LP
No value returned.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Initiates the actual I/O procedure for TC11 DECtape.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
If there are any I/O requests on the TC11 queue (chained from d_actf in
tctab), tcstart initiates the actual I/O procedure for the first request in
the queue. Because of the random block access property of DECtape, it is
first necessary to determine the tape's current position. Tcstart merely
initiates this process; the-remainder of the positioning to the proper tape
block is carried out by tc.c/tcintr.
.
.LP
If the last commmand to the DECtape controller was not to the same logical
device as the current I/O request, a command to stop all transports is
first issued. Note that for DECtape, the logical device number is
interpreted as the physical drive number. The controller is then issued the
read block number command for the drive the current I/O request is for.
This command is usually for the forward direction, but if the drive is not
up to speed (i.e., the stop all transports command was previously issued),
it is for the reverse direction. In any event, the command is always issued
with interrupts enabled, so that upon command completion the DECtape
interrupt handler tc.c/tcintr receives control and evaluates the results.
.sp 1m
.ne 10
.
.LP
.LG
.B tcstrategy
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
tcstrategy (bp)
.br
struct buf *bp;
.sp 1n
.
.LP
.I RETURNS
.
.LP
No value returned.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Places an I/O buffer on the TC11's queue of I/O buffers to read/write.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
Tcstrategy performs for DECtape the general strategy functions described in
rp.c/rpstrategy. The I/O buffer queuing strategy employed is strictly First
In First Out (FIFO). As might be expected, the logical device number is
taken to be the physical drive number.
