.hpf hyphen.local
.P1
.de PT
.tl 'RF01 - RF11/RS11 FIXED HEAD DISK FILE'\*[CH]'PD-1C303-01'
.tl 'File: rf.c''Section 7'
.tl '''Issue 1, January 1976'
..
.2C
.ne 10
.
.LP
.LG
.B rfintr
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
rfintr()
.sp 1n
.
.LP
.I RETURNS
.
.LP
No value returned.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Handles interrupts from the RF11.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
Rfintr, as the interrupt handler for the RF11 disk, performs the functions
described in rp.c/rpintr.
.sp 1m
.ne 10
.
.LP
.LG
.B rfread
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
rfread(dev)
.br
int dev;
.sp 1n
.
.LP
.I RETURNS
.
.LP
No value returned.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Interface to RF11 driver for "raw" mode read requests.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
Rfread handles raw mode read requests to the RF11 disk by calling
bio.c/physio. See rp.c/rpread for a discussion of raw mode device read
routines.
.sp 1m
.ne 10
.
.LP
.LG
.B rfstart
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
rfstart()
.sp 1n
.
.LP
.I RETURNS
.
.LP
No value returned.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Initiates the actual I/O to an RF11 device.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
If there are any I/O requests on the RF11 queue (chained from d_actf in
rftab), rfstart marks the RF11 as active (rftab.d_active). After filling in
the disk address extension error register, rfstart initiates I/O for the
first request in the queue by invoking bio.c/devstart. The arguments to
devstart reflect the logical device policy of the driver (see
rf.c/rfstrategy), as they are the translation of a logical device block
number to a physical device address.
.sp 1m
.ne 10
.
.LP
.LG
.B rfstrategy
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
rfstrategy(bp)
.br
struct bur *bp;
.sp 1n
.
.LP
.I RETURNS
.
.LP
No value returned.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Places an I/O buffer on the RF11's queue of I/O buffers to read/write.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
Rfstrategy performs for the RF11 disk the general strategy functions
described in rp.c/rpstrategy. The I/O buffer queuing strategy employed is
strictly First In First Out (FIFO). The logical device policy of the driver
is that the logical device number (minor device) is taken to be that value
plus one physical devices. For example, RF logical device two is viewed as
a single device consisting of the concatenation of the three physical
drives 0, 1, and 2. The actual logical device block number to physical
device address translation is performed by, rf.c/rfstart.
.sp 1m
.ne 10
.
.LP
.LG
.B rfwrite
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
rfwrite(dev)
.br
int dev;
.sp 1n
.
.LP
.I RETURNS
.
.LP
No value returned.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Interface to RF11 driver for "raw" mode write requests.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
Rfwrite handles raw mode write requests to the RF11 disk by calling
bio.c/physio. See rp.c/rpwrite for a diqcussion of raw mode device write
routines.
