.hpf hyphen.local
.P1
.de PT
.tl 'HS01 - RS03/04 INTERFACE'\*[CH]'PD-1C302-01'
.tl 'File: hs.c''Section 10'
.tl '''Issue 1, January 1976'
..
.2C
.ne 10
.
.LP
.LG
.B hsintr
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
hsintr()
.sp 1n
.
.LP
.I RETURNS
.
.LP
No value returned.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Handles interrupts from the RS03/RS04.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
Hsintr, as the interrupt handler for the RS03/RS04 disk, performs the
functions described in rp.c/rpintr.
.sp 1m
.ne 10
.
.LP
.LG
.B hsread
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
hsread(dev)
.br
int dev;
.sp 1n
.
.LP
.I RETURNS
.
.LP
No value returned.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Interface to RS03/RS04 driver for "raw" mode read requests.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
Hsread handles raw mode read requests to the RS03/RS04 disk by calling
bio.c/physio. See rp.c/rpread for a discussion of raw mode device read
routines.
.sp 1m
.ne 10
.
.LP
.LG
.B hsstart
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
hsstart()
.sp 1n
.
.LP
.I RETURNS
.
.LP
No value returned.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Initiates the actual I/O to an HS03/HS04 device.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
If there are any I/O requests on the HS03/HS04 queue (chained from d_actf
in hstab), hsstart marks the HS03/HS04 as active (hstab.d_active). After
filling in the disk address extension error register, hsstart initiates I/O
for the first request in the queue by invoking rh.c/rhstart. The arguments
to devstart reflect the logical device policy of the driver (see
hs.c/hsstrategy), as they are the translation of a logical device block
number to a physical device address.
.sp 1m
.ne 10
.
.LP
.LG
.B hsstrategy
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
hsstrategy(bp)
.br
struct buf *bp;
.sp 1n
.
.LP
.I RETURNS
.
.LP
No value returned.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Places an I/O buffer on the RS03/RS04's queue of I/O buffers to read/write.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
Hsstrategy performs for the RS03/RS04 disk the general strategy functions
described in rp.c/rpstrategy. The I/O buffer queuing strategy employed is
strictly First In First Out (FIFO). The logical device policy of the driver
is that the logical device number (minor device) is used to identify the
type of disk and the physical drive. Minor device numbers 0-7 define eight
drives respectively on an RS03, whereas minor devices 8-15 define 8 drives
on an RS04.
.sp 1m
.ne 10
.
.LP
.LG
.B hswrite
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
hswrite(dev)
.br
int dev;
.sp 1n
.
.LP
.I RETURNS
.
.LP
No value returned.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Interface to RS04/RS03 driver for "raw" mode write requests.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
Hswrite handles raw mode write requests to the RS04/RS03 disk by calling
bio.c/physio. See rp.c/rpwrite for a discussion of raw mode device write
routines.
