.hpf hyphen.local
.P1
.de PT
.tl 'DN01 - DN-11 ACU INTERFACE'\*[CH]'PD-1C302-01'
.tl 'File: dn.c''Section 7'
.tl '''Issue 1, January 1976'
..
.2C
.ne 10
.
.LP
.LG
.B dnclose
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
dnclose(dev)
.br
int dev;
.sp 1n
.
.LP
.I RETURNS
.
.LP
No value returned.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Logically closes the DN11 ACU interface.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
In order to logically close the DN11 device "dev", dnclose only has to
clear the device's status register.
.sp 1m
.ne 10
.
.LP
.LG
.B dnint
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
dnint(dev)
.br
int dev;
.sp 1n
.
.LP
.I RETURNS
.
.LP
No value'returned.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Interrupt handler for the DN11 ACU interface.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
As the interrupt handler for the DN11, dnint only has to awaken
dn.c/dnwrite so that the next digit of the call may be dialed.
.sp 1m
.ne 10
.
.LP
.LG
.B dnopen
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
dnopen (dev, flag)
.br
int dev, flag;
.sp 1n
.
.LP
.I RETURNS
.
.LP
No value returned.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Logically opens the DN11 ACU interface.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
In order to logically open the DN11, dnopen must choose the proper ACU as
determined by the device number "dev" and verify that the unit is available
for use. If unavailable, an error is indicated (u_error). Otherwise, dnopen
enables the chosen ACU. It should be noted that the argument "flag" only
serves to maintain syntax compatibility with other device open routines.
.sp 1m
.ne 10
.
.LP
.LG
.B dnwrite
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
dnwrite(dev)
.br
int dev;
.sp 1n
.
.LP
.I RETURNS
.
.LP
No value returned.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Write routine for the DN11 ACU interface.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
As the write routine for the DN11, dnwrite is responsible for interpreting
and dialing a telephone number written to the DN11 device "dev". This is
accomplished by serially obtaining each digit of the number and presenting
it to the DN11 for dialing. Before obtaining each digit, however, dnwrite
must first ensure that the DN11 is ready to accept a digit for dialing. If
the device is not yet ready, then dnwrite is, of course, obligated to wait
until it is (see dn.c/dnint). Once the unit is ready, a digit may be
obtained from the user's buffer and given to the DN11 for dialing. This
sequence is repeated for each digit of the telephone number until either an
error occurs or the call is completed (answered).
.
.LP
A special case in the handling of the telephone number's digits is that of
the hyphen (-) character, which is not written to the DN11. Rather, this
character causes dnwrite to delay eight seconds before continuing the
dialing sequence. This is useful for such things as waiting for a second
dial tone.
