.hpf hyphen.local
.P1
.de PT
.tl 'DH01 - DH-11 COMMUNICATIONS MULTIPLEXER'\*[CH]'PD-1C302-01'
.tl 'File: dh.c''Section 4'
.tl '''Issue 1, January 1976'
..
.2C
.ne 10
.
.LP
.LG
.B dhclose
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
dhclose(dev)
.br
int dev;
.sp 1n
.
.LP
.I RETURNS
.
.LP
No value returned.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Logically closes a terminal attached with a DH11 asynchronous interface.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
In order to logically close a terminal attached with a DH11 interface,
dhclose has to change the software state (t_state) for the proper device
(dh11[dev.d_minor] to closed, and, after forcing any data on the output
queue (t_outq) to be transmitted, flush the devices I/O queues (see
tty.c/wflushtty).
.sp 1m
.ne 10
.
.LP
.LG
.B dhopen
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
dhopen(dev, flag)
.br
int dev, flag;
.sp 1n
.
.LP
.I RETURNS
.
.LP
No value returned.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Logically opens a terminal attached with a DH11 asynchronous interface.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
Before actually attempting to open a terminal connected with a DH11 device,
dhopen must filter out requests to open invalid devices by checking the
plausibility of the device number "dev". Assuming that this test is passed,
the control structure for the device (i.e., terminal) is selected
(dh11[dev.d_minor]) and the device is placed in a waiting-to-open state
(t_state). When mapping device numbers to actual communications lines, the
minor device number is taken to be the corresponding line in the DH11. For
example, DH11 minor device three is taken to be line three in the DH11
itself. It should be noted that this version of the DH11 driver does not
support multiple DH11s on a system.
.
.LP
If the line (i.e., minor device) is not already open (i.e., the device was
closed; it is permissible to open the device more than once without
intervening closes), the device's (terminal's) control structure (struct
tty) is initialized and the hardware line parameters are set (see
dh.c/dhparam). All that remains to be done in order to conclude the open is
to wait for a carrier signal on the line. Exactly how this is done depends
on whether the device has a DM11 modem control (see dhdm.c/dmopen) or not
(see dhfdm.c/dmopen). Once a carrier signal has been detected, the opening
procedure is completed by changing the device's state from waiting-to-open
to open.
.sp 1m
.ne 10
.
.LP
.LG
.B dhparam
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
dhparam(tp)
.br
struct tty *tp;
.sp 1n
.
.LP
.I RETURNS
.
.LP
No value returned.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Sets line parameter information in the DH11 asynchronous interface.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
Information about the characteristics of a communications line must be set
in the DH11 interface for each line that is to be active. This is the
purpose of the dhparam routine. In particular, given a terminal descriptor
structure (struct tty) pointed to by "tp", dhparam must analyze the line
speed (t_speeds) and parity (t_flags) information. The hardware control
information corresponding to this software line speed and parity is then
loaded into the DH11's Line Parameter Regiiter. The net effect is to force
agreement between the software and the DH11 hardware for the speed and
parity of the line in question.
.sp 1m
.ne 10
.
.LP
.LG
.B dhread
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
dhread (dev)
.br
int dev;
.sp 1n
.
.LP
.I RETURNS
.
.LP
No value returned.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Read routine for terminals attached with a DH11 asynchronous interface.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
The dhread routine is the DH11 driver's interface to the general purpose
functions of UNIX that handle terminal I/O. All read requests to terminals
attached with a DH11 interface must pass through dhread. If the DH11 device
"dev" still has a carrier signal, then dhread only has to invoke
tty.c/ttread to obtain input data from the canonical queue (t_canq).
.sp 1m
.ne 10
.
.LP
.LG
.B dhrint
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
dhrint()
.sp 1n
.
.LP
.I RETURNS
.
.LP
No value returned.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Handles interrupts that occur in the receive portion of the DH11
asynchronous interface.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
As the receive interrupt handler for the DH11 interface, dhrint is called
whenever a character is received by the device. (Note that this version of
the DH11 driver does not use the silo feature of the DH11 to its fullest
extent, as the silo alarm level is left at zero.) Dhrint determines on
which line the character was received, and discards the character if either
the corresponding device has not yet been opened or there was a parity
error in receiving the character. Otherwise, the received character is
placed on the raw input queue (t_rawq) of the device corresponding to the
line on which it was received (see tty.c/ttyinput).
.sp 1m
.ne 10
.
.LP
.LG
.B dhsgtty
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
dhsgtty (dev, array)
.br
int dev, *array;
.sp 1n
.
.LP
.I RETURNS
.
.LP
No value returned.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Determines or modifies the mode of a terminal attached with a DH11
asynchronous interface.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
A nonzero value of "array" signifies that information about the current
state of the terminal attached to the DH11 device "dev" is desired in
response to a gtty system call (see tty.c/gtty). In this case "array" is
assumed to be a three word array into which dhsgtty places the current line
speeds (t_speeds), zero, and the current state (t_flags) of the device and
its associated terminal.
.
.LP
Conversely, a zero value of "array" implies that the state, of the device
is to be respecified in response to a stty system call (see tty.c/stty).
Untransmitted data on the output queue (toutq) is transmitted and the
device's input queues are flushed (see tty.c/wflushtty). The speeds
(t_speeds) and mode (t_flags) of the terminal are then reset as requested.
This also entails resetting the DH11 hardware's concept of the speed and
mode of the communications line (see dh.c/dhparam).
.sp 1m
.ne 10
.
.LP
.LG
.B dhstart
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
dhstart(tp)
.br
struct tty *tp;
.sp 1n
.
.LP
.I RETURNS
.
.LP
No value returned.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Special start routine for initiating the transmission of characters on a
DH11 asynchronous interface.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
Because the DH11 is a sixteen line multipixer, the general purpose device
start routine of UNIX (tty.c/ttstart) is not sufficient for initiating
transmission. The routine dhstart is invoked by tty.c/ttstart to fulfill
this device start function for the DH11 interface. Dhstart initiates
transmission of an output character to the terminal described by the
control structure pointed to by "tp". No action is taken, however, if the
line is already busy with a transmission or there are no characters on the
output queue (t_outq). Once a character has been obtained from the device's
output queue, a determination must be made as to whether, or not it is a
delay character (e.g., a delay character would precede a carriage return).
For "normal", nondelay characters, transmission of the character on the
appropriate communications line is initiated, the state (t_state) of the
device (i.e., line) is changed to show that it is busy, and the driver's
bit map of DH11 lines (dhsar) is altered to show that transmission was
initiated on that line. This bit map is used by the DH11 transmitter
interrupt handler (dh.c/dhxint) to determine the lines for which
transmission has completed. Delay characters are handled by requesting a
system timeout (see clock.c/timeout) after the delay time has expired.
.
.LP
Regardless of the nature of the character obtained from the output queue,
dhstart's final responsibility is to check the length of the device's
output queue. If sufficiently short, any processes waiting for it to shrink
before putting more characters on it (i.e., write to the device) are
awakened.
.sp 1m
.ne 10
.
.LP
.LG
.B dhwrite
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
dhwrite(dev)
.br
int dev;
.sp 1n
.
.LP
.I RETURNS
.
.LP
No value returned.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Write routine for terminals attached with a DH11 asynchronous interface.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
The dhwrite routine is the DH11 driver's interface to the general purpose
functions of UNIX that handle terminal I/O. All write requests to terminals
attached with a DH11 interface must pass through dhwrite. If the DH11
device "dev" still has a carrier signal, then dhwrite merely invokes
tty.c/ttwrite to place the data on the device's output queue (t_outq) and
initiate transmission.
.sp 1m
.ne 10
.
.LP
.LG
.B dhxint
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
dhxint()
.sp 1n
.
.LP
.I RETURNS
.
.LP
No value returned.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Handles interrupts that occur from the transmit portion of the DH11
asynchronous interface.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
Because the DH11 is a multiplexer and a transmitter interrupt may be caused
by any one of the sixteen lines, the DH11 driver's transmitter interrupt
handler, dhxint, must first determine exactly which line(s) caused the
interrupt. This is done by comparing the current state of the DH11's Buffer
Active Register (which shows the lines for which transmission is active)
against a bit map (dhsar) that shows the lines that have had transmissions
initiated (see dh.c/dhstart). The product of this comparison is a bit map
of all the lines whose transmission has completed since the last interrupt.
The software status of each such line is changed to inactive (i.e., not
busy) and transmission is reinitiated on the line (dh.c/dhstart).
