.hpf hyphen.local
.P1
.de PT
.tl 'SYS201 - SYSTEM CALL INTERFACE 2'\*[CH]'PD-1C301-01'
.tl 'File: sys2.c''Section 17'
.tl '''Issue 1, January 1976'
..
.2C
.ne 10
.
.LP
.LG
.B close
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
close()
.sp 1n
.
.LP
.I RETURNS
.
.LP
None
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Close system call interface - close a file.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
The argument to close is the file descriptor of the file to be closed.
Close calls fio.c/getf to check that the file descriptor is a valid value
and points to a open file. Close then zeros the file descriptor entry in
the per user control block (u.u_ofile). Close calls fio.c/closef to
decrement the usage count in the System INODE Table (inode.h) to see if the
entry can be purged (if the i-node is not shared by other processes). If
the. count goes to zero, the i-node is updated in the ilist and the entry
is freed.
.sp 1m
.ne 10
.
.LP
.LG
.B creat
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
creat()
.sp 1n
.
.LP
.I RETURNS
.
.LP
On error the appropriate code has been set in the per user control block
(u.u_error). On success the file descriptor for this file is returned to
the user in register R0.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Creat system call interface - to creat new files.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
Like OPEN, creat takes a string of characters representing a pathname and
calls nami.c/namei to decode the pathname into the appropriate locked and
incremented i-node. If the filename does not exist (creating a new file)
then iget.c/maknode is called to allocate a i-number and free i-node, put
the i-node into the System INODE Table (i-node.h) and write a directory
entry.
.
.LP
Sys2.c/open1 is called to complete linkage from the System File Table
(file.h) and the user's File Descriptor Table (u.u_ofile).
.sp 1m
.ne 10
.
.LP
.LG
.B link
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
link()
.sp 1n
.
.LP
.I RETURNS
.
.LP
If successful none. An error occurs if the file already sexists (EEXIST) or
a link to a file on another device is requested (EXDEN). The error code is
set in the per user control block (u.u_error).
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Link system call interface - a link is a pointer in a directory to a file.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
Link is called with two arguments: the pathnarne of the file to be linked
to, and the name to call the link. Nami.c/namei is called with the first
argument to translate the pathname into a i-node pointer. The returned
pointer to a incremented, locked i-node. Links to directories are illegal
(except by the super-user) so if the file is a directory and the user is
not super-user, an error flag is set, iget.c/iput is called to unlock this
i-node and decrement the usage count by one.
.
.LP
The i-node is unlocked so that nami.c/namei can be called again with the
second argument to return a locked, incremented i-node for the second
argument pathname. If the file already exists the error code EEXIST is set
in the per user control block (u.u_error) and iget.c/iput is called to
unlock the i-node and decrement the use count. Links cannot exist across
devices because identical i-numbers appear in separate file systems and the
link is only an i-number reference. If the directory i-node of the second
argument is not on the same device as the first argument file then the
error code EXDEV is set in the per user control block (u.u_error).
Otherwise, iget.c/wdir is called to write a directory entry from the
information left behind by the call to narnei. The link count of the i-node
is incremented by one and the i-node is marked so that the "last modified"
date and time can be updated. Iget.c/iput is called to unlock the i-node,
and reduce the use count by one.
.sp 1m
.ne 10
.
.LP
.LG
.B mknod
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
mknod()
.sp 1n
.
.LP
.I RETURNS
.
.LP
On success none. On failure, if the name already exists sets the error code
EEXIST in the per user controi block (u.u_error).
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Mknod system call interface - make a directory (called from mkdir) or a
special file (/etc/rnknod).
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
Mknod is called with three user supplied arguments: a pointer to the
pathname of the file, the mode of the new file, the major and minor device
classes for special file (zero for directory).
.
.LP
Mknod can only be called by the super-user for directory creation.
Nami.c/namei is called to decode the pathname, create a i-node entry in the
System INODE Table (i-node.h), and return a pointer to the locked,
incremented i-node. If the pathname does not exist the error code (EEXIST)
is set- in the per user control block. iget.c/maknode is called to fill in
the new i-node with the "mode" from the second argument. Maknod also calls
iget.c/wdir to write the directory entry for this i-node. The first address
field in the i-node, addr[0], is set to the third argument.
.sp 1m
.ne 10
.
.LP
.LG
.B open
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
open()
.sp 1n
.
.LP
.I RETURNS
.
.LP
On error the appropriate code has been set in per user control block
(u.u_error). On success the file descriptor for this file is returned to
the user in register R0.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Open system call interface - to open existing files.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
Open takes a string of characters representing a pathname and on successful
return has brought in the i-node for that file into the System INODE Table
(i-node.h), built an entry in the System File Table ffile.h), and has built
a file descriptor entry in the File Descriptor Table in the per user
control block (u.u_ofile). Open calls nami.c/namei to decode the pathname,
find the i-node of the associated file, and is returned a pointer to the
appropriate i-node in the System
.
.LP
INODE Table (i-node.h). The pointer is to a locked, incremented i-node.
Sys2.c/openl is
.
.LP
called to complete the Ihikage from the System File Table (file.h) and the
user's File Descriptor Table (u.u_ofile).
.sp 1m
.ne 10
.
.LP
.LG
.B openl
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
openl (ip, node, trf)
.br
int *ip, node, trf;
.sp 1n
.
.LP
.I RETURNS
.
.LP
If successful return nothing. If permissions are illegal set the error code
in the per user control block (u.u_error).
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Complete linkage of control blocks tq open a file.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
Openl checks the requested "mode" against the file access permission by
calling fio.c/access with the pointer, "ip", to the i-node in the System
INODE Table (i-node.h). If, the access is illegal the error code is set in
the per user control block (u.u_error) and iput.c/iput is called to
decrement the usage count in the System INODE Table and unlock the i-node.
Anytime i-nodes must be changed they are locked to prevent simultaneous
change by several processes.
.
.LP
If openl was called by CREAT (sys2.c/creat), the file is new or to be
re-written. The "trf" flag is set to indicate this and openl calls
iget.c/itrunc to truncate the file. Pipe.c/prele is called to unlock this
i-node.
.
.LP
This file may be a special file (a physical device) and fio.c/openi is call
to make this check and open the device if necessary. Fio.c/falloc is called
to find the next available file descriptor in the user's File Descriptor
Table (u.u_ofile), and the first available slot in the System File Table
(file.h). The System File Table is then set to point to the allocated
i-node in the System INODE Table (inode.h).
.sp 1m
.ne 10
.
.LP
.LG
.B rdwr
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
rdwr (mode)
.br
int mode;
.sp 1n
.
.LP
.I RETURNS
.
.LP
On an error, rdwr will set the appropriate error code in the per user
control block (u.u_error). On success the count of the number of bytes
read/written is returned is user register R0.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Read or write data from a file pointed to by a file descriptor.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
Arguments to the read or write system call are the file descriptor, the
address of a buffer, and the number of bytes to read or write. The file
descriptor is in the user's register R0 and the buffer address and number
of bytes are in the per user control block (u.u_arg[0], u.u_arg[1]). The
file descriptor is connected to a pointer to the System File Table entry
(file.h) for this open file by fio.c/getf. If the file descriptor is
invalid or the mode of the file does not match the mode input argument then
the per user control block error code is set (u.u_error) to bad file
description (EBADF).
.
.LP
If the System File Table entry indicates that this file is a pipe then the
read or write is accomplished by pipe.c/readp or pipe.c/writep. Otherwise
the read or write is done by ordinary file I/O routines rdwri.c/readi or
rdwri.c/writei. In either case, the number of bytes read written is placed
in the per user control block (u.u_count) and returned to the user in R0.
.sp 1m
.ne 10
.
.LP
.LG
.B read
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
read()
.sp 1n
.
.LP
.I RETURNS
.
.LP
None
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Read system call interface.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
Read call the sys2.c/rdwr routine with a read mode. Rdwr does all the work.
.sp 1m
.ne 10
.
.LP
.LG
.B seek
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
seek()
.sp 1n
.
.LP
.I RETURNS
.
.LP
If successful none. If failure the error code is set in the per user
control block.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Seek system call interface - moves the read/write position pointer by
blocks or bytes absolutely or relative to the current positions.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
Seek is called with three arguments: the file descriptor which is placed in
user register R0, the amount of the offset (u.u_arg[0]) and a flag defining
blocks or bytes, and abslute or relative (u.u_arg[1]). The flag is as
follows:
.
.LP
				Bytes Blocks
.br
	Absolute Position			0	3
.br
	Relative to Current Position	1	4
.br
	Relative to End of File		2	5
.
.LP
Seek calls fio.c/getf to check the validity of the file descriptor value
and that it points to a open file. A pointer to the entry in the System
File Table (file.h) is returned.
.
.LP
If seek was called on a file descriptor that points to a pipe the error
code (ESPIPE) is set in the per user control block (u.u_error) because
seeks are illegal on pipes. Seek uses the flag argument (u.u_arg[1]) to
determine how to apply the offset to the read/write position pointer in the
slot in the System File Table (file.h).
.sp 1m
.ne 10
.
.LP
.LG
.B write
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
write()
.sp 1n
.
.LP
.I RETURNS
.
.LP
None
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Write system call interface.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
Write calls sys2.c/rdwr routine with a write mode. Rdwr does all the work.
