.hpf hyphen.local
.P1
.de PT
.tl 'NAMI01 - FILE NAME STRING INTERPRETER'\*[CH]'PD-1C301-01'
.tl 'File: nami.c''Section 10'
.tl '''Issue 1, January 1976'
..
.2C
.ne 10
.
.LP
.LG
.B nami
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
nami(func, flag)
.br
int (*func)(), flag;
.sp 1n
.
.LP
.I RETURNS
.
.LP
Pointer to the (locked) Mode table entry for a file or its parent
directory; zero if an error occurs. See the following description for
specifics regarding return values.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Nami is the basic mechanism for converting a file pathname to an i-number
and a system Mode table entry. It is used to either locate an existing
file, or, prior to creating or deleting a file, to locate the parent
directory.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
The file pathname that nami is to manipulate is pointed to by the U block
directory pointer variable (u_dirp). The first argument ("func") is the
address of the function to be used to obtain the characters of the file's
pathname (nami.c/schar if the name is in kernel space, nami.c/uchar if in
user space). The second argument ("flag") indicates what operation is to be
performed:
.IP 0 3
if the name is to be located
.IP 1 3
if the name is being created
.IP 2 3
if the name is being deleted
.
.LP
The algorithm used to translate the pathname to the file's i-number is as
follows:
.IP 1. 4
If there are unprocessed filename components remaining in the pathname,
then the component just matched must be a directory. This pathname
component will be referred to as the "current component". In the first pass
through the algorithm, the "current component" is either the current
directory (u_cdir) or the root directory, as determined by the pathname. At
this point it is verified that the user has execute permission for that
directory (ie. the "current component").
.IP 2. 4
Get the "next component" of the pathname and place it in a workspace
(u_dbuf).
.IP 3. 4
Read the "current component" file (which is a directory) block by block,
searching for an entry for the "next component".
.IP 4. 4
When the "next component" is matched, obtain its i-number and make the next
component" the "current component".
.IP 5. 4
Repeat the above process until the end of the pathname is reached.
.
.LP
Exits from the preceding algorithm are made at appropriate locations
whenever either an error is detected or the function call has been
satisfied (as determined by "flag"). It should be noted that the purpose of
nami is always to locate files, never to actually create or destroy them,
even when called for creation or deletion (flag 1 or 2). When called for
these reasons, nami only traces the file's pathname and verifies that the
file may be created or destroyed (that is, ensures that the user has write
permission in the file's parent directory).
.
.LP
The return values from narni depend upon the reason it was called.
.
.LP
Reason	Return Values
.RS
.XP
Find (flag=0)	Zero if the file is not found. If the file is found, a
pointer to a (locked) system mode table entry (model]) for the file.
.XP
Create (flag=1)	Zero if the file does not exist; in this cases, u_pdir
points to the system inode table entry of the file's parent directory,
u_offset[11 is the offset to an empty directory slot in the parent
directory, and u_dbuf is the last component of the filename. If the file
already exists, a pointer to the file's (locked) system Mode table entry is
returned. Naafi is often called with flap.. 1 wheg a file's existence is in
quesOon and it is to be created if it doesn't exist.
.XP
Delete (flag=2)	Zero if the file is not found. If found, a pointer to a
(locked) system Mode table entry for the file's parent directory is
returned, u_dent contains the file's directory entry in the parent
directory, and u_offsetEl I contains the offset in the parent directory to
the entry immediately following that of the file.
.RE
If any errors (e.g. access, permission, invalid pathname, etc.) are
encountered during nami processing, the appropriate bit(s) will be set in
u_error.
.sp 1m
.ne 10
.
.LP
.LG
.B schar
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
schar()
.sp 1n
.
.LP
.I RETURNS
.
.LP
A character from kernel space.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Schar is used, usually when parsing directory names, to obtain the next
character in the name.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
Schar returns the character pointed to by the U block's directory name
pointer (u_dirp). The address is interpreted as a kernel space address and
is then incremented to the next character. This function is typically used
by narni.c/nami when parsing a file pathname that is contained in kernel
space. Note that it is the caller's responsibility to check the character
returned by schar for an end-of-string indicator (which is usually a null
character). The nami.c/uchar function performs a similar service for names
in user space.
.sp 1m
.ne 10
.
.LP
.LG
.B uchar
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
uchar()
.sp 1n
.
.LP
.I RETURNS
.
.LP
A character from user space or a -1 on error.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Uchar is used, usually when parsing directory names, to obtain the next
character in the name.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
Uchar returns the character pointed to by the U block's directory name
pointer (udirp). The address is interpreted as a user space address and is
then incremented to the next character. This function is typically used by
nami.c/nami when parsing a file pathname that is contained in user space
(see nami.c/schar for the kernel space version). A return of -1 indicates
an error; typically, a memory fault while trying to access the specified
address. If this occurs, the error bits (u error) are also set. Note that
it is the caller's responsibility to check the character returned by uchar
for an end-of-string indicator (which is usually a null character).
