.hpf hyphen.local
.P1
.de PT
.tl 'MCH01 - MACHINE INTERFACE CODE'\*[CH]'PD-1C301-01'
.tl 'File: m40.s/m45.s/m70.s''Section 9'
.tl '''Issue 1, January 1976'
..
.2C
.ne 10
.
.LP
.LG
.B aretu
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
aretu (save)
.br
int *save;
.sp 1n
.
.LP
.I RETURN
.
.LP
No value is returned.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Restores the stack position or a process. Used as part of a nonlocal goto
within the operating system.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
This function is similar to mch.s/retu. The only difference is that it does
not alter Kernel Instruction Address Register 6 (KISA6) on 11/40's or
Kernel Data Address Register 6 (KDSA6) on 11/45's and 11/70's which perform
the virtual address mapping for the U block. It is used to transfer
execution back several levels of subroutines without returning via the
intervening functions. In the case of processes .which are catching their
own signals it is used to transfer control to the user process as soon as
the presence of a signal is detected even at the expense of aborting a
system call. For processes that have performed their own swapping, without
interacting with the Scheduler, it is used to transfer control to the area
of code within the system that did the swap rather than simply returning
from a roadblock (slp.c/sleep).
.
.LP
The nonlocal goto is performed by using mch.s/aretu to restore the system's
R5 and SP from values previously saved(in "u_rsav", u_usav" or "u_gsav").
Since the PC for a return from a C function is also on the stack(just above
where the stack frame pointer RS is pointing), when a return by a C
function(jump cret) is executed. A return is made to the function specified
on the stack, instead of returning to the actual caller. This PC is the
return address of some higher level function mch.s/savu. The operation
appears as if the function which last called mch.s/savu returned to it's
caller.
.
.LP
Since changing stack positions is a delicate operation, the processor's
priority is raised to 7 to lock out all interrupts while the stack position
is changed. The processor's priority is then lowered to zero so that all
pending interrupts may be processed.
.sp 1m
.ne 10
.
.LP
.LG
.B backup
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
backup(framep)
.br
int *framep;
.sp 1n
.
.LP
.I RETURN
.
.LP
A zero is returned to indicate success.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Attempts to back up an instruction. This is always possible on 11/45 and
11/70 processors but not always on 11/40's due to the makeup of the 11/40
hardware.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
If a Stack Violation(Segmentation Violation) occurs while executing a user
process, it is necessary to undo the portion of the instruction that had
been executed before increasing the process's stack size. The Memory
Management Unit generates a trap when an illegal virtual memory address
occurs and on 11145 and 11/70 processors a register (Memory Management
Status Register 1) is loaded as each instruction is executed with
information about what register has been modified and by how much. This
register is unavailable on the 11/40 processor and since there are
autoincrement and autodecrement instructions on PDP-11's not every
instruction may be restarted. (The restrictions governing 11/40's will be
listed below.) A Stack Violation is distinguished from other possible
Segmentation Violations by the trap handler which checks the position of
the SP relative to the size of the stack. The trap handler calls
mch.s/backup to adjust the stack frame before restarting a process, and if
this cannot be done(on 11/40's this is a possibility) an indication of
failure is returned so that the process may be aborted. The trap resulting
from the Segmentation Violation may have been the result of an illegal
memory(stack) reference by either the source or destination fields of an
instruction, so that only part of the instruction may have been executed.
The ability to determine what part of an instruction aborted is a crucial
factor in the determination of whether an instruction can be backed up or
not. Another important determination is that of how much and which source
and/or destination registers have been incremented or decremented by the
use of the autoincrement, deferred autoincrement, autoincrement and
autodecrement deferred addressing modes. For 11/45 and 11/70 processors,
Memory Management Unit Status Register 1 contains this information. (11/40
processors do not have this register so that the software must make this
determination.) Restarting an instruction on 11/45 and 11/70 processors is
simply done by using the information in Status Register 1 about how much a
source and/or destination register has been changed to adjust the registers
to their values before the instruction was executed. Status Register 1
contains two bytes. The high order 5 bits of the first byte contain the
amount (positive or negative) that the source register has been changed by
incrementing or decrementing. The lower three bits contain which source
register was modified. The second byte contains similar informamation about
the destination register. When a trap occurs, the user process' registers
(context) are saved on the system stack so that to restart an instruction,
the registers modified by autoincrement or autodecrement need only be
adjusted and the PC moved back to restart the instruction. The argument
"stackp" _passed to mch.s/backup is an address on the stack frame where the
registers may be found and the array "reloc"(see trap.c/trap) is used as an
offset map to find the proper register (see mch.s/call description) on this
stack frame.
.
.LP
11/40, 11/45 and 11/70 processors use common features of the mch.s/backup
routine to adjust an instruction, however, on 11/40's there is additional
software which attempts to simulate the operation of Status Register 1. In
most cases the simulation can back up the instruction, however, there are
some classes of instructions which cannot be backed up by software.
.
.LP
Rather than give a detailed description of the algorithms used in the 11/40
software to determining which class of instructions the faulting
instruction belonged to and how much incrementing or decrementing of
registers occurred, a discussion of which instructions can and cannot be
backed up will be given. The DEC Processor Handbook may be consulted for
instruction formats and the KB11-A Central Processor Maintenance Manual
Fig. 6-10 may be consulted for the microprogrammed decoding of the opcode
field for those interested in how opcodes are mapped into instruction
types. Some of the simplifying assumptions made in the simulation of an
instruction will be pointed out.
.
.LP
The key factors in the instruction fetch/execute cycle that must be
remembered are,
.IP 1. 3
Instructions consist of at most two operands; source and destination. The
Stack Violation could only be a result of a bad address constructed for the
destination in the case of single operand instructions but may be the
result of either the source or destination for double operand instructions.
.IP 2. 3
If the addressing modes consist of any incrementing (autoincrement,
autoincrement deferred) or decrementing (autodecrement, autodecrement
deferred), these are performed up to the point that the instruction
aborted. For example, the instruction
.CD
mov (sp)+,(r5)+
.DE
would have the first incrementation (only) performed if the reference using
the SP caused the abort. If the reference using R5 caused the abort both
incrementations would occur. A similar case occurs if the registers are
decremented.
.
.LP
With these two factors in mind , the following conclusions may be drawn.
.IP 1. 3
All single operand instructions can be backed up as their only memory
reference must have caused the abort.
.IP 2. 3
For double operand instructions, a determination of which operand caused
the abort must be made. To do this, the mch.s/backup routine must simulate
the fetch of both the source and destination. If an error occurs while
doing the simulated fetch of the source then the instruction must have
aborted at this point and the destination could not have been incremented
or decremented. Unfortunately, to do this simulation on instructions which
increment or decrement both source and destination, it must be assumed that
the registers involved can be unincremented (or undecremented) before
simulating the instruction fetch of source or destination. Instructions of
the following form
.CD
operator (rA)+,(rA)+
.DE
(any combination of autoincrement and autodecrement is included and rA is
an abbreviation for any register) present a problem since it cannot be
determined how far the register should be backed up. (That is, one cannot
tell whether both incrementations occurred since the same register rA is
specified in source and destination fields.)
.
.LP
The characteristics of instructions on the 11/40 that cannot be backed up
are as follows. (The instruction must satisfy
.I all
of the following conditions.)
.IP a. 3
Double operand.
.IP b. 3
Uses same register for source and destination.
.IP c. 3
Destination involves incrementing or decrementing.
.IP d. 3
Source involves an addressing mode other than mode 0 (register mode
addressing). Only a few instructions fall into this category and they are
.I not
generated by the C compiler. The user must avoid using them in coding
assembly language programs that will run on 11/40 processors.
.
.LP
In simulating the fetch cycle for the source field on double operand
instructions, an assumption about addressing is made for simplicity. When
simulating an autoincrement source fetch, the register can be adjusted to
its original value before the simulation, Thus, in the following
instruction
.CD
cmp (sp)+,(r5)+
.DE
the SP is moved back before simulating the source fetch. For the
decrementation modes, it is assumed that if the adjustment is not made the
same error will occur. Thus, for example, it is assumed that the
instruction
.CD
cmp -(sp),(r5)+
.DE
will give the same violation with or without adjusting the Stack
Pointer(SP).
.
.LP
Floating point instructions cannot be executed on the 11/40 (no floating
point processor option is available) so they are not backed up. Branches
(br, jsr, jmp) are not backed up either as it is assumed that it is an
error for the user process to attempt to jump to an address that is not
already within his virtual address space.
.sp 1m
.ne 10
.
.LP
.LG
.B call
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
jsr R0, call; _function
.sp 1n
.
.LP
.I RETURNS
.
.LP
No value is returned.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Builds a stack frame so that a smooth interface to a C language interrupt
handler or the trap handler may occur. Also does any context saving
including floating point registers.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
The assembly language function mch.s/call is complicated as it serves as a
common interface to the trap and C language interrupt handlers. There are
also differences in its operation based on whether the processor has a
floating point unit or not. The basic operation of the routine that is
common to 11/40, 11/45, and 11/70 processors will be explained first and
differences discussed. afterwards. The common features of the call function
are:
.IP 1. 3
It builds a stack frame for an interface to interrupt handlers and the trap
handler. When an interrupt or trap occurs the PDP-11 hardware causes a new
Program Counter (PC) and Processor Status (PS1 to be loaded from the low
core vector area (see low.s discussion) and the old PC and old PS to be
pushed onto the stack specified by the Current Mode field of the low core
PS. (The Kernel mode stack is used for all cases under UNIX.) As part of
the operation of loading the new PS from low core, the PDP-11 hardware sets
the Previous Mode field of the Processor Status so that it indicates the
mode that the processor was in when the interrupt occurred. Upon entering
an C language function, the save restore sequence (mch.s/csv, mch.s/cret)
saves registers R2-R7 so that only registers R0 and R1 need to be saved by
mch.s/call. It should also be mentioned that the stack that is used by the
operating system resides in the bottom portion of the U block of the
currently executing process. The stack frame that is built in the U block
stack area every time an interrupt or trap occurs consists of the following
entries in the following order:
.RS
.IP a. 3
old Ps - Processor Status when the interrupt or trap occurred(saved by
hardware interrupt mechanism).
.IP b. 3
old PC - Program Counter when the interrupt or trap occurred(saved by
hardware interrupt mechanism).
.IP c. 3
Register R0 of General Register set 0(UNIX only uses General Register set
0).
.IP d. 3
new PS - Processor Status that was loaded from low core when the interrupt
occurred. The Previous Mode field has, however, been set to the appropriate
value.
.IP e. 3
Register R1 of General Register set 0.
.IP f. 3
SP from Previous Mode - There is one stack pointer for each of the three
processor modes; User, Kernel, Supervisor. This stack pointer is saved as a
convenience for the trap handler so that Stack Violations may be easily
fixed and argument's for system calls may be readily found.
.IP g. 3
The remainder of General Register Set 0 is saved when the mch.s/call
function calls the interrupt or trap handler(all C language). The register
save sequence is described under mch.s/csv. The order is basically; the PC
containing the return address, R5, R4, R3, R2. Register R6 (the Stack
Pointer - SP) does not need to be saved as it can be located relative to
the contents of R5.
.IP h. 3
Minor device number - The lower 5 bits of the low core PS contains the
minor device number of the device initiating the interrupt or the type of
trap that occurred. This is placed on the stack as a convenience to both
the trap and interrupt handler. Doing this saves the interrupt handler from
having to check the attention flags on each device.
.LP
Besides building the stack frame, the mch.s/call function is responsible
for clearing off the stack frame and executing a return from the trap or
interrupt(RTT instruction) when the trap or interrupt handler is finished.
.RE
.IP 2. 3
The mch.s/call function calls the appropriate trap or interrupt handler.
The low core vectors reference what are essentially jump table entries just
below the floating vector section of low core. The jump table entries are
of the form
.CD
jsr R0, call; _handler
.DE
The entry _handler is the address of the appropriate interrupt handler. The
mch.s/call function calls the appropriate interrupt handler by retrieving
this entry.
.IP 3. 3
The mch.s/call function determines whether the process that was running
when the interrupt or trap occurred may be preempted. Any interrupt that
results in a process being awakened indicates that the currently running
process should be preempted. Because of reentrancy requirements in the
system, preemption can only occur if the interrupt occurred while the
processor was in User mode or when a system call completes. Since system
calls are made by trapping and the trap interface uses the interface
provided by mch.s/call, the logic for making this determination is built
into the mch.s/call function. The Previous Mode field of the PS will
indicate whether the interrupt occurred out of User or Kernel mode and the
external variable "runrun" is used by the slp.c/walreup function to
indicate whether the interrupt resulted in another process being awakened.
As mentioned previously, interrupts occurring while the processor is
handling a system call(or a trap) cannot result in a preemption until the
system call is completed. The mch.s/call function calls the process
Switcher (slpc/switch) directly to preempt a process when an interrupt is
finished or when the system call completes.
.IP 4. 3
For processors that have floating point registers (11/45 and 11/70 only),
the mch.s/call function calls the mch.s/savfp function to save the floating
point registers(in the U block) and restores the registers when the process
resumes. The floating point registers only need to be saved if the process
is being preempted as the operating system does not use floating point.
When restoring the stack frame the processor's priority must temporarily be
raised to 7 to prevent another trap or interrupt from destroying the values
on the stack frame.
.sp 1m
.ne 10
.
.LP
.LG
.B call1
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
jsr r0,call1; trap
.sp 1n
.
.LP
.I RETURN
.
.LP
No value is returned.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Saves register R0 for the trap handler.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
This is a special entry point to the mch.s/call function used for the trap
handler(see fnch.s/trap).
.sp 1m
.ne 10
.
.LP
.LG
.B clearseg
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
clearseg (addr)
.br
int *addr;
.sp 1n
.
.LP
.I RETURNS
.
.LP
No value is returned.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Zeros a 32 word memory block.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
Mch.s/clearseg is very similar in operation to mch.s/copyseg. The argument
"add" contains the high order address of a 32 word memory block to be
cleared. The argument "addr" can be loaded directly into the address
portion of a Memory Management Address Register.
.
.LP
For 11/45 and 11/70 processor's the Supervisor Memory Management registers
are available to perform address mapping. Data Address Register 0 of the
Supervisor Memory Management registers is used to perform relocation and
the Previous Mode of the Processor Status is adjusted so that Supervisory
mapping will be used when fetching and storing across address spaces
(MFPI,MTPI,etc.).
.
.LP
There is no Supervisory state on 11/40 processors so User Instruction
Address Register 0 is saved and restored so that it can be used for
mapping. In this case, the processor's priority must be raised to 7 to
prevent any interrruption while the User Memory Management Register is
modified.
.sp 1m
.ne 10
.
.LP
.LG
.B copsu
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
jsr pc, copsu
.sp 1n
.
.LP
.I RETURN
.
.LP
No value is returned.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Common subroutine used by mch.s/copyout and mch.s/copyin.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
In moving data between the user's address space and the system's buffers,
both the mch.s/copyin and mch.s/copyout routine execute a tight loop which
move data between address spaces. The mch.s/copsu function sets up
registers for both of these functions and has access to the three arguments
passed to them. The calling sequence of these two functions are
.CD
copyin(vuser, vsys, count)
.br
copyout(vsys, vuser, count)
.DE
The "vsys" and "vuser" arguments are the virtual addresses within the
system and user address spaces respectively. The "count" is the byte count
for the transfer.
.LP
.LP
Mch.s/copsu sets up registers R0, R1, and R2 to contain these parameters.
Registers R0 and R1 are scratch registers when copyin or copyout are called
since they are only called from parts of the system that are written in C.
Register R2 must, however, be saved on the stack. The registers are setup
as follows:
.RS
.XP
R0 - Argument 1 (either "vuser" or "vsys")
.XP
R1 - Argument 2 (either "vsys" or "vuser")
.XP
R2 - Argunent 3 byte "count" multiplied by 2 to give the word count, since
both mch.s/copyin and mch.s/copyout transfer words across address spaces.
.RE
Since both the mch.s/copyin and mch.s/copyout functions move data across
address spaces, the possibility of aborting due to bad virtual addresses
specified in the call exist. In order to allow both mch.s/copyin and
mch.s/copyout to detect these errors, mch.s/copysu sets up the external
variable "nofault" (see mch.s/trap discussion) so that if any trap occurs
mch.s/copyin or mch.s/copyout will be notified by the trap handler and they
can return an error indication (-1) to their caller(rdwri.c/iomove).
.sp 1m
.ne 10
.
.LP
.LG
.B copyin
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
copyin(vuser, vsys, count)
.br
int *vuser, *vsys;
.br
int count;
.sp 1n
.
.LP
.I RETURNS
.
.LP
Zero on success, -1 on failure.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Copys data form user virtual address spaces to system address space(word by
word).
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
In order to buffer I/O between a user's process and the devices on a system
there are a number of system buffers. Moving data from the user's virtual
address space to the buffers which are in the system's virtual address
space is done by mch.s/copyin (a higher level routine rdwri.c/iomove does
address calculation, buffer allocation, etc.).
.
.LP
The number of bytes specified by "count" are moved, word at a time,
starting at the user's virtual address "vuser" to the system's virtual
address "vsys". The move is done by using the Move From Previous
Instruction Space(MFPI) processor instruction in a tight loop. The routine
mch.s/copysu initializes this loop and provides error recovery in case a
trap should occur in moving data across address spaces.
.sp 1m
.ne 10
.
.LP
.LG
.B copyout
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
struct	block{
.br
    int	b[32];
.br
};
.br
copyout(vsys, vusr virtual, count)
.br
struct	block *vuser, *vsys;
.br
int	count;
.sp 1n
.
.LP
.I RETURNS
.
.LP
Zero on success, -1 on failure.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Copies data from system(Kernel) virtual address space to user address space
(word by word).
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
Comparable function to mch.s/copyin, performing the complimentary operation
of transferring data from the system to a user process.
.sp 1m
.ne 10
.
.LP
.LG
.B copyseg
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
struct	block(
.br
    int	b[32];
.br
);
.br
copyseg(source, destination)
.br
struct block *source, *destination;
.sp 1n
.
.LP
.I RETURNS
.
.LP
No value is returned.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Copies a memory block(32 words) from one area of physical memory to
another.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
Creating a new process, expanding the size of an existing process or
correcting a stack violation require copying a process from one area of
core to another. Since the transfer of data may be to any place in core
(128K word maximum on 11/40, 11/45, and 2M word on 11/70's) the Memory
Management Unit must be setup to transfer the data.
.
.LP
The Supervisor Memory Management registers are available for this operation
on 11/45 and 11/70's processors so that the transfer may be effected by
simply loading two of the Supervisor Memory Management registers so that
they address the 32 word "Source" and the 32 word "destination". By setting
the Previous Mode field in the Processor Staffs and using a tight loop
which first fetches (MFPD - Move From Previous Instruction Space) from the
source area, then stores(MTP1 - Move To Previous Instruction Space) into
the destination area, the data may be transferred. Two of the Data Space
Address Registers of the Supervisor Memory Management Unit are used for
mapping the source and destination on 11/45 and 11/70's.
.
.LP
On 11/40's the Supervisory state does not exist so that two of the User
Instruction Space Address Registers are used for mapping the transfer.
(Their original contents must be saved and restored on the stack.)
.sp 1m
.ne 10
.
.LP
.LG
.B cret
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
imp cret
.sp 1n
.
.LP
.I RETURNS
.
.LP
No value is returned.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Restores general registers for C functions.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
At the end of every compiled C function, mch.s/cret is called to restore
the registers that were saved by mch.s/csv and thereby to reset the stack
frame to that of the calling function. Register R6(SP) is not saved as part
of the register save sequence because it is used in conjunction with
register R5 (the stack frame pointer). The registers are restored in the
same sequence- that they are saved (see imch.s/csv). Any local storage
allocated on the stack frame (below the register save area) is cleared of
by in line instructions generated by the C compiler. Arguments to functions
are also passed on the stack frame and in line instructions are generated
following the subroutine call to clear them from the stack.
.sp 1m
.ne 10
.
.LP
.LG
.B csv
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
jsr r5, csv
.sp 1n
.
.LP
.I RETURNS
.
.LP
No value is returned.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Performs register save at the beginning of every C function.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
Every function(i.e., subroutine) that is compiled for the C language calls
this function to save the general registers before any computation is done.
Registers R0 and R1 are regarded as scratch by the C language and therefore
need not be saved when a function is called. When any subroutine is called
in C, register R5 is setup to point to the current stack location. This is
the beginning of a stark frame for the called subrputine. At the beginning
of this stack frame the general registers are saved in the order RS(saved
by the call to mch.s/csv), R4, R3, R2. The stack pointer(SP) is set up to
point to the first free location on the stack below this Register save
area. The SP is used as a local stack pointer within the stack frame. Since
it can be located in relation to R5, there is no need to save it. Only
General Register Set 0 is used by the processor so the mch.s/csv function
is the same in the operating system as for compiled user programs. Once a C
function has saved the general registers and created a stack frame by
calling mch.s/csv, storage for local variables in the stack frame is
allocated. (The C compiler generates in line instruction within each C
functions to do this.)
.sp 1m
.ne 10
.
.LP
.LG
.B display
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
display()
.sp 1n
.
.LP
.I RETURNS
.
.LP
No value returned.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Displays the contents of a memory location on the console lights.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
Display reads the contents of the console switches and displays the
contents of that virtual memory address on the console's data display
register lights. The virtual address is taken from kernel address space if
bit zero of the console switches is zero,,,otherwise the address is taken
from user addreis space. This function does an immediate rettitn without
displaying the contents of a memory rocation on an 11/40 system. On an
11/45, the data display select knob must be set to DISPLAY REGISTER in
order to have the memory location's contents displayed.
.sp 1m
.ne 10
.
.LP
.LG
.B dpadd
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
dpadd(dbl, sing)
.br
int dbl[2], sing;
.sp 1n
.
.LP
.I RETURNS
.
.LP
No value returned.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Adds a single word integer to a double word integer.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
Dpadd adds the single word "sing" to the double word that is pointed to by
"dbl".
.sp 1m
.ne 10
.
.LP
.LG
.B dpcmp
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
dpcmp(f[0], f[1], s[0], s[1])
.br
int f[2], s[2];
.sp 1n
.
.LP
.I RETURNS
.
.LP
The difference between the two double word values if the difference is
between -512 and 512. Otherwise, a -512 or 512, depending on whether the
difference is negative or positive.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Subtracts two double word values and guarantees the returned result to be
in the range -512 to 512.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
Dpcmp is useful for comparing two double word values "f" and "s", which the
system does frequently when doing file I/O. The difference between these
double words (i.e., f - s) is returned if it is between -512 and 512. If
the difference is less than -512 or greater than 512, then -512 or 512,
respectively, is returned.
.sp 1m
.ne 10
.
.LP
.LG
.B dump
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
jmp dump
.sp 1n
.
.LP
.I RETURNS
.
.LP
No value is returned.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
A postmortem memory dump to magnetic tape.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
This is a utility program for dumping the contents of memory on magnetic
tape if the system crashes. Registers R0-R6 and Kernel Instruction Address
Register 6 are saved (in that order) in low core starting at absolute
location 4. The mch.s/dump function is started after crashing by loading
absolute address 044 into the program counter and depressing the start
switch. All of core, or all of core until the first magnetic tape error
occurs is dumped onto tape unit zero in 512 byte blocks. An end of file is
also written on the tape. The mch.s/dump function will not operate unless
relocation has been turned off(bit 0 of Memory Management Status Register 0
is 0). A mch.s/dump routine exists for both the TM11 and TU16 magnetic tape
units. Before assembling mch.s the proper dump routine is selected by
setting one of the conditional assembly flags (.tm). For 11/45 and 11/70
systems, the mch.s/dump routine is loaded in low core and is mapped by D
Space Address Registers since it is only used post mortem when relocation
is of This is done in order to allow the operating system to have as large
a virtual address space(Instruction Space) as possible.
.sp 1m
.ne 10
.
.LP
.LG
.B fetch
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
mov addr,R0
.br
jsr pc, fetch
.sp 1n
.
.LP
.I RETURNS
.
.LP
The instruction at User virtual address "addr" is returned in register R0.
A -1 is returned if the virtual address does not exist.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Simulates the instruction fetch or operand fetch cycle of an instruction.
Used in backing up an instruction.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
This function is used by mch.s/backup in simulating the instruction fetch
and operand fetch cycle of a PDP-11 instruction when backing up an
instruction on 11/40 processors. Because of the possibility of improperly
accessing across virtual address spaces, mch.s/fetch must be ready to catch
a trap that might be generated. It does this by setting the external
variable "nofault" to the address of its own internal error handling
routine. The trap handler checks "nofault" to see if it is set and
transfers to this error routine instead of the trap handler(trap.c/trap) if
the fetch aborts.
.sp 1m
.ne 10
.
.LP
.LG
.B fubyte
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
fubyte (virtual)
.br
char *virtual;
.sp 1n
.
.LP
.I RETURNS
.
.LP
The byte specified by the argument "virtual" isreturned. A -1 is returned
if the byte cannot be accessed.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Fetches a byte from a users virtual address space.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
This function is used to determine the amount of memory when the system
comes up and for moving characters between the I/O subsystem and the user's
virtual address space(subr.c/cpass).
.
.LP
Most of the work in fetching a byte from the user's virtual address space
is performed by the subroutine mch.s/gword. Mch.s/fubyte merely determines
which byte is to be returned to the caller.
.sp 1m
.ne 10
.
.LP
.LG
.B fuword
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
fuword(virtual)
.br
int	*virtual;
.sp 1n
.
.LP
.I RETURNS
.
.LP
A -1 on failure.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Fetches a word from user's virtual address space,
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
Used to fetch arguments to system calls by trap handler and arguments for
the exec system call.
.
.LP
Mch.s/fuword uses the common subroutine mch.s/gword for accessing the
user's virtual address space and catching any errors in fetching across
virtual address spaces.
.sp 1m
.ne 10
.
.LP
.LG
.B getc
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
getc(cp)
.br
struct dist *cp;
.sp 1n
.
.LP
.I RETURNS
.
.LP
A -1 is returned if there are no characters on the teletype queue "cp".
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Used to get a single character off a teletype queue returning character
buffer storage area to the free list ("cfreelist") as needed.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
Several queues are associated with each character device, an input
queue("t_rawq"), a canonical queue("t_canq") and an output queue("t_outq").
The mch.s/getaunction will remove one character from the queue specified by
"cp".
.
.LP
Character buffer storage is allocated to a queue as a linked chain of
storage. Each increment of buffer ("cblock") contains one pointer word and
six characters of buffer space. Each queue header("clist") contains a count
of the characters that are allocated to the queue("c_cc"), a pointer to the
first character in the first buffer("c_cf") and the next available
character posit("c_cl") in the last buffer on the queue.
.
.LP
It should be emphasized that queues maintains pointers to the first and
last characters respectively and not the first and last buffer on the
queue. This can be done because in allocating and initializing space for
the character queues, care was taken to insure that each character buffer
began on an eight byte memory address boundary. With this arrangement, the
queue pointers reveal not only the (first and last) character but the
buffer which they are in. The first character pointer, last character
pointer, or the byte count are zero if there are no characters on a queue.
.
.LP
Mch.s/getc removes the first character on the queue (pointed to by sc_cr),
and returns it to the caller. If the character removed is the last one in a
character buffer, the character buffer is unlinked from the queue and
returned to the free list of character queue ("cfreelist"). The free list
of buffers is organized as follows:
.IP 1. 3
"Cfreelist" is a one word pointer to the beginning of a queue of free
buffers. If there is no free storage then "cfreelist" is zero.
.IP 2. 3
Each free buffer on the queue uses its pointer entry as a link to the next
free buffer. The last buffer on the queue contains a zero in its pointer
entry.
.IP 3. 3
When a character buffer is returned to the free list, it is placed at the
head of the queue.
.
.LP
Since mch.s/getc is called by many character driver interrupt handlers it
is necessary to raise the processor's priority to 5 to lock out interrupts
from character devices while mch.s/getc is unlinking pointers to a queue.
.
.LP
The character removed from the queue is returned(in R0) or a -1 is returned
to indicate that the queue was empty.
.sp 1m
.ne 10
.
.LP
.LG
.B gword
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
mov addr, rl
.br
jsr pc, gword
.sp 1n
.
.LP
.I RETURNS
.
.LP
A -1 is returned on failure.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Common subroutine used by mch.s/fubyte and mch.s/fuword to fetch data from
the virtual address space of a user process.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
The Move From Previous Instruction Space (MFPI) instruction on the PDP-11
is for fetching data from another address space. The Previous Mode field of
the Processor Status (PS) indicates the address space from which the data
is to be fetched. The operand field of the MFPI instruction specifies the
virtual address that is to be used for retrieving the data. Execution of
the MFPI instruction results in the desired word being placed on the
Current Mode stack(Kernel in this case). These instructions operate only on
even addresses and there is no analogous byte oriented instruction.
.
.LP
Whenever data is moved across address spaces, there is a possibility that
the desired address does not exist in the target address space. A
Segmentation Violation trap will occur if an illegal virtual address is
generated so that mch.s/gword must be ready to catch these faults. It sets
up the address of it's own error routine in "nofault" so that the trap
handler will transfer control to this error routine instead of calling the
system trap handler(trap.c/trap).
.sp 1m
.ne 10
.
.LP
.LG
.B idle
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
idle()
.sp 1n
.
.LP
.I RETURNS
.
.LP
No value is returned.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
The processor goes into the WAIT state until the next interrupt occurs.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
The process Switcher(slp.c/switch) selects processes to use the CPU. If
there are no processes in the system or no processes that are ready to run,
the mch.s/idle routine is called to place the processor in the WAIT state.
The mch.s/idle routine is called only by the process Switcher and executes
the WAIT instruction after it has saved the Processor's Status and lowered
the processor's priority to zero(to allow any interrupt to occur). When an
interrupt does occur, it is processed and then control is returned to the
mch.s/idle function. The Processor Status is returned to its original value
and control is returned to the process Switcher. When the processor has no
work to do (e.g., overnight), the clock will continue to interrupt once per
sixtieth of a second so that the process Switcher will run at this
frequency and will idle the processor in between.
.sp 1m
.ne 10
.
.LP
.LG
.B incupc
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
incupc(pc, prof)
.br
int pc, *prof;
.sp 1n
.
.LP
.I RETURNS
.
.LP
No value returned.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Does the actual profiling of a user process.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
Incupc is the function that actually performs profiling, whereas
sys4.c/profil only enables and disables the profiling process. When called
with a value for the user's program counter ("pc") and the address of the
profiling arguments ("prof") found in the. U block (u_prof[]), this
function evaluates the expression:
.CD
(pc - profile offset) * profile scale
.DE
If the result is less than the profiling buffer size, then that word within
the profile buffer is incremented by one.
.sp 1m
.ne 10
.
.LP
.LG
.B ldiv
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
ldiv(divid, divisor)
.br
int divid, divisor;
.sp 1n
.
.LP
.I RETURNS
.
.LP
The quotient of two integers.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Divides two integers.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
Ldiv returns the quotient from the division of "divid" by "divisor". The
dividend is always regarded as an unsigned number. This permits division of
sixteen bit values and assures that the quotient will always be positive.
There is no check to ensure that the divisor is not zero. See also
mch.s/lrem.
.sp 1m
.ne 10
.
.LP
.LG
.B lrem
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
lrem(divid, divisor)
.br
int divid, divisor;
.sp 1n
.
.LP
.I RETURNS
.
.LP
The remainder from division of two integers.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Finds the remainder froredivision of two integers.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
Lrem returns the remainder from the division of "divid" by "divisor". The
dividend is regarded as an unsigned number. This permits division of
sixteen bit values and assures that the remainder is always positive. There
is no check to ensure that the divisor is not zero. See also mch.s/ldiv.
.sp 1m
.ne 10
.
.LP
.LG
.B lshift
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
lshift(dbl, bits)
.br
int dbl(2], bits;
.sp 1n
.
.LP
.I RETURNS
.
.LP
The low 16 bits from the shift of a double word.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Shifts a double word to the right or left a designated number of bits.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
Lshift shifts the double word "dbl" to the right (i.e., division) or the
left (i.e., multiplication) by "bits" number of bits. If "bits" is
negative, the shift is to the right, otherwise it is to the left. The low
order 16 bits of the result are returned.
.sp 1m
.ne 10
.
.LP
.LG
.B putc
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
putc(c, cp)
.br
char	c;
.br
struct clist *cp;
.sp 1n
.
.LP
.I RETURNS
.
.LP
A zero is returned if a character is successfully placed on a teletype
queue; a nonzero value if not.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Places a character on a teletype que,ue allocating character buffer storage
as needed.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
Mch.s/putc performs the complimentary operation to mch.s/getc. It places
the character "c" at the end of the teletpe queue specified by "cp". The
queue is organized as described under mch.s/getc with a character
count("c_cc") and first and last character pointer("c_cf", "c_cl",
respectively). The first character pointer gives the address of the
character at the head of the queue, while the last character
pointer("c_cl") gives the address of the next available position at the end
of the queue. When placing a character on a character queue, the last
character pointer is changed to reflect the addition of a new character The
character count is also incremented by one. If, however, there is no space
available on the queue a new character buffer is allocated from the free
list("cfreelist"). Allocating a new buffer to the queue and inserting the
character is done as follows:
.IP 1. 3
A character buffer is deallocated from the queue of free
buffers("cfreelist"). The first buffer on the queue is chosen. The
organization of this queue is described under mch.s/getc.
.IP 2. 3
If the queue onto which the character is to be placed is empty, the first
character pointer("c_cf") must be set in addition to the normal setting of
the last character pointer("c_cl"). If there are character buffers already
allocated to the teletype queue, the new storage is added to the end of the
linked queue. The last buffer on the teletype queue has its pointer field
set to zero so that addition is accomplished by merely changing this field
to point to the new buffer and zeroing the pointer entry in the new buffer.
.IP 3. 3
The last character("c_cl") pointer is adjusted to point to the address of
the next free character position in the buffer.
.IP 4. 3
The character count("c_cc") is incremented.
.
.LP
If there are no buffers left("cfreelist" empty) in the buffer pool, a
nonzero value is returned to the caller of mch.s/putc, a zero is returned
for success.
.sp 1m
.ne 10
.
.LP
.LG
.B pword
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
mov word, r0
.br
mov addr, rl
.br
jsr pc, pword
.sp 1n
.
.LP
.I RETURNS
.
.LP
-1 on failure.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Common subrou4ne used by mch.s/subyte and mch.s/suword to store a word into
the user's virtual address space.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
Performs the inverse operation to that of mch.s/gword. It uses the Move To
Previous Instruction Space(MTPI) instruction to move "word" to the user
virtual address specified by "addr". As with the mch.s/gword routine, a
trap (Segmentation violation) might occur because of an illegal address
("addr") so that the trap catcher("nofault") is set up.
.sp 1m
.ne 10
.
.LP
.LG
.B retu
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
retu (addr)
.br
int *addr;
.sp 1n
.
.LP
.I RETURN
.
.LP
No value is returned.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Restores the stack position(U block) of a process and places a user's per
process information within the system's virtual address space. Used for
restarting a process.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
The address "addr" is the location of a process. (It is the contents of the
"p_addr" entry of a Process Table entry. The U block is the first 1024
bytes at this address and the data and stack segments of the process follow
immediately.). It is in memory block(32 word) granularity so that it may be
directly loaded into Memory Management Registers(Kernel Instruction Address
Register 6 - KISA6 for 11/40's or Kernel Data Address Register 6 - KDSA6
for 11/45 or 11/70 processors). Mch.s/retu places a user's U block in the
system's virtual address space and helps restart the process by restoring
athe stack position of the process from the U block. A higher level
routine(slp.c/swtch) will issue a C subroutine return(jmp cret - return
statement) which will restore the general purpose registers and the PC from
this stack frame. Mch.s/retu always restores SP and R5 from the array
"u_rsav" in the U block ("u_rsav" is the first entry in the per process
information area of the U block.) The stack position(SP and R5) was saved
previously by the function mch.s/savu.
.
.LP
Mch.s/retu is not called unless a process is in core as the "p_addr" entry
contains the swap address of the process when it is non resident. All
interrupts must be disabled to insure that the context can be changed
without interruption. To do this, the processor's priority is raised to 7
while the SP, R5 and KISA6 (or KDSA6 on I and D space systems) is being
restored. The processor's priority is then lowered to zero to allow
processing of all pending interrupts.
.sp 1m
.ne 10
.
.LP
.LG
.B savfp
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
jsr pc, _savfp
.br
savfp()
.sp 1n
.
.LP
.I RETURNS
.
.LP
No value is returned.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Saves floating point registers. A dummy routine is used for machines that
do not have floating point.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
If a process is to be preempted as the result of an interrupt waking up
another process or of a system call completing, the floating point
registers must be saved. (This is true, of course, only for machines that
have a floating point units 1/45,11/70.)
.
.LP
The registers are saved in the U block area ("u_fsav") in the following
order:
.RS
1. Floating Point Status Register
.br
2. FR0 - Floating Register 0
.br
3. FR4
.br
4. FR5
.br
5. FR1
.br
6. FR2
.br
7. FR3
.br
.RE
Special precautions must be taken in saving registers FR4 and FR5 as they
cannot be referenced using addressing modes other than zero (direct
addressing - see DEC Processor Handbook).
.
.LP
The mch.s/savfp function is a dummy routine on machines that do not have
floating point hardware. UNIX uses double precision floating point at all
times so that each saved register represents 4 words. (The floating point
status register is only cite word for a total of 25 words to be saved in
"u_fsav").
.sp 1m
.ne 10
.
.LP
.LG
.B savu
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
savu (save)
.br
int *save[];
.sp 1n
.
.LP
.I RETURN
.
.LP
No value is returned.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Saves the stack position of a process executing within the operating
system.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
C language functions store the subroutine return address on the stack. The
first action performed in the call function is to build a stack frame.
Register RS is set to the current position of the stack pointer(SP) as the
beginning of this stack frame and the general purpose registers are saved
on the stack. Local variables are allocated on the stack frame directly
below the register save area. Register R6(SP) is set up just below the
local variables and acts as a local stack pointer.
.
.LP
By saving R5 and SP and by establishing a convention about relinquishing
the processor, only registers R5 and SP need be saved to save a process's
context. The general registers are saved (by mch.s/csv) and restored (by
mch.s/cret) on the stack every time an interrupt or trap occurs and every
time a C language function is called so that as long as the location of
these registers(i.e., R5 is saved) the process can be restarted.
.
.LP
The mch.s/savu, function performs the service of saving the current value
of R5 and SP of the caller of mch.s/savu in the array specified by "save".
When a process is to be restarted, a converse operation, in which the SP
and R5 are restored ( mch.s/retu or mch.s/aretu) is performed. It is also
necessary to restore the general purpose registers (including the PC) of
the restarted user. This can be done by merely executing a C subroutine
return (mch.s/cret) once the SP and R5 have been restored.
.
.LP
The process Switcher saves the general registers and context(mch.s/savu) of
a process as it is the common routine used to change execution from one
process to another. However, by having several
arrays("u_rsav","u_qsav","u_ssav") where the stack position(SP and R5) can
be saved, a process may resume by returning from a function other than the
process Switcher.
.
.LP
In particular, the "u_rsav" area is used to save the stack position of
processes that willingly relinquish the processor(slp.c/sleep) or are
preempted. The "u_ssav" area is used by processes that do their own
swapping(excluding the Scheduler) and is set up so that once the process is
brought back into memory, it will be restarted in the code that did the
swapping and not by returning from the process Switcher (A flag must be set
SSWAP in "p_flags" to inform slp.c/swtch to restore the stack position from
"u_ssav" and not "u_rsav") The last area "u_qsav" is a special area which
has the stack position of a process saved every time a system call is made.
It is useful, not for resuming a process at a non-standard place, but in
aborting a system call when a signal is caught. The "u_rsav" area is also
used by the slp.c/expand function to restart execution of a process after
moving it to a different location in memory.
.
.LP
Because of the critical nature of saving contexts mch.s/savu must raise the
processor's priority to 7 to insure that no interrupts modify any registers
until the context is changed.
.sp 1m
.ne 10
.
.LP
.LG
.B setreg
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
mov instr, r0
.br
jsr pc, setreg
.sp 1n
.
.LP
.I RETURNS
.
.LP
Returns in the lower byte of register R2, the register that was modified by
the destination field of an instruction and the amount that it was modified
by. The high byte of register r2 is untouched.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
An assembly language function used by the mch.s/backup function on 11/40's
to simulate the operation of Memory Management Status Register 1.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
The amount that a register can be incremented or decremented
(automatically) in a PDP-11 machine language instruction is dependent on
the addressing mode and on the type of instruction(byte or full word). The
amount of the modification for the addressing modes is;
.IP a.
Autoincrement (+I for byte instruction, +2 for full word instruction).
.IP b.
Autoincrernent deferred (+1 for byte and +2 for full word).
.IP c.
Autodecrement (-1 for byte, -2 for full word).
.IP d.
Autodecrement deferred (-I for byte arid -2 for full word).
.
.LP
This function examines the destination field in the instruction "instr"
passed to it and places in the Iow byte of register R2 the number of the
register that was modified toy the destination field and the amount that
the register was incremented or decrernented. It is put in the same forrn
as the Memory Management Status Register I reports it for 11/45 and 11/70
processors. This functions is used only on 11/40's to simulate the
operation of Status Register 1. For a full description of instruction
backup see mch.s/backup.
.sp 1m
.ne 10
.
.LP
.LG
.B spl0
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
spl0()
.sp 1n
.
.LP
.I RETURNS
.
.LP
No value returned.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Changes the processor's priority to 0.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
Spl0 changes the hardware priority of the processor (found in the processor
status word) to 0.
.sp 1m
.ne 10
.
.LP
.LG
.B spi1
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
spl1()
.sp 1n
.
.LP
.I RETURNS
.
.LP
No value returned.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Changes the processor's priority to 1.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
Spl1 changes the hardware priority of the processor (found in the processor
status word) to 1.
.sp 1m
.ne 10
.
.LP
.LG
.B spl4
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
spl4()
.sp 1n
.
.LP
.I RETURNS
.
.LP
No value returned.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Change's the processor's priority to 4.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
Spl4 changes the hardware priority of the processor (found in the processor
status word) to 4.
.sp 1m
.ne 10
.
.LP
.LG
.B spl5
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
spl5()
.sp 1n
.
.LP
.I RETURNS
.
.LP
No value returned.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Changes the processor's priority to 5.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
Spl5 changes the hardware priority of the processor (found in the processor
status word) to 5.
.sp 1m
.ne 10
.
.LP
.LG
.B spl6
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
spl6()
.sp 1n
.
.LP
.I RETURNS
.
.LP
No value returned.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Changes the processor's priority to 6.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
Spl6 changes the hardware priority of the processor (found in the processor
status word) to 6.
.sp 1m
.ne 10
.
.LP
.LG
.B spI7
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
spl7()
.sp 1n
.
.LP
.I RETURNS
.
.LP
No value returned.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Changes the processor's priority to 7.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
Spl7 changes the hardware priorifirof the processor (found in the processor
status word) to 7.
.sp 1m
.ne 10
.
.LP
.LG
.B start
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
jmp start
.sp 1n
.
.LP
.I RETURN
.
.LP
No value is returned.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Sets up the virtual address space for the operating system.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
The difference between initializing the operating system's virtual address
space for 11/40's is sufficiently different from that of 11/45 and 11/70's
that a separate discussion of each will be given.
.
.LP
On 11/40 processor's, there is only are one set of General Purpose
Registers(set 0) and there are only two sets of Memory Management
Registers(User and Kernel). Each set of Memory Management Registers does
not have a Data Space Register Set in addition to the normal Instruction
Space Register Set. The Memory Management Unit on the 11/40 also does not
possess a register(Status Register 1) which aids in backing up
instructions(see mch.s/backup discussion). When UNIX is booted into memory
by one of the BOOT prograrns(UBOOT, HPBOOT, RKBOOT, TBOOT, MBOOT, etc), it
is in the same form as a standard object file on the system. That is, there
is an 8 word header followed by the text(instructions) segment. This is
followed by any initialized data and any uninitialized data(bss). The size
of the uninitialized data(bss) is indicated in the header. The end of the
three respective areas are indicated by the following three addresses
supplied by the UNIX loader "_etext", "_edata", "_end".
.
.LP
When UNIX is booted into memory, relocation by the Memory Management Unit
is off(bit 0 of Status Register 0 turns relocation on). All addresses are
mapped into the lower 32K words of memory. Since the operating system is
the only software to interact with the device registers, the virtual
address map for the Kernel must be set up to access this region. Also, the
operating system's stack shifts from area(U block) to area within the full
range of memory depending on which process is executing. To perform the
address mapping required for these functions Kernel Memory Management
Instruction Address register 7(KISA7) is set up to map virtual memory
references 28K-32K word in Kernel virtual address space into the high
memory Unibus address area (18 bit pysical addresses 124K-128K). Kernel
Memory Management Instruction Address register 6 (KISA6) is used for
mapping the system stack and the U block area. The U block area is a block
of memory 1024 bytes in size which contains per process information. The
"u" array is in the low physical address part and the system's stack area
is in the high physical address part of the U block. The first six Kernel
Instruction Address registers are set up to map the first 24K of physical
memory into the corresponding first 24K of virtual address space. The boot
programs bring the operating system into this area of memory so no
rearrangement of the object file is necessary as on I and D space
systerns(see below). The area taken up by the operating system may actually
be smaller than the 24K that can be accessed by the memory map ,however,
the address map is not adjusted to constrain the operating system. Two
other functions must be perfdrmed before the system can be initialized(by
main.c). The system allocates the first 1024 by area (on a 64 byte address
boundary) as a U block for the Scheduling process. The Page Length Field in
all of the Kernel Instruction Address registers is set up to map a full 4K
word area and the access control permissions for read/write no abort(ACF =
06 is set). KISA6, which maps the U block, is set up with the same
permissions but mapping for only a 1K byte area. Once the Kernel virtual
address map has been set up, relocation can be turned on(by setting bit 1
of Status Register 0 in the Memory Management Unit) and the uninitialized
data(bss) and Scheduler U block area can be zeroed. The bss area is the
area between "_edata" and "_end". Before calling main.c to initialize the
system, the Processor Status is set up so that the Current Mode field
indicates Kernel, the Previous Mode indicates User and the processor's
priority is lowered to zero. This is done because it is an appropriate
start of state for the processor, allowing interrupts and appearing as if a
system call from a user process was made.
.
.LP
There is one additional function performed by mch.s/start. This is in
conjunction with main.c which spawns the INIT process. A return(RTS) to the
mch.s/start routine is executed by main.c on behalf of the INIT process
after it has handcrafted a small programricodel in user virtual address
space. This program will cause an exec system call to be issued and the
INIT process to be brought into memory. The whole operation appears as if a
system call was made by the (nonexistent as yet) INIT process. The
mch.s/start program simulates the return from the system call by setting up
the system's stack so that a return from trap(RTT) instruction can be
executed. An appropriate PS(indicating both Previous and Current Mode of
the processor to be User) and PC (set to resume execution at virtual
address 0 in user virtual address space) is loaded onto the stack before
executing the RTT.
.
.LP
For 11/45 and 11/70 processors there is a better Memory Management Unit
which allows larger virtual address spaces. In particular, there are three
sets of Memory Management Registers; Kernel; User, Supervisor. Each Memory
Map is divided into two sections, one for mapping instruction
fetches(Instruction space) and one for mapping data fetches (Data space).
To take advantage of the expanded virtual address space available in these
processors the object file is relocated differently. The major reason for
this is that when an interrupt or trap occurs the new PS and PC loaded from
the low memory vector area are mapped by the hardware into the low virtual
D space area. The low core vectors are however hardwired to low physical
core. This means that at least low physical core virtual Data must be in
low memory. Also, by arranging that the system buffers have the same
physical and virtual addresses, relocation need not be performed when doing
buffered I/O. The approach taken for UNIX I and D space systems was to
rearrange the object file for the systern(using the SYSFIX command) so that
the data precedes the text_Several text portions of the system, notably the
C interface area, the post mortem dump (mch.s/dump) and the mch.s/start
routine are loaded in Data Space. This is done to save Instruction space or
because the routines are used only once. The boot programs are exactly the
same as for the 11/40, the only difference being the interchange of the
text and data portions of the object file which are transparent to the
object programs. The virtual address mapping set up by the mch.s/start
routine is also different and the meaning of the symbols "_etext", "_edata"
and "_end" supplied by the loader is different. In addition, the operating
system must be loaded using a special option on the loader.
.
.LP
When the loader performs relocation on an object file that is to have I and
D separation, all of the text is loaded assuming that the first location is
virtual address 0 in
.I "Instruction Space".
The data and bss segments are loaded assuming that the first location
available for data is also virtual address 0 in
.I "Data Space".
The meaning of "_etext", "_edata" and "_end" at this point is as follows,
.RS
"_etext" - This is the last address occupied by instructions in Instruction
Space and since the text has been loaded at virtual address 0, it also
corresponds to the site of the text.
.LP
"edata" - This is similar to the "_etext" symbol since the data is loaded
in its own virtual address space starting at virtual 0. It also corresponds
to the size of the data segment.
.LP
"end" - This is the last virtual location in Data Space. The size of the
bss area is "end" - "_edata".
.RE
The SYSFIX command must be run on UNIX object files that are to be
separated into I and D space. This prtigram interchanges the position of
the data and text portions of the object file (text is normally first) and
also relocates the text portion so that the first address is at 4K word
virtual Instruction Space. This means that "_etext" is increased
correspondingly and no longer represents the size of the text.
.
.LP
With the new object file provided by the SYSFIX program, some adjustments
of the position of the text(to make room for the bss) in physical memory is
still necessary when the system is booted into memory. In order to utilize
fully the address space provided by the Kernel Data Space, it is desirable
to place the bss segments between the data and text. To do this, the text
must be shifted in physical memory to a higher address area which may be
beyond the 32K word address space that can be addressed with relocation
off. The Memory Management Registers must therefore be setup to accomplish
this and relocation turned on to do the move. (This was not necessary on
non I and D space systems since the total text, data ,and bss area was
limited to 32K words.)--The Data Space registers are setup so that their
32K virtual address space maps into thel first 32K of physical memory. The
last seven of the Instruction Address Space Registers are setup so that
they map 28K of virtual address space(beginning at 4K virtual) into the
physical area of memory that the text is to reside in (immediately below
the data and bss). Instruction Address Register 0 is set up so that the
first 4K virtual Space overlaps the 4K physical area already mapped by
Kernel Data space Register 0. (This is done because mch.s/start is in the
data area as is the C interface area and they must reside in Instruction
Space to be executed. Relocation may now be turned on and the text moved to
higher physical memory by using the MTPI instruction with the PS setup to
indicate that the Current and Previous Modes are Kernel. The bss area is
then zeroed. Finally it is necessary to setup Data Space Address Register 6
to point to a U block for the Scheduler(as was done for the 11/40). Space
for the U block, is allocated from the first available memory beyond the
operating system. It is cleared and a stack is established in the lower
portion of the U block for the system. Data Space Address Register 7 must
be set up to map the Unibus addresses. (There is a contradiction in terms
at this point as one cannot set a data location which is not already within
your virtual address space once relocation has been turned on.) This is
done by using an addressing mode escape(see DEC Memory Management
Maintenance Manual) for the MTPI instruction which allows the I/O area to
be accessed and therefore Data Space Address Register, to be set even
though no mapping exists for that area. All of the Memory Management
Registers are set up to map 4K regions of memory, except for Data Space
Register 6 which maps the 1K byte area of the U block. All Memory
Management registers are set up for read/write no abort/trap action (Access
Control Field - ACF -- 06) and for the expansion direction to be toward
high physical addresses(ED = 0). The operation of the mch.s/start routine
in conjunction with main.c and the INIT process is the same as for 11/40's.
.
.LP
The 11/70 processor is capable of addressing more memory than either the
11/40 or 11/45 by turning on 22 bit mode addressing in the Memory
Management Unit(bit 4 of Status Register 3 is set). Currently only 18 bit
addressing(i.e., 11/40, 11/45 mode) is supported on 11/70 processors.
.sp 1m
.ne 10
.
.LP
.LG
.B subyte
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
subyte(virtual, c)
.br
char	c;
.br
char	*virtual;
.sp 1n
.
.LP
.I RETURNS
.
.LP
A -1 is returned if the character "c" cannot be placed in the user's
virtual address spaces.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
This is the analog of mch.s/subyte. Most of the work in storing a byte in
the user's address space is done by mch.s/gword(get a word from user
virtual address space) and mch.s/pword(place a word in user virtual address
space).
.
.LP
Because the only instructions available for moving data between address
spaces(MFPI, MTPI, etc.) operate on words, the full word that contains the
byte to be overwritten must first be fetched(by mch.s/gword) and the byte
carefully inserted before the word is replaced in the user's address space
(by # mch.s/p word) . Both mch.s/pword and mch.s/gword are equipped to deal
with errors occurring in storing across address spaces and will result in
mch.s/subyte returning a -1. They set up the external variable "nofault" so
that it contains the address of their own internal error handler so that
the trap handler will return control to them instead of processing the
error as a trap. This function is used chiefly in moving characters from
the I/O subsystem to the user's address space(see subr.c/passc).
.sp 1m
.ne 10
.
.LP
.LG
.B suword
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
suword(virtual, word)
.br
int word;
.br
int *virtual;
.sp 1n
.
.LP
.I RETURNS
.
.LP
-1 on failure.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Stores a word in user virtual address space.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
Mch.s/suword and mch.s/subyte use the common subroutine mch.c/pword to
place a word in the user's virtual address space at the address "virtual".
.sp 1m
.ne 10
.
.LP
.LG
.B trap
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
jmp trap
.sp 1n
.
.LP
.I RETURNS
.
.LP
No value is returned.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Trap is an assembly language interface which performs some additional work
for interfacing to the trap handler(trap.c/trap).
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
Additional work is required in handling traps besides the normal stack
frame buildup that is done by the mch.c/call routine. First of all, the
status registers in the Memory Management unit contain information about
memory faults and information that will allow instructions to be backed up
and restarted when a segmentation violation occurs. The three registers and
the information they represent are, (For exact details see DEC Processor
Handbook.)
.IP 1.
Memory Management Status Register 0 - type of memory violation occurring.
.IP 2.
Memory Management Status Register 1 - records any
autoincrement/autodecrement of general purpose registers. (Necessary for
backing instructions up instructions on 11/40's) .
.IP 3.
Memory Management Status Register 3 - contains the virtual PC when the trap
occured.
.
.LP
The trap interface saves the contents of these registers in a three word
array "ssr" so that they may be used by the mch.s/backup routine. Once
these registers are saved, relocation may be turned on by setting bit 1 in
Memory Management Status Register 0.
.
.LP
Since all traps are handled by the same C function (trap.c/trap) there is
no jump table entry in low core as there is for the interrupt handlers.
These low core jump table entries are, however, responsible for saving
register R0. The assembly
.
.LP
language mch.s/trap routine must do this by executing the following
sequence,
.CD
jsr r0,call1; _trap
.DE
This is in the same format as the low core jump table entries and is used
both to save register r0 and to interface to the mch.c/call routine. The
function mch.s/calll is a special entry point in the mch.c/call routine for
the trap handler. It merely adjusts the stack pointer so that the interface
to the mch.c/call routine will be smooth and lowers the processors priority
to zero so that any interrupts that may be pending can be processed. (Note
- The low core vectqfs indicated that the processor's priority should be
raised to 7 when handling a trap). This is to prevent another trap from
destroying the contents of the Memory Management Status registers before
they could be saved and relocation restarted. In moving data between
address spaces, (using mch.s/copyseg, mch.c/fuword, mch.s/copyin, etc.
i.e.,any routine which uses the MFPI, MFPD, etc. instructions) there is the
possibility that the user process has improperly specified to the system
the virtue address to or from which data is to be moved. UNIX allows these
specialized routines do their own trap catching. These assembly language
functions place in a external variable "nofault" the address of their own
error handler. If a trap occurs, the mch.s/trap function Will transfer to
the address specified by "nofault" rather than calling the trap
handler(trap.c/trap).
