.hpf hyphen.local
.P1
.de PT
.tl 'FIO01 - FILE I/O'\*[CH]'PD-1C301-01'
.tl 'File: fio.c''Section 5'
.tl '''Issue 1, January 1976'
..
.2C
.ne 10
.
.LP
.LG
.B access
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
access(aip, mode)
.br
int *aip;
.br
int mode;
.sp 1n
.
.LP
.I RETURNS
.
.LP
On success return 0 otherwise return 1 and set appropriate error flag.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Compare the "mode" argument with the mode permissions in the i-node pointed
to by "aip". If permission is granted return zero, else one.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
The "mode" argument is READ, WRITE, or EXEC.
.
.LP
If the mode is WRITE the read-only status of the file system is checked and
if it is read-only set the per user control block error indicator
(u.u_error) to EROFS (read-only file system) and return 1. Similarly if the
i-node pointi to a text image (read only code) than the file cannot be
written upon as long as anyone is using the text image. If the i-node
points to a text image set the error indicator to ETXTBSY (Text Busy).
.
.LP
If the user id is that of the super-user (userid 0) then all permissions
are granted except for EXEC where at least one of the EXEC bits must be on.
.
.LP
The mode is shifted to match against the permissions for the owner, group,
or foreigners depending on the match of the user id against the owner id,
and group id in the i-node. If the mode does not match acceptable
permissions, the error condition EACCES is set to indicate illegal access
and return 1.
.sp 1m
.ne 10
.
.LP
.LG
.B closef
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
closef (fp)
.br
int *fp;
.sp 1n
.
.LP
.I RETURNS
.
.LP
None.
.
.LP
STNOPSIS
.\"Typo is in the original
.LP
Internal form of close. Decrements usage count (f count) of the System File
Table (file.h) entry pointed to by "fp" and completes close when the count
is zero.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
If the entry in the System File Table pointed to by "fp" is a pipe then it
must be treated separately. Otherwise, the usage count is decremented and
when it becomes zero, fio.c/closei is called to close the i-node.
.sp 1m
.ne 10
.
.LP
.LG
.B closei
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
closei (ip, rw)
.br
int *ip;
.br
int rw
.sp 1n
.
.LP
.I RETURNS
.
.LP
None
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Close the i-node pointed to by "ip". Closing an i-node implies
decrernenting a reference count (done by fio.c/closef) and when it goes to
zero rewrite the i-node to disk. Companion routine to openi.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
If the reference count is not zero just return. If the i-node pointed to by
"ip" in the System INODE Table )inode.h) is a special file (device) then
the appropriate device driver is called to close the device. This is done
by switching on the major device number which is stored in addr[0] of the
i-node.
.
.LP
Otherwise iget.c/iput is called to write the i-node to disk.
.sp 1m
.ne 10
.
.LP
.LG
.B falloc
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
falloc()
.sp 1n
.
.LP
.I RETURNS
.
.LP
A pointer to the first available System File Table entry or NULL if any
errors.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Allocate a user file descriptor from the per user control block
(u.u_ofile), and build an entry in the System File Table (file.h).
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
Falloc calls fio.c/ufalloc to get the first available file descriptor in
the per user control block (u.u_ofile). If no file descriptors are
available the falloc returns a NULL as an error indicator.
.
.LP
A search is made for the first available System File Table (file.h) entry
by looking for an entry where the count of connected processes (f count) is
zero. The System File Table entry is initiated and the file descriptor is
set to point to this entry.
.
.LP
If the System File Table is full print an error indication on system
console and return NULL.
.sp 1m
.ne 10
.
.LP
.LG
.B getf
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
getf (f)
.br
int f;
.sp 1n
.
.LP
.I RETURNS
.
.LP
On error set the per user control block error code (u.u_error) and return
NULL. On success return a pointer to correct System File Table (file.h)
entry.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Checks for valid file descriptor values.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
Check to see that the file descriptor "f" is in the valid range (0-NOFILE);
currently (0-15). Check that the file descriptor points to an open file and
return pointer to the System File Table Structure (file.h). If not a valid
file descriptor or the file is not open then set error code (EBADF) in the
per user control block I return NULL.
.sp 1m
.ne 10
.
.LP
.LG
.B openi
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
openi (ip, rw)
.br
int *ip;
.br
int rw;
.sp 1n
.
.LP
.I RETURNS
.
.LP
On error, sets the per user control block error flag u.u_error to ENXIO, no
such device or address.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Openi is the routine to open special files (devices) whose associated
i-node is pointed to by "ip" with read/write permissions "rw". Companion
routine with closei.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
Openi is called every time a physical device must be opened. This occurs
during the mounting of file systems as well as handling of devices.
.
.LP
Openi calls the open entry in the device driver for the character or block
device identified in the i-node pointed to by "ip". Since this is the
physical opening of a device, and each one acts differently the particular
driver must be referenced for open processing. The only check made in openi
is to make sure the major device number is within the range of the number
of devices defined in a particular configuaration.
.sp 1m
.ne 10
.
.LP
.LG
.B owner
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
owner()
.sp 1n
.
.LP
.I RETURNS
.
.LP
On success return a pointer to an i-node. On failure return NULL.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Check a pathname for ownership.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
Use nami.c/namei to lookup a pathname in user space and return a pointer to
an i-node. If the aid of the i-node matches the uid in the per user control
block (u.u_uid) then return the pointer to the i-node.
.
.LP
Call fio.c/suser to check if the effective userid of this user is
super-user and if so return the pointer to the i-node. Otherwise, return
NULL.
.sp 1m
.ne 10
.
.LP
.LG
.B suser
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
suser()
.sp 1n
.
.LP
.I RETURNS
.
.LP
Suser returns a flag if successful, otherwise, sets an error condition in
the per user control block (u.u_error) indicating wrong owner (EPERM).
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Check to see if user is super-user.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
The superuser is known internally as userid 0. If the uid in the per user
control block (u.u_uid) is zero then return the success flag. Otherwise,
set an error indicator.
.sp 1m
.ne 10
.
.LP
.LG
.B ufalloc
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
ufalloc()
.sp 1n
.
.LP
.I RETURNS
.
.LP
A file descriptor if successful otherwise, return negative.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Allocate a user file descriptor from the per user control block
(u.u_ofile).
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
File descriptors are numbers between 0 and 15 that represent a displacement
into a list of pointers to System File Table entries.
.
.LP
Search the list of user file descriptors (current maximum 15) for the first
empty slot and return the file descriptor. If all file descriptors have
been used then return -1 as an error indicator.
