.hpf hyphen.local
.P1
.de PT
.tl 'CLOCK01 - SYSTEM CLOCK'\*[CH]'PD-1C301-01'
.tl 'File: clock.c''Section 3'
.tl '''Issue 1, January 1976'
..
.2C
.ne 10
.
.LP
.LG
.B clock
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
clock (device,sp,r1,newps,r0,pc,oldps)
.sp 1n
.
.LP
.I RETURNS
.
.LP
No value is returned.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
The clock interrupt handler. Supplies system timing.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
Clock.c/clock is the clock interrupt handler. It maintains the system clock
and any time dependent services supplied by the system. As there are a
number of these software services the interrupt processing for the clock
will be described first.
.
.LP
There are currently two clocks available for the PDP-11 series of
computers; the KW11-L and KW11-P clocks. The KW11-L is simply a line
frequency clock, while the KW11-P is a programmable clock which can count
at 10KHz, 100KHz or on the basis of an external trigger in addition to line
frequency. UNIX can accomodate either of these clocks, however, only the
line frequency option is used. The clock that is present on the system (the
clocks have different Unibus addresses) is determined by the main.c/main
function when the system is initialized. The Unibus address of the clock is
placed in the external variable "lks". If no clock is present on the system
or if the clock is malfunctioning when the system is booted, the system
panics ("PANIC NO CLOCK"). The main.c/main function is the first to turn on
the clock so that interrupts are generated once every sixtieth of a second.
The clock interrupt handler thereafter reenables succeeding interrupts so
that interrupts occur. (The clock never stops counting so that no delay is
encountered by the need to reenable interrupts.) The clock interrupt
handler generates an interrupt at bus request level 6, which is higher than
that of all hardware controllers on the system. Only traps have a higher
priority (7). In line with the fact that interrupt handlers on UNIX are
non-reentrant, the clock interrupt is processed at the same priority that
the interrupt request was generated. The bits that must be set in the clock
status register to reenable clock interrupts are:
.
.LP
1. Bit 6 reenables interrupts. This is the only bit that need be set for
the KW11-L.
.
.LP
2. Bit 3 selects repeat interrupt mode (KW11-P only).
.
.LP
3. Bits 2 and 1 select the mode. If bit 2 of the bpair is set, the KW11-P
will count at Line frequency.
.
.LP
4. Bit 0 turns the counter in the clock on. (KW11-P only)
.
.LP
The clock interrupt handlers are called is called in the same way that
other interrupt handler from the mch.s/call interface. It has arguments (on
the stack frame built by mch.s/call) available to it so that it can check
the Previous Mode of the processor, the Program Counter, etc.
.
.LP
The following software functions are performed by the clock interrupt
handler:
.
.LP
Clock/clock.c updates the system's notion of the time of day. The time of
day is kept in a two word array (a long integer) "time[]" with the least
significant bit (in "time[1]") being in units of seconds. As a clock
interrupt is genetated once every sixtieth of a second, a count of the
number of sixtieths of a second is kept in "lbolt". The "lbolt" is
incremented on every interrupt and when it reaches 60, the system time is
updated. The time of day must, however, be initialized to the proper yearly
value via the date system call.
.
.LP
The clock interrupt handler keeps track of the amount of time a process
spends in User mode and Kernel mode. This time is kept in two separate
locations ("u_time" and "u_stime") in each process's U block. The time is
kept in sixtieths of a second.
.
.LP
The clock interrupt handler wakes up processes that are delaying execution
(i.e., processes that have made the sleep system call). The external
variable "tout[]" which has the same form as the time of day, is set to the
date that the earliest sleeping process is to be awakened. When the time
has elapsed, all processes that have issued the sleep system call (the
address of "tout[])" is used as the synchronizing event) are awakened.
.
.LP
The clock interrupt handler maintains an event called the
.I "lightning bolt"
which is used by some drivers to achieve long delays. The address of
"lbolt" is used as the synchronizing event and all processes that sleep on
this event are awawakened when the clock reaches a 4 second interval.
.
.LP
The magnetic tape drivers use the lightening bolt to wait for gap shut down
when closing the device.
.
.LP
The age of a process is updated by the clock interrupt handler. The
"p_time" entry for each process in the Process Table contains the length of
time in seconds that a process has been in memory or on the swap device.
Once every second these ages are updated.
.
.LP
Since the Scheduler uses the age of a process as its chief criteria in
swapping a process into or out of memory, the clock notifies the Scheduler
when these ages change. The Scheduler is notified only if it is waiting
("runin") for available memory to bring a process into memory.
.
.LP
The console display is updated once every clock interrupt by calling
mch.s/display.
.
.LP
In line with profiling a process, the clock handler aids the profiler by
calling mch.s/incupc when profiling is selected ("u_prof[3]" turns
profiling on).
.
.LP
The clock interrupt handler provides for the delayed execution of a
function. This is done by maintaining a list, "callout[]", of functions to
be executed after a time period. Each entry in "callout[]" contains a
pointer to a function ("c_fund"), an argument ("c_arg") to be passed to the
function and the relative time "c_time") at which the function is to be
executed. The time entry is in sixtieths of a second so that the execution
of a function may be delayed up to 32K sixtieths of a second (about 9
minutes). Clock.s/timeout inserts an entries into the "callout[]" list,
however, the clock interrupt handler must maintain the list. The time
values "c_time" that are inserted in the array are times relative to that
of the previous entry. Relative times are used so that the clock interrupt
handler does not have to scan the entire array to update each entry.
Rather, only the first entry need have it's time decremented. The
appropriate function is called by the clock handler when the (relative)
time value has reached zero. At this time, the entry must be removed from
the "callout[]" list and the list is compressed (all entries are moved
down). Since delayed function execution is typically used by character and
block device interrupt handlers, some precautions must be exercised in
executing them. In particular, since interrupt handlers are not reentrant
and since the clock interrupt may cause the stacking of one of these
interrupts, it is dangerous to allow a delayed function to be executed when
the clock has caused the stacking of interrupts. The delayed function might
attempt to access some list whose linkages were only partially established,
etc. To avoid these complications and to prevent restrictions being placed
on the delayed functions, the clock handler does not execute a delayed
function if the clock interrupt occurs while the processor's priority is
nonzero. (That is, the processor was already engaged in processing an
interrupt, or the processor was in the midst of a critical region of
software. The processor's priority is always zero when the processor is in
User mode so that delayed functions can always be executed if a user is
interrupted.) This means that the function must wait at least until the
next clock interrupt before it can be executed. In order to prevent the
remaining functions from being delayed because of this, the relative time
must be allowed to become negative and the first non-zero time in the list
must be decremented to insure that the other functions in the array do not
incur the delay. When a clock interrupt finally occurs while the
processor's priority is zero (processor in User mode or in Kernel mode but
not within a critical region) all the functions that should have been
executed previously are executed. After all functions that are to be
executed are completed they are popped from the list and the list is
compressed.
.
.LP
The clock handler plays an important role in identifying and penalized CPU
bound processes. Since the consecutive execution time of a process is not
(as yet) kept (only cumulative time "u_utime"), UNIX depends on an
averaging type effect to identify CPU bound processes. This scheme examines
the Processor Status once every second to determine whether the clock
interrupt occurred while the processor was in User mode. If this Is the
case, then the process that was interrupter is penalized by having it's
priority ("p_pri" in the Process Table) lowered by 1 (the penalty scheme is
only allowed to lower the priority as far as 105) and the processor is
taken from the process. (Slp.c/swtch is called to select another process.)
Since the floating point registers may not have been saved when the
interrupt occurred, mch.s/savfp must be called before the process is
preempted. Also, because signals are caught by a process only when the
process calls on the system for service, a check must be made (by calling
sig.c/issig) to see if there are any signals pending for the process. If
this were not done, a CPU bound process could not be killed from its
controlling teletype via the quit or interrupt keys. Since the operating
system is not reentrant, processes cannot be preempted if the clock
interrupt occurred in the midst of executing a critical region.
.
.LP
Note:
.br
Critical regions of code are areas where it is necessary to raise the
processor's priority to prevent interrupts from occurring or other
processes from executing the same code.
.sp 1m
.ne 10
.
.LP
.LG
.B timeout
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
timeout(function,argument,delay)
.br
int (*function)();
.br
int argument, delay;
.sp 1n
.
.LP
.I RETURNS
.
.LP
No value is returned.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Inserts an entry in the list of functions whose execution is to be delayed.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
The "callout[]" array consists of three word entries which specify a
function ("c_func"), an argument to be passed to the function ("c_arg") and
the amount of time a function is to be delayed ("c_time"). The time entry
("c_time") is the time relative to the previous entry that the function is
to be executed, and is in sixtieths of a second. The first time entry is
relative to the clock. Inserting an entry in the "callouta" array is done
by taking the "delay" and finding the appropriate position in "callouta" to
insert the entry. The "delay" is then translated into an appropriate
relative time and inserted in "c_time". Since "callout[]" is an array all
succeeding entries must be pushed down to make room for the new entry.
Also, since the clock handler (clock.c/clock) updates the time in the
"callout[]" array and arranges for the deletion of entries, clock
interrupts must be locked out and traps prevented (by setting the priority
to 7) while the new entry is inserted. The arguments "function" and
"argument" are the address of the function to be executed and the value of
an argument to be passed to that function.
