.hpf hyphen.local
.P1
.de PT
.tl 'ALLOC01 - DISK ALLOCATOR'\*[CH]'PD-1C301-01'
.tl 'File: alloc.c''Section 2'
.tl '''Issue 1, January 1976'
..
.2C
.ne 10
.
.LP
.LG
.B alloc
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
alloc (dev)
.br
int dev;
.sp 1n
.
.LP
.I RETURNS
.
.LP
A block number of allocated block if successful. A NULL is unsuccessful.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Alloc allocates disk blocks from the free list of the associated file
system. Companion routine with free.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
Alloc allocates disk blocks on device "dev". Alloc.c/getfs is called to get
the pointer to the incore superblock for the file system on device "dev".
If the superblock is locked because of replenishing of the free list then
alloc will sleep until it becomes unlocked.
.
.LP
The free list of blocks is maintained as a linked list of tables of 100
entries (99 free block pointers and one pointer to the next member of the
linked list). The last table contains a zero pointer to indicate the end.
S_nfree is a pointer into first table of 100 entries which is kept in
memory in the superblock. When s_nfree is zero, alloc replenishes the
memory table with the next table in the linked list. If the linked list is
depleted an error indicator is set. Alloc returns the block number pointed
to by s_nfree.
.sp 1m
.ne 10
.
.LP
.LG
.B badblock
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
badblock (alp, abn, dev)
.br
int aip,abn,dev;
.sp 1n
.
.LP
.I RETURNS
.
.LP
If no bad blocks return 0, otherwise print BAD BLOCK message on console and
return 1.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Checks that a block number is in the range between the ilist and the end of
the file system. In other words make sure that the block can be used in
block allocation.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
If the block number "abn" on the file system pointed to by "afp" is less
than isize+2 (isize is the size of the ilist and block 0 is the boot
program and block 1 is the superblock) or greater than fsize ( the size of
the file system) then alloc.c/prdev is called to print the bad block
message for device "dev". Otherwise return 0 as indicator of success.
.sp 1m
.ne 10
.
.LP
.LG
.B free
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
free (dev, brio)
.br
int dev, bno;
.sp 1n
.
.LP
.I RETURNS
.
.LP
None
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Free places the block number "bno" back on the free list of the file system
on device "dev". Companion routine with alloc.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
Alloc.c/getfs is called to get the pointer to the incore superblock for the
file system on device "dev".
.
.LP
The free list of blocks is a linked list of tables of 100 entries (99 free
blocks and one pointer to. the next table). When blocks are freed, they are
added to this linked list. The first table of 100 entries is kept in memory
in the superblock. Block allocation/deallocation takes place in this table
at the place pointed to by s_nfree. When the table is full (s_nfree = 100)
it is written to disk, added to the linked list, and the incore table is
emptied.
.sp 1m
.ne 10
.
.LP
.LG
.B getfs
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
getfs (dev)
.br
int dev;
.sp 1n
.
.LP
.I RETURNS
.
.LP
A pointer to the in-core superblock.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Getfs maps a device number, "dev", into a pointer to the in-core superblock
associated with the file system on that device.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
Getfs searches through the Mount Table for a matching device number, "dev".
The Mount Table is composed of three word entries:
.IP 1.
A device pointer
.IP 2.
A pointer to the buffer containing the superblock
.IP 3.
A pointer to the i-node entry for the mount point.
.
.LP
If the device is not present in the Mount Table a PANIC "no fs" occurs.
(This cannot happen). Otherwise, the pointer to the buffer containing the
superblock is returned.
.sp 1m
.ne 10
.
.LP
.LG
.B ialloc
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
ialloc (dev)
.br
int dev;
.sp 1n
.
.LP
.I RETURNS
.
.LP
A pointer to the incore, allocated i-node.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Allocation of i-numbers and i-nodes for use in file creation. Companion
routine with ifree.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
Iafloc allocates i-nodes for file creation and refills the free list of
i-numbers when it becomes empty.
.
.LP
Alloc.c/getfs is called to get a pointer to the incore superblock of the
file system for device "dev".
.
.LP
If the free list of i-numbers (s_ninode) is locked because it is under
replenishment then ialloc sleeps until it becomes unlocked.
.
.LP
If the free list is empty, ialloc locks it, then a linear search of the
ilist on disk device "dev" is made looking for 100 free i-nodes. the
i-number of each free i-node is placed into the free list. If the entire
ilist contains allocated i-nodes then a PANIC out of i-nodes occurs. The
replenishment is complete when the free list is full or all available ilist
i-nodes have been put into the free list. The i-number pointed to by
s_ninode, (the pointer to the first available entry in the free list) is
used by iget.c/iget to load the associated i-node into the System INODE
Table. If the i-number in the free list points to an i-node that is already
allocated a message BUSY I (busy i-node) is printed and iget.c/iput is
called to release the inode.
.
.LP
When an unallocated i-node is found, its mode and address pointers are
zeroed and a pointer to this i-node is returned. A flag (s_fmod) for the
incore superblock is also set to indicate that the superblock was modified,
so on a subsequent update of the disk (in which all modified superblocks
are written to disk) this superblock will be written.
.sp 1m
.ne 10
.
.LP
.LG
.B ifree
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
ifree (dev, ino)
.br
int dev, ino;
.sp 1n
.
.LP
.I RETURNS
.
.LP
None
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Free the specified i-node, and associated inumber, "ino", on the file
system on device "dev". Companion routine with ialloc.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
A free list of 100 i-numbers are kept in the incore superblock. When an
i-node is freed, its inumber is added to the free list (s_inode) at the
entry pointed to by s_ninode (the next free slot).
.
.LP
When the free list is full, additional deallocated i-numbers are ignored,
since their associated inodes are marked as unallocated and are written
back to the ilist where they can be picked up in a subsequent searci of the
ilist (see alloc.c/ialloc).
.
.LP
Alloc.c/getfs is called to get a pointer to the incore superblock of the
file system on the device "dev". If the free list is locked or full
(sninode = 100) then the i-number is abandoned.
.
.LP
Otherwise, the i-number is placed at the entry pointed to by s_ninode and a
flag (s_fmod) is set to indicate that the superblock was modified.
.sp 1m
.ne 10
.
.LP
.LG
.B unit
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
iinit()
.sp 1n
.
.LP
.I RETURNS
.
.LP
If the superblock of the root directory cannot be read a panic results.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Mounts the root file system by building an entry in the Mount Table.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
Iinit is called once during UNIX initialization to read the superblock of
the root device into memory and place pointers into the Mount Table for
this superblock. If an error occurs during the reading of the root device
(rootdev is the entry defined in the configuaration table conf.c) then a
PANIC UNIT is issued which causes the system to halt.
.sp 1m
.ne 10
.
.LP
.LG
.B prdev
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
prdev(str, dev)
.br
int str, dev;
.sp 1n
.
.LP
.I RETURNS
.
.LP
None.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Print out error messages on system console.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
Print the string "str" on the system console with the major and minor
device numbers for the device pointed to by "dev".
.sp 1m
.ne 10
.
.LP
.LG
.B update
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
update()
.sp 1n
.
.LP
.I RETURNS
.
.LP
None
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Update is the system routine that writes all the changed superbiocks and
i-nodes back to disk. In normal system operation this occurs whenever the
SYNC command is issued, or by the UPDATE program every 30 seconds.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
Because update is initiated by user programs, it maintains a lock to
prevent simultaneous updating before one complete pass is done. For each
non-zero entry in the Mount Table that has the modified flag (s_fmod) set,
is not locked for replenishing the free list (s flock) or ilist (s_ilock)
manipulation, and is not read only (s_ronly) the superblock is written to
the disk.
.
.LP
Each i-node in the System INODE Table (all those associated with open
files) are examined to see if they are locked for modification by some
other function. If an i-node is unlocked, it is locked by update to prevent
other changes while updating, and iget.c/updat is called to write the
i-node to the disk ilist if it was modified. Pipe.c/prele is then called to
release the locked i-node.
