#include "defs"


FSTATIC char *nextchar 0;
FSTATIC char *lastchar 0;

FSTATIC int *nextint 0;
FSTATIC int *lastint 0;

FSTATIC struct nameblock *hashtab[HASHSIZE];
FSTATIC int nhashed 0;


/* simple linear hash.  hash function is sum of
   characters mod hash table size.
*/
hashloc(s)
char *s;
{
register int i;
register int hashval;
register char *t;

hashval = 0;

for(t=s; *t!='\0' ; ++t)
	hashval =+ *t;

hashval =% HASHSIZE;

for(i=hashval;
	hashtab[i]!=0 && equals(s,hashtab[i]->namep)==0;
	i = (i+1)%HASHSIZE ) ;

return(i);
}


struct nameblock *srchname(s)
char *s;
{
return( hashtab[hashloc(s)] );
}



struct nameblock *makename(s)
char *s;
{
/* make a fresh copy of the string s */

char *copys();
register struct nameblock *p;

if(nhashed++ > HASHSIZE-3)
	fatal("Hash table overflow");

p = intalloc(sizeof(*p));
p->nextp = firstname;
p->namep = copys(s);
p->linep = 0;
p->done = 0;
p->septype = 0;
p->modtime = 0;

firstname = p;
if(mainname==0 && s[0]!='.') mainname = p;

hashtab[hashloc(s)] = p;

return(p);
}



char *copys(s)
register char *s;
{
register char *t;

for(t=s; *t++ ; );
if( (t-s) >= (lastchar-nextchar) )
	{
	if( (nextchar=calloc(NCHARS,sizeof(*t))) == NULL)
		fatal("Cannot allocate memory");
	lastchar = nextchar + NCHARS;
	}

t = nextchar;
while(*nextchar++ = *s++);
return(t);
}

equals(a,b)
register char *a,*b;
{
while(*a == *b)
	if(*a == '\0') return(1);
	else {++a; ++b;}

return(0);
}


char *concat(a,b,c)   /* c = concatenation of a and b */
register char *a,*b;
char *c;
{
register char *t;
t = c;

while(*t = *a++) t++;
while(*t++ = *b++);
return(c);
}

suffix(a,b,p)  /* is b the suffix of a?  if so, set p = prefix */
register char *a,*b,*p;
{
char *a0,*b0;
a0 = a;
b0 = b;

while(*a++);
while(*b++);

if( (a-a0) < (b-b0) ) return(0);

while(b>b0)
	if(*--a != *--b) return(0);

while(a0<a) *p++ = *a0++;
*p = '\0';

return(1);
}



int intalloc(n)
int n;
{
int p;

n = (n + sizeof(n)-1) / sizeof(n);

if(lastint-nextint <= n)
	{
	if( (nextint=calloc(NINTS,sizeof(n))) == NULL)
		fatal("Cannot allocate memory");
	lastint = nextint + NINTS;
	}

p = nextint;
nextint =+ n;

return(p);
}

/* copy string a into b, substituting for arguments */
subst(a,b)
register char *a,*b;
{
register char *s;
char vname[100];
struct varblock *varptr(), *vbp;
char *copstr();
char closer;

if(a!=0)  while(*a)
	{
	if(*a != '$') *b++ = *a++;
	else if (*++a == '\0') *b++ = *a++;
	else	{
		s = vname;
		if( *a=='(' || *a=='{' )
			{
			closer = ( *a=='(' ? ')' : '}');
			++a;
			while(*a == ' ') ++a;
			while(*a!=' ' && *a!=closer && *a!='\0') *s++ = *a++;
			while(*a!=closer && *a!='\0') ++a;
			if(*a == closer) ++a;
			}
		else	*s++ = *a++;

		*s = '\0';
		if( (vbp = varptr(vname)) ->varval != 0)
			{
			b = copstr(b, vbp->varval);
			vbp->used = 1;
			}
		}
	}

*b++ = '\0';
return(b);
}

/* copy s into t, return the location of the next
free character in s */
char *copstr(s,t)
char *s,*t;
{
while (*t) *s++ = *t++;
return(s);
}

setvar(v,s)
char *v, *s;
{
struct varblock *varptr(), *p;

p = varptr(v);
if(p->noreset == 0)
	{
	p->varval = s;
	p->noreset = inarglist;
	if(p->used && !equals(v,"@") && !equals(v,"*")
	    && !equals(v,"<") && !equals(v,"?") )
		fprintf(stderr, "Warning: %s changed after being used\n",v);
	}
}


eqsign(a)   /*look for arguments with equal signs but not colons */
char *a;
{
register char *s, *t;

while(*a == ' ') ++a;
for(s=a  ;   *s!='\0' && *s!=':'  ; ++s)
	if(*s == '=')
		{
		for(t=a ; *t!='=' && *t!=' ' ;  ++t );
		*t = '\0';

		for(++s; *s==' ' || *s=='\t' ; ++s);
		setvar(a, copys(s));
		return(1);
		}

return(0);
}


struct varblock *varptr(v)
char *v;
{
register struct varblock *vp;

for(vp=firstvar; vp!=0 ; vp = vp->nextp)
	if(equals(v , vp->varname)) return(vp);

vp = intalloc(sizeof(*vp));
vp->nextp = firstvar;
firstvar = vp;
vp->varname = copys(v);
vp->varval = 0;
return(vp);
}


fatal(s)
char *s;
{
if(s) fprintf(stderr, "%s.  Stop.\n", s);
else fprintf(stderr, "\nStop.\n");
#ifdef unix
exit(1);
#endif
#ifdef gcos
exit(0);
#endif
}



yyerror(s)
char *s;
{
char buf[50];
extern int yylineno;

fatal( sprintf(buf, "line %d: %s", yylineno, s) );
}



appendq(head,tail)
struct chain **head;
char *tail;
{
struct chain *p;
p = intalloc(sizeof(*p));
p->datap = tail;
while(head->nextp) head = head->nextp;
head->nextp = p;
}





mkqlist(p)
struct chain *p;
{
register char *qbufp, *s;
static char qbuf[300];

qbufp = qbuf;

for( ; p ; p = p->nextp)
	{
	s = p->datap;
	if (qbufp+strlen(s)+2 >= &qbuf[300])
		break;
	*qbufp++ = ' ';
	while (*s)
		*qbufp++ = *s++;
	}
*qbufp = '\0';
return(qbuf);
}
 yylineno;

(date; pwd; ls -l) | pr $1
if -w gram.c rm  gram.c
pr $1 pr_make.sh pwinfo Makefile defs *.[cy]
char *tail;
{
struct chain *p;
p = intalloc(sizeof(*p));
p->datap = tail;
while(head->nextp) head = head->nextp;
head->nextp = p;
}





mkqlist(p)
struct chain *p;
{
register char *qbufp, *s;
static char qbuf[300];

qbufp = qbuf;

for( ; p ; p = p->nextp)
	{
	s = p->datap;
	if (qbufp+strlen(s)+2 >= &qbuf[300])
		break;
	*qbufp++ = ' ';
	while (*s)
		*qbufp++ = *s++;
	}
*qbufp = '\0';
return(qbuf);
}
 yylineno;

Differences between PW make & original make:
-  If exit status is ignored for an executed command,
   a warning is not printed if the command returns a non-zero status.
   The original prints such a warning.
-  When the command is printed prior to execution,
   the command name is prefixed with ">";  this makes the commands stand out.
-  Has builtin suffix rules for LEAP script .t-.o files, and .z-.h files.
-  After reading internal "makerules" file,
   but before reading the local "makefile" file,
   PW version reads "makecomm"/"Makecomm"in login directory,
   and then in local directory.
   "makecomm" is useful for defining "common" macro names.
-  PW version exec's commands by using pexec(), which uses the .path file.
 command is printed prior to execution,
   the command name is prefixed with ">";  this makes the commands stand out.
-  Has builtin suffix rules for LEAP script .t-.o files, and .z-.h files.
-  After reading internal "makerules" file,
   but before reading the local "makefile" file,
   PW veyacc gram.y
mv y.tab.c gram.c
cc -O -Dpwb version.c main.c doname.c misc.c files.c dosys.c gram.c -lPW -lS -o make
rm gram.c
rm *.o
strip make
echo 'To re-archive, use: "make arch"'
 pexec(), which uses the .path file.
 command is printed prior to execution,
   the command name is prefixed with ">";  this makes the commands stand out.
-  Has builtin suffix rules for LEAP script .t-.o files, and .z-.h files.
-  After reading internal "makerules" file,
   but before reading the local "makefile" file,
   PW vechar *xxxvers "@(#)VERSION 3.1(PWB)     21 APRIL 1977\n" ;

/*
2.1 4/24/76	Base version

2.2 4/26/76     Error found by SRB in overriding pattern rules;
		corrected gram.y

2.3 4/27/76	Further correction for overriding pattern rules;
		corrected doname.c

2.4		Removed .CLEAR name, added .IGNORE.
		A .SUFFIXES rule without dependents clears the list

2.5		Stripped output

2.6		Changed doshell to accomodate new shell.

2.7		Following SRB's sugestion, added ${...} as
		alternate macro name

2.8		Defined macros AS and DTGEN in files.c.

2.9		Put in a fix to prevent removal of files
		upon interrupt in a  ::  rule.

2.10		Fixed bugs involving messages for ::
		and closing standard input

2.11		Changed time test from <= to <
		(equal times are considered in sync)

2.12		Installed -t flag (touch and update time of
		files rather than issue commands)
		Fixed bug in dosys

2.13		Fixed lex.c to allow sharps (#) in commands

2.14		Added .DEFAULT rule

2.15		Changed to <lS> I/O System (stdio.h)

2.16		Removed references to double floats and macro HAVELONGS;
		committed to use of long ints for times.
2.17		Corrected metacharacter list in dosys.c.
2.18		Miscellaneous fixes
2.19		Updated files.c to use include file stat.h
2.20		Added -q flag for Mike Lesk
2.21		Added AWK rules and  .w  suffix to  files.c
2.22		Added colon to the list of metacharacters
2.23		Macro substitutions on dependency lines.
		Redid argument and macro setting.
		Close files before exec'ing.
		Print > at beginning of command lines.
		No printing of commands beginnng with @.
2.24	Parametrized propt sequence in doname.c (4/1/77)
2.25	Added $? facility
2.26	Fixed bug in macro expansion
2.27	Repaired interrupt handling

3.1(PWB)  Use pexec(), add LEAP builtin rules - WDR 4/21/77.
*/
e Lesk
2.21		Added AWK rules and  .w  suffix to  files.c
2.22		Added colon to the list of metacharacters
2.23		Macro substitutions on dependency lines.
		Redid argument and macro setting.
		Close files before exec'ing.
		Print > at beginning of command lines.
		No printing of comma/*
 * mesg -- set current tty to accept or
 *	forbid write permission.
 *
 *	mesg [y] [n]
 *		y allow messages
 *		n forbid messages
 */

int	sbuf[40];

main(argc, argv)
char *argv[];
{
	register char *tty;

	tty = "/dev/ttyx";
	tty[8] = ttyn(1);
	if(stat(tty, sbuf) < 0) {
		write(2, "cannot stat\n", 12);
		exit(1);
	}
	if(argc < 2) {
		if(sbuf[2] & 02)
			goto no;
		goto yes;
	}
	if(*argv[1] == 'y')
		goto yes;

no:
	if(chmod(tty, 0600) < 0)
		goto bad;
	goto was;

yes:
	if(chmod(tty, 0622) < 0)
		goto bad;

was:
	if(sbuf[2] & 02)
		write(2, "was y\n", 6); else
		write(2, "was n\n", 6);
	exit(0);

bad:
	write(2, "cannot change mode\n", 19);
	exit(1);
}
;

main(argc, argv)
char *argv[];
{
	register char *tty;

	tty = "/dev/ttyx";
	tty[8] = ttyn(1);
	if(stat(tty, sbuf) < 0) {
		write(2, "cannot stat\n", 12);
		exit(1);
	}
	if(argc < 2) {
		if(sbuf[2] & 02)
			goto no;
		goto yes;
	}
	if(*argv[1] == 'y')
		goto yes;

no:
	if(chmod(tty, 0600) < 0)
		goto bad;
	goto was;

yes:
	if(chmod(tty, 0622) < 0)
		goto bad/*
 * mkdir -- make directories
 */

main(argc, argv)
char **argv;
{
	static char dname[128], pname[128];
	static nerror;
	register char *p1, *p2, *p3;

	while (--argc > 0) {
		argv++;
		p1 = argv[0];
		p2 = dname;
		p3 = pname;
		while (*p2++ = *p3++ = *p1++);
		p2[-1] = '/';
		*p2++ = '.';
		*p2 = '\0';
		while (p3>pname && *--p3!='/');
		if (p3 > pname)
			*p3 = '\0';
		else if (*p3 == '/')
			p3[1] = '\0';
		else {
			*p3++ = '.';
			*p3++ = '\0';
		}
		if (access(pname, 02)) {
			perror("mkdir");
			nerror++;
			continue;
		}
		if (mknod(argv[0], 0140755, 0) < 0) {
			perror("mkdir");
			nerror++;
			continue;
		}
		chown(argv[0], ((getgid()&0377)<<8) + (getuid()&0377));
		link(argv[0], dname);
		*p2++ = '.';
		*p2 = '\0';
		link(pname, dname);
	}
	return(nerror);
}
 = '/';
		*p2++ = '.';
		*p2 = '\0';
		while (p3>pname && *--p3!='/');
		if (p3 > pname)
			*p3 = '\0';
		else if (*p3 == '/')
			p3[1] = '\0';
		else {
			*p3++ = '.';
			*p3++ = '\0';
		}
		if (access(pname, 02)) {
			perror("mkdir");
			ne/*
 * mv file1 file2
 */
struct
{
	int	dev;
	int	inum;
	int	imode;
	char	nlink;
	char	uid;
	char	gid;
	char	siz0;
	char	siz1;
	int	addr[8];
	int	adate[2];
	int	mdate[2];
} sbuf1, sbuf2;
char strbuf[100];

main(argc, argv)
char *argv[];
{
	char **argp;
	char *p1, *p2, *source, *target;
	int i;
	int b;

	argp = argv;
	if(argc != 3) {
		printf("mv: Usage: mv name1 name2\n");
		return(1);
	}
	source = argp[1];
	target = argp[2];
	if(stat(source, &sbuf1) < 0) {
		printf("mv: %s non-existent\n", source);
		return(1);
	}
	if((sbuf1.imode & 060000) == 040000)
		goto mvdir;
	setuid(getuid());
	if(stat(target, &sbuf2) >= 0) {
		if((sbuf2.imode & 060000) == 040000) {
			p2 = strbuf;
			while(*p2++ = *target++)
				;
			p2[-1] = '/';
			target = argp[1];
			p1 = argp[1];
			while(*target)
				if(*target++ == '/')
					p1 = target;
			while(*p2++ = *p1++)
				;
			target = strbuf;
		}
		if(stat(target, &sbuf2) >= 0) {
			if(sbuf1.dev == sbuf2.dev && sbuf1.inum == sbuf2.inum) {
				printf("mv: %s and %s are identical\n", source, target);
				return(1);
			}
			if(access(target, 2)<0  && ttyn(0)!='x') {
				printf("mv: %s: %o mode ", target,
					sbuf2.imode & 07777);
				i = b = getchar();
				while(b != '\n' && b > 0)
					b = getchar();
				if(i != 'y')
					return(1);
			}
			if(unlink(target) < 0) {
				printf("mv: Cannot unlink %s\n", target);
				return(1);
			}
		}
	}
	if(link(source, target) < 0) {
		i = fork();
		if(i == -1) {
			printf("mv: Try again\n");
			return(1);
		}
		if(i == 0) {
			execl("/bin/cp", "cp", source, target, 0);
			printf("mv: No cp\n");
			return(1);
		}
		while(wait(&b) != i)
			;
		if(b != 0)
			return(1);
	}
	if(unlink(source) < 0) {
		printf("mv: Cannot unlink %s\n", source);
		return(1);
	}
	return(0);

mvdir:
	if(stat(target, &sbuf2) >= 0) {
		printf("mv: Directory %s exists\n", target);
		return(1);
	}
	p1 = source;
	p2 = target;
	while(*p1 == *p2) {
		p1++;
		if(*p2++ == 0) {
			printf("mv: ?? source == target, source exists and target doesnt\n");
			return(1);
		}
	}
	while(*p1)
		if(*p1++ == '/') {
			printf("mv: Directory rename only\n");
			return(1);
		}
	while(*p2)
		if(*p2++ == '/') {
			printf("mv: Directory rename only\n");
			return(1);
		}
	if (*--p1=='.' && p1==source
	 || *--p1=='.' && p1==source) {
		printf("mv: Cannot rename %s\n", source);
		return(1);
	}
	b = 0;
	p1 = source;
	while(*p1)
		if(*p1++ == '/') {
			p2 = p1;
			b++;
		}
	p1 = source;
	if(b == 0) {
		p1 = ".";
		p2 = p1+2;
	}
	*--p2 = '\0';
	if(access(p1, 2) < 0) {
		printf("mv: No write access to %s\n", p1);
		return(1);
	}
	*p2 = '/';
	if(link(source, target) < 0) {
		printf("mv: ?? directory link failed\n");
		return(1);
	}
	if(unlink(source) < 0) {
		printf("mv: 