	.psect	.text.,con,shr
	.iif ndf mcexec , .nlist
;
; call macro definitions
;
; call/return
;
	.macro	call subr
	jsr	pc,subr
	.endm
	.macro	return
	rts	pc
	.endm
;
; gencall-generate macro that calls subroutine of same name
;
	.macro	gencal name
	.macro	name
	call	name
	.endm
	.endm
;
; generate call macros
;
	gencal	savreg		;save registers
	gencal	expr		;call the expression evaluator
	gencal	term
	gencal	relexp
	gencal	reltst
	gencal	absexp
	gencal	abstst
	gencal	abserr
	gencal	glbexp
	gencal	abstrm		;absolute term
	gencal	reltrm		;relocatable term
	gencal	glbtrm		;global term
	gencal	getsym
	gencal	setsym
	gencal	getr50
	gencal	setr50
	gencal	tstr50
	gencal	getnb
	gencal	setnb
	gencal	getchr
	gencal	setchr
	gencal	gsarg
	gencal	tstarg
	gencal	setimm
	gencal	setdsp
	gencal	stcode
	gencal	ssrch
	gencal	osrch
	.iif ndf xmacro, gencal	msrch
	.iif ndf xedlsb, gencal	lsrch
	gencal	setpf0
	gencal	setpf1
	gencal	dnc
	gencal	cvtnum
	gencal	r50unp
	gencal	movbyt
	gencal	setxpr
	.if ndf	xcref
	gencal	crfref		;cross reference a symbol
	gencal	crfdef		;ditto, defining it
	.iff
	.macro	crfref		;dummy if no cref
	.endm
	.macro	crfdef
	.endm
	.endc
;
; character scan macros
;
	.macro	chscan	table	;character scan
	mov	#table,r0
	call	chscan
	.endm
	.macro	gchtbl	char,	addr	;gen character scan table
	.word	addr,	char
	.endm
;
; roll handler routine calls
;
	.macro	search	rolnum	;binary search
	mov	#rolnum,r0
	call	search
	.endm
	.macro	scan	rolnum	;linear scan
	mov	#rolnum,r0
	call	scan
	.endm
	.macro	scanw	rolnum	;linear scan, one word
	mov	#rolnum,r0
	call	scanw
	.endm
	.macro	next	rolnum	;fetch next entry
	mov	#rolnum,r0
	call	next
	.endm
	.macro	append	rolnum	;append to end of roll
	mov	#rolnum,r0
	call	append
	.endm
	.macro	zap	rolnum	;clear roll
	mov	#rolnum,r0
	call	zap
	.endm
	gencal	insert		;insert (must be preceded by one
				;of the above to set pointers)
	gencal	setrol		;save and set regs for above
;
; listing macros
;
	.macro	putkb addr
	mov	addr,r0
	call	putkb
	.endm
	.macro	putlp addr
	mov	addr,r0
	call	putlp
	.endm
	.macro	putkbl addr
	mov	addr,r0
	call	putkbl
	.endm
	.macro	putlin addr
	.if dif	<addr>,<r0>
	mov	addr,r0
	.endc
	call	putlin
	.endm
;
; pdp11/45-40 instruction macros
;
	.if ndf	pdpv45
	.macro	mul	src,dst
	.iif dif <src>,<r3>,	mov	src,r3
	.iif dif <dst>,<r0>,	.error	;illegal mul args
	.globl	mul
	call	mul
	.endm
	.macro	div	src,dst
	.iif dif <src>,<r3>,	mov	src,r3
	.iif dif <dst>,<r0>,	.error	;illegal div args
	.globl	div
	call	div
	.endm
	.macro	sob	reg,addr
	dec	reg
	bne	addr
	.endm
	.endc
;
; error and set nonzero macros
;
	.macro	error	arg
	bis	#err.'arg,errbts
	.endm
	.macro	setnz	addr	;set addr to non-zero for t/f flags
	mov	sp,addr
	.endm
;
; integer multilpy immediate macro
;
	.macro	imuli	count,addr
	.list	meb
t.val=	count
	.if eq	t.val
	clr	addr
	.iff
	.if lt	t.val
t.val=	-t.val
	neg	addr
	.endc
t.flag=	0
t.mask=	040000
	.rept	^d14
	.if le	t.mask-t.val
	.if ne	t.mask&t.val
	.if ne	t.mask-t.val
	.if eq	t.flag
	mov	addr,-(sp)
t.flag=	1
	.iff
	.if ne	t.mask-1&t.val
	add	(sp),addr
	.iff
	add	(sp)+,addr
t.flag=	0
	.endc
	.endc
	.endc
	.endc
	asl	addr
	.endc
t.mask=	t.mask/2
	.endr
	.if ne	t.flag
	add	(sp)+,addr
	.endc
	.endc
	.nlist	meb
	.endm
	.iif ndf mcexec , .list
