#

#include	"mas.h"
extern syntax();
extern error();

extern pc_def;
extern regi, ofstbts, postbyte;
extern int curfb[];
extern int findes;
extern char inbuf[];
extern lc, accvalid;
extern int nchar;
extern char *nextch;
extern char symbuf[];
extern char tch;
extern opct;


extern struct fb *fbtable;
extern struct expr exptab[];


extern struct evalx r;

char  peekc;		/*  used  in  getch  and  nonspec  */






digit(ch)
char ch;
{
register char c;
	if ( ((c = ch) >= '0') && (c <= '9') )
		return(1);
	return(0);
}


getsym(ch)
char ch;
{
register char *s,c;
register n;
	s = symbuf;
	n = 0;
	if ( (c = ch) == '\0' )
		c = getch();
	for(;;) {
		if ( (c >= 'a') || digit(c) || (c == '_') || (c == '.')
				|| ((c >= 'A') && (c <= 'Z')) ) {
			if ( n++ < 8 )
				*s++ = c;
			c = getch();
		}
		else
		if ( c == EOF )
			eoferr();
		else {
			tch = c;
			*s = '\0';
			return(n);
		}
	}
}



getch()
{
register char c;

	if ( peekc ) {
		c = peekc;
		peekc = 0;
		return( c );
	}
	if ( nextch >= inbuf+nchar )
		return(0);
	c = *nextch++;
	if ( (nextch >= inbuf+nchar) && (nchar == 512) )
		nchar = read(findes, nextch=inbuf, 512);

	if ( (c > '~') || ( (c < SP) && ((c != NL) && (c != TAB))) ) {
		error("garbage char");
		return(getch());
	}

	return(c);
}


getitem(ch)
char ch;
{
register char c;
register l;
register struct expr *x;
char c1;
int n;

	x = exptab;
	if ( (c = ch) == MINUS ) {
		if ( (c = getch()) == MINUS )
			syntax();
		x->e_rand = e_CON;
		x->e_rator = e_MINUS;
		x->e_val = 0;
		x++;
	}

	for(;;) {

	if ( (l = getsym(c)) == 0 ) {
		if ( (c = tch) == STAR ) {
			if ( (l = getsym(0)) != 0 )
				syntax();
			x->e_rand = e_PC;
		}
		else
		if ( c == QUOTE ) {
			if ( (l = getsym(0)) == 0 ) {
				if ( tch <= SP )
					charerr();
				if ( tch == BACKSL ) {
					if ( (l = getsym(0)) == 0 )
						c = BACKSL;
					else
					if ( l != 1 )
						charerr();
					else {
						c = symbuf[0];
						if ( (c = spech(c)) == BACKSL )
							charerr();
					}
				}
				else {
					c = tch;
					if ( (l = getsym(0)) != 0 )
						charerr();
				}
			}
			else
			if ( l != 1 )
				charerr();
			else
			c = symbuf[0];
			x->e_rand = e_CON;
			x->e_val = c;
		}
		else
			return(0);
	}
	else {
		c = symbuf[0];
		if ( digit(c) ) {
			c1 = symbuf[1] | 040;
			if ( (l == 2) && ((c1 == 'f') || (c1 == 'b')) ) {
				if ( c1 == 'f' )
					c =+ 10;
				x->e_rand = e_TL;
				n = x->e_val = curfb[c-'0'];
				if ( (fbtable[n].fb_def == UND) &&
						(fbtable[n].fb_pc == 0) )
					fbtable[n].fb_pc = lc;
			}
			else if(c == '0')	/* octal number */
			{
				x->e_val = getoct();
				x->e_rand = e_CON;
			}
			else if ( l > 5 )
				numerr();
			else {
				x->e_val = getdec(&symbuf[l]);
				x->e_rand = e_CON;
			}
		}
		else		/* first char alphabetic */
		if ((l==1) && ((symbuf[0]=='a') || (symbuf[0]=='b')
				|| (symbuf[0]=='d')))  {
			if (accvalid && (x == exptab))
				return(-1);
			else
				syntax();
		}
		else {
			x->e_val = lookup();
			x->e_rand = e_SYM;
		}
	}

	switch ( tch ) {
	case SLASH:
		x->e_rator = e_SLASH;
		x++;
		break;

	case MINUS:
		x->e_rator = e_MINUS;
		x++;
		break;

	case PLUS:
		x->e_rator = e_PLUS;
		x++;
		break;

	case STAR:
		x->e_rator = e_STAR;
		x++;
		break;

	case AMPER:
		x->e_rator = e_AMPER;
		x++;
		break;

	case LTHAN:
		x->e_rator = e_LTHAN;
		x++;
		break;

	case GTHAN:
		x->e_rator = e_GTHAN;
		x++;
		break;

	default:
		x->e_rator = e_TERM;
		return(1);
	}
	c = 0;
	}
}

getoct()
{
	register number;
	register char *s;
	register char c;

	s = symbuf;
	number = 0;
	while(c = *s++)
	{
		if( '0' > c || c > '7')
			numerr();
		number = (number << 3) + ((c - '0') & 07);
	}

	return(number);
}

getdec(st)
char *st;
{
register char *s, c;
register n;
int fac;
	n = 0;
	s = st;
	fac = 1;
	while ( --s >= symbuf ) {
		if ( digit(c = *s) )
			n =+ (c-'0') * fac;
		else
			numerr();
		fac =* 10;
	}
	return(n);
}













accsym(len, ch)
char ch;
{
register char c;

	if ( len == 1 ) {
		c = ch | 040;
		return( c == 'a' ? 1 : 0);
	}
	return(0);
}



getacc()
{
register char c;

	c = getnonbl();
	if ( accsym(getsym(c), c) == 0 )
		syntax();
}



getnonbl()
{
register char c;

	if ( ((c = tch) != SP) && (c != TAB) )
		syntax();
	while ( ((c = getch()) == SP) || (c == TAB) );
	if ( c == NL )
		syntax();
	if ( c == EOF )
		eoferr();
	return(c);
}

getnxt()
{
	register char c;

	if(tch)
	{
		c = tch;
		tch = 0;
	}
	else
		c = ' ';

	while (c == ' ' || c == '\t')
	{
		c = getch();
		if(c == EOF)
			eoferr();
	}
	if(c == '\n')
		tch = c;
	return c;
}

getreg(c)
register char c;
{
	register n;
	if( (n = getsym(c)) != 1)
	{
		syntax();
	}
	switch (symbuf[0]){
		case 'x':
			regi = 0;
			break;
		case 'y':
			regi = 1;
			break;
		case 'u':
			regi = 2;
			break;
		case 's':
			regi = 3;
			break;
		case 'p':
			regi = 4;
			break;
		default:
			regi = -1;
	}
	return(0);
}









getexpr()
{
register char c;

	c = getnonbl();
	if ( (getitem(c) == 0) || (tch > SP) )
		syntax();
}



getlis()
{
register char c;
register i, n;

	c = getnonbl();
	for ( i=0; ; i++ ) {
		n = getitem(c);
		if ( (c = tch) <= SP ) {
			if ( n == 0 )
				syntax();
			return(++i);
		}
		if ( c != COMMA )
			syntax();
		c = getch();
	}
}



spech(ch)
char ch;
{
	switch ( ch ) {
	case 'b':
		return(BS);
	case 'n':
		return(NL);
	case 'r':
		return(CR);

	case 's':
		return(SP);

	case 't':
		return(TAB);

	case '0':
		return('\0');
	}

	return(BACKSL);
}



getcomm()
{
register char c;

	for ( c = tch; c != NL; c = getch() )
		if ( c == EOF )
			eoferr();
}



getnl()
{
	getcomm();
	reset();
}


char bits[]{
	0x06,	0x10,	0x20,	0x40,	0x40,	0x80,	0x00,	0x00,
	0x02,	0x04,	0x01,	0x08};



getPP()
{
register n;
char c;
	if (((c=getnonbl()) == HATCH) || (c == EQUAL)) {
		accvalid =0;
		getitem(0);
		evalexpr();
		if(r.r_type != ABS) 
			amoderr();
		return(0);
	}
	else {
		if (( n=gettreg(c)) < 0)
			syntax();
		postbyte = bits[n];
		while (tch == COMMA) {
			if (( n = gettreg(0) ) < 0)
				syntax();
			postbyte =| bits[n];
		}
		if (tch > SP)
			syntax();
		return(0);
	}
}


gettreg(c)
{
int n;
	if ( (n = getsym(c)) == 1){
		switch (symbuf[0]){
		case 'd':	return(0);
		case 'x':	return(1);
		case 'y':	return(2);
		case 'u':	return(3);
		case 's':	return(4);
		case 'a':	return(8);
		case 'b':	return(9);
		default:	return(-1);
		}
	}
	else
	if (n == 2) {
		if ((symbuf[0] == 'p') && (symbuf[1] == 'c'))
			return(5);
		else
		if ((symbuf[0] == 'c') && (symbuf[1] == 'c'))
			return(10);
		else
		if ((symbuf[0] == 'd') && (symbuf[1] == 'p'))
			return(11);
		else	
			return(-1);
	}
	else
		return(-1);
}


getregop()
{
int c;
int n, m;
	c = getnonbl();
	if (((n = gettreg(c)) < 0) || (tch != COMMA))
		syntax();
	if (( ( m = gettreg(0)) < 0) || (tch > SP))
		syntax();
	if( ( n & 0x8 ) != ( m & 0x8 ) )
			syntax();
}
getoper()
{
char c;
long n;

	ofstbts = 0;
	accvalid = 0;

	switch ( c = getnonbl()){

	case HATCH:
	case EQUAL:
		if ((getitem(getch()) == 0) || (tch > SP))
			syntax();
		return(m_IM1);
	case LTHAN:
		if ((getitem(getch()) == 0) || (tch > SP))
			syntax();
		return(m_DIR);
	case COMMA:
		if ( (c=getch()) == MINUS) {
			if ( (c=getch()) == MINUS) {
				getreg(0);
				if ((regi < 0) || (tch > SP))
					syntax();
				postbyte = 0x83 | (regi << 5);
				return(m_IND);
			}
			else {
				getreg(c);
				if ((regi < 0) || (tch > SP))
					syntax();
				postbyte = 0x82 | (regi << 5);
				return(m_IND);
			}
		}
		else {
			getreg(c);
			if(regi < 0)
				syntax();
			if (tch <= SP)  {
				postbyte = 0x84 | (regi << 5);
				return(m_IND);
			}
			else  {
				if (tch != PLUS)
					syntax();
				if (getsym(0) != 0)
					syntax();
				if (tch == PLUS)
					postbyte = 0x81;
				else
					postbyte = 0x80;
				postbyte =| (regi << 5);
				return(m_IND);
			}
		}
	case LPAR:
		if ((c=getch()) == COMMA) {
			if ((c=getch()) == MINUS) {
				if (getch() == MINUS) {
					getreg(0);
					if((regi < 0) || (tch != RPAR))
						syntax();
					postbyte = 0x93 | (regi << 5);
					return(m_IND);
				}
				else
					syntax();
			}
			else {
				getreg(c);
				if (regi < 0)
					syntax();
				if (tch == RPAR) {
					postbyte = 0x94 | (regi << 5);
					return(m_IND);
				}
				else
				if (tch == PLUS) {
					if((getch()==PLUS)&&(getch()==RPAR)) {
						postbyte = 0x91 | (regi << 5);
						return(m_IND);
					}
					else
						syntax();
				}
				else
					syntax();
			}
		}
		else {
			accvalid = 1;
			if (getitem(c) > -1) {
				if (tch == COMMA) {
					ofstbts = 2;
					pc_def = EST;
					getreg(0);
					if ((regi < 0) || (tch != RPAR))
						syntax();
					outaform(a_DINDX);
					return(m_IND);
				}
				else {
					if (tch == RPAR) {
						ofstbts = 2;
						postbyte = 0x9f;
						return(m_IND);
					}
					else
						syntax();
				}
			}
			else { /*accu*/
				switch (symbuf[0]) {
				case 'a':
					postbyte = 0x96;
					goto abd;
				case 'b':
					postbyte = 0x95;
					goto abd;
				case 'd':
					postbyte = 0x9b;
				abd:
					if (tch != COMMA)
						syntax();
					getreg(0);
					if ((regi < 0) || (tch != RPAR))
						syntax();
					postbyte =| (regi << 5);
					return(m_IND);
				}
			}
		}
	default:
		accvalid = 1;
		if (getitem(c) > -1) {
			if (tch == COMMA) {
				ofstbts = 2;
				pc_def = EST;
				getreg(0);
				if ((regi < 0) || (tch > SP))
					syntax();
				outaform(a_INDX);
				return(m_IND);
			}
			else  {
				if (tch <= SP)
					return(m_EXT);
				else
					syntax();
			}
		}
		else {
			switch (symbuf[0]) {
			case 'a':
				postbyte = 0x86;
				goto abc;
			case 'b':
				postbyte = 0x85;
				goto abc;
			case 'd':
				postbyte = 0x8b;
			abc:
				if (tch != COMMA)
					syntax();
				getreg(0);
				if (regi <0)
					syntax();
				postbyte =| (regi << 5);
				return(m_IND);
			}
		}
	}
}
