#
/*
 *  link editor
 */

/*
 *	modded to accept concatenated switches eg.
 *	ld -r -x === ld -rx
 * 				C. H. Maltby esq.
 */

#define	SIGINT	2
#define	ARCMAGIC 0177545
#define	FMAGIC	0407

#define	EXTERN	040
#define	UNDEF	00
#define	ABS	01
#define	TEXT	02
#define	DATA	03
#define	BSS	04
#define	COMM	05	/* internal use only */

#define	RABS	00
#define	RTEXT	0100000
#define	RDATA	0120000
#define	RBSS	0140000
#define	REXT	0160000
#define RELAT	0010000

#define	RELFLG	01
#define	NROUT	256
#define	NSYM	807
#define	NSYMPR	700

#define	RONLY	0400

char	premeof[] "Premature EOF";

/* I/O buffers, two pages to attempt optimal reading */
struct	page {
	int	nuser;		/* current number of users of this block */
	int	bno;		/* block number */
	int	nibuf;		/* number of chars remaining */
	char	buff[512];
} page[2];

/* for use when I/O stream not active */
struct	{
	int	nuser;
	int	bno;
} fpage;

/* I/O stream header */
struct	stream {
	char	*ptr;		/* next word */
	int	bno;
	int	nibuf;
	int	size;		/* size requested in last dseek */
	struct	page *pno;	/* page to use */
};

struct	stream text;
struct	stream reloc;

/* archive file directory */
struct	archdr {
	char	aname[14];
	int	atime[2];
	char	auid, agid;
	int	amode;
	int	asize[2];
} archdr;

/* binary file header */
struct	filhdr {
	int	fmagic;
	unsigned	tsize;
	unsigned	dsize;
	unsigned	bsize;
	unsigned	ssize;
	int	entry;
	int	pad;
	int	relflg;
} filhdr;

/* table if library entries used */
struct	liblist {
	int	off;
	int	bno;
};

struct	liblist	liblist[NROUT];
struct	liblist	*libp { &liblist[0] };

struct	symbol {
	char	sname[8];
	char	stype;
	char	spad;
	int	svalue;
};

struct	symbol	cursym;
struct	symbol	symtab[NSYM];
struct	symbol	*hshtab[NSYM+2];
struct	symbol	*symp { symtab };
struct	symbol	**local[NSYMPR];
struct	symbol	*p_etext;
struct	symbol	*p_edata;
struct	symbol	*p_end;
struct	symbol	*entrypt;

int	xflag;		/* discard local symbols */
int	Xflag;		/* discard locals starting with 'L' */
int	Sflag;		/* discard all except locals and globals*/
int	rflag;		/* preserve relocation bits, don't define common */
int	arflag;		/* original copy of rflag */
int	sflag;		/* discard all symbols */
int	dflag;		/* define common even with rflag */

int	ofilfnd;
char	*ofilename	"l.out";
int	infil;
char	*filname;

int	tsize;
int	dsize;
int	bsize;
int	ssize;
int	nsym;

int	torigin;
int	dorigin;
int	borigin;

int	tnbase;	/* new base for text segment */
int	dnbase;	/* new base for data segment */
int	bnbase;	/* new base for bss segment */
int	errlev;
int	delarg	4;
char	tfname[]	"/tmp/lxyyyyy";
int	toutb[259];
int	doutb[259];
int	troutb[259];
int	droutb[259];
int	soutb[259];

struct	symbol	**lookup();
struct	symbol	**slookup();

main(argc, argv)
char **argv;
{
	extern int delexit();
	register c;
	register char *ap, **p;
	struct symbol **hp;

	if ((signal(SIGINT, 1) & 01) == 0)
		signal(SIGINT, delexit);
	if (argc == 1)
		exit(4);
	p = argv + 1;
	/* process the arguments extracting the symbols from the files */
	for (c = 1; c<argc; c++) {
		filname = 0;
		ap = *p++;
		if (*ap++ == '-')
		{
			while( *ap )
			{
				switch (*ap++)
				{
		
			    case 'o':
					if (++c >= argc)
						error(1, "Bad output file");
					ofilename = *p++;
					ofilfnd++;
					continue;
		
			    case 'u':
			    case 'e':
		
					if (++c >= argc)
						error(1, "Bad 'use' or 'entry'");
					if (*(hp = slookup(*p++)) == 0) {
						*hp = symp;
						enter();
					}
					if (ap[-1]=='e')
						entrypt = *hp;
					continue;
		
			    case 'l':
					ap--;
					goto nxtrg;
		
			    case 'x':
					xflag++;
					continue;
		
			    case 'X':
					Xflag++;
					continue;
		
			    case 'S':
					Sflag++; 
					continue;
		
			    case 'r':
					rflag++;
					arflag++;
					continue;
		
			    case 's':
					sflag++;
					xflag++;
					continue;
		
			    case 'd':
					dflag++;
					continue;
				}
			}
			continue;
		}
	nxtrg:
		load1arg(--ap);
		close(infil);
	}
	filname = 0;
	middle();
	setupout();
	p = argv+1;
	libp = liblist;
	/* reprocess the arguments this time get the data */
	for (c=1; c<argc; c++) {
		ap = *p++;
		if (*ap++ == '-')
		{
			while( *ap )
			{
				switch (*ap++)
				{

			    case 'u':
			    case 'e':
			    case 'o':
					++c;
					++p;
			    default:
					continue;

			    case 'l':
					ap--;
					goto nxt2rg;
				}
			}
			continue;
		}
	nxt2rg:
		load2arg(ap-1);
		close(infil);
	}
	finishout();
}

/*
 * examin the next file if it is an archive
 * split it into separate units and pass to
 * load1 as ordinary file
 */
load1arg(acp)
char *acp;
{
	register char *cp;
	register noff, nbno;

	cp = acp;
	if (getfile(cp)==0) {	/* is it an ordinary file? */
		load1(0, 0, 0);	/* yes */
		return;
	}
	/* archive file */
	nbno = 0;	/* start at block 0 */
	noff = 2;	/* but skip the archive majic number */
	for (;;) {
		dseek(&text, nbno, noff, sizeof archdr);
		if (text.size <= 0) {	/* is there any more in the file */
			libp->bno = -1;	/* no so mark the end of this archive */
			libp++;
			return;
		}
		mget(&archdr, sizeof archdr);
		/* return of 1 indicates file useful, 0 not useful */
		if (load1(1, nbno, noff + sizeof archdr)) {
			libp->bno = nbno;	/* remember start of this entry */
			libp->off = noff;
			libp++;
		}
		noff =+ ((archdr.asize[1]&0777)+sizeof(archdr)+1) & ~01;
		/* skip to next entry */
		nbno =+ (archdr.asize[1] >> 9) & 0177;
		nbno =+ (archdr.asize[0]) << 7;
		nbno =+ noff >> 9;
		noff =& 0777;
	}
}

/*
 * scan file symbol table for new symbols
 * libflag set if file is library
 * bno is block to start at
 * off is word offset in block
 */
load1(libflg, bno, off)
{
	register struct symbol *sp, **hp, ***cp;
	struct symbol *ssymp;
	int ndef, nloc, type, mtype;

	readhdr(bno, off);	/* read module header */
	tnbase = tsize;
	dnbase = dsize;
	bnbase = bsize;
	ndef = 0;
	nloc = sizeof cursym;
	cp = local;
	ssymp = symp;
	if ((filhdr.relflg&RELFLG)==1) {
		error(0, "No relocation bits");
		return(0);
	}
	off =+ (sizeof filhdr) + (filhdr.tsize + filhdr.dsize) * 2;
	/* seek to start of symbol table in file */
	dseek(&text, bno, off, filhdr.ssize);
	while (text.size > 0) { /* text.size is what remains of requested I/O */
		mget(&cursym, sizeof cursym);
		type = cursym.stype;
		if (Sflag) { /* strip all but local and global symbols */
			mtype = type&037;
			if (mtype==1 || mtype>4) {
				continue;
			}
		}
		if ((type&EXTERN)==0) { /* discard locals starting with 'L' */
			if (Xflag==0 || cursym.sname[0]!='L')
				nloc =+ sizeof cursym;
			continue;
		}
		symreloc();
		hp = lookup();
		if ((sp = *hp) == 0) { /* does the symbol exist */
			*hp = enter(); /* no so just add it */
			*cp++ = hp;
			continue;
		}
		if (sp->stype != EXTERN+UNDEF) /* do we have definition */
			continue;
		if (cursym.stype == EXTERN+UNDEF) { /* common type symbol */
			if (cursym.svalue > sp->svalue)
				sp->svalue = cursym.svalue;
			continue;
		}
		if (sp->svalue != 0 && cursym.stype == EXTERN+TEXT)
			continue;
		ndef++;
		sp->stype = cursym.stype;
		sp->svalue = cursym.svalue;
	}
	if (libflg==0 || ndef) {
		tsize =+ filhdr.tsize;
		dsize =+ filhdr.dsize;
		bsize =+ filhdr.bsize;
		ssize =+ nloc;
		return(1);
	}
/*
 * No symbols defined by this library member.
 * Rip out the hash table entries and reset the symbol table.
 */
	symp = ssymp;
	while (cp > local)
		**--cp = 0;
	return(0);
}

middle()
{
	register struct symbol *sp;
	register t, csize;
	int nund, corigin;

	p_etext = *slookup("_etext");
	p_edata = *slookup("_edata");
	p_end = *slookup("_end");
/*
 * If there are any undefined symbols, save the relocation bits
 * and change flags so the module may be relinked.
 */
	if (rflag==0) for (sp=symtab; sp<symp; sp++)
		if (sp->stype==EXTERN+UNDEF && sp->svalue==0
		 && sp!=p_end && sp!=p_edata && sp!=p_etext) {
			rflag++;
			dflag = 0;
			sflag = 0;
			break;
		}
/*
 * Assign common locations.
 */
	csize = 0;
	if (dflag || rflag==0) {
		ldrsym(p_etext, tsize, EXTERN+TEXT);
		ldrsym(p_edata, dsize, EXTERN+DATA);
		ldrsym(p_end, bsize, EXTERN+BSS);
		for (sp=symtab; sp<symp; sp++)
			if (sp->stype==EXTERN+UNDEF && (t=sp->svalue)!=0) {
				t = (t+1) & ~01;
				sp->svalue = csize;
				sp->stype = EXTERN+COMM;
				csize =+ t;
			}
	}
/*
 * Now set symbols to their final value
 */
	if(rflag)	/* do not give final values */
	{
		dorigin = 0;
		corigin = 0;
		borigin = 0;
	}
	else
	{
		dorigin = tsize;
		corigin = dorigin + dsize;
		borigin = corigin + csize;
	}
	nund = 0;
	for (sp=symtab; sp<symp; sp++) switch (sp->stype) {
	case EXTERN+UNDEF:
		errlev =| 01;
		if (arflag==0 && sp->svalue==0) {
			if (nund==0)
				printf("Undefined:\n");
			nund++;
			printf("%.8s\n", sp->sname);
		}
		continue;

	case EXTERN+ABS:
	default:
		continue;

	case EXTERN+TEXT:
		sp->svalue =+ torigin;
		continue;

	case EXTERN+DATA:
		sp->svalue =+ dorigin;
		continue;

	case EXTERN+BSS:
		sp->svalue =+ borigin;
		continue;

	case EXTERN+COMM:
		sp->stype = EXTERN+BSS;
		sp->svalue =+ corigin;
		continue;
	}
	if (sflag || xflag)
		ssize = 0;
	bsize =+ csize;
	nsym = ssize / (sizeof cursym);
}

ldrsym(asp, val, type)
struct symbol *asp;
{
	register struct symbol *sp;

	if ((sp = asp) == 0)
		return;
	if (sp->stype != EXTERN+UNDEF || sp->svalue) {
		printf("%.8s: ", sp->sname);
		error(0, "Multiply defined");
		return;
	}
	sp->stype = type;
	sp->svalue = val;
}

/*
 * set up tempory files and write header to output file.
 */
setupout()
{
	register char *p;
	register pid;
	struct symbol *ep;

	if ((toutb[0] = creat(ofilename, 0600)) < 0)	/* fix031 */
		error(1, "Can't write output");
	pid = getpid();
	for (p = &tfname[12]; p > &tfname[7];) {
		*--p = (pid&07) + '0';
		pid =>> 3;
	}
	tcreat(doutb, 'a');
	if (sflag==0 || xflag==0)
		tcreat(soutb, 'b');
	if (rflag) {
		tcreat(troutb, 'c');
		tcreat(droutb, 'd');
	}
	filhdr.fmagic = FMAGIC;
	filhdr.tsize = tsize;
	filhdr.dsize = dsize;
	filhdr.bsize = bsize;
	filhdr.ssize = sflag? 0: (ssize + (sizeof cursym)*(symp-symtab));
	filhdr.entry = 0;
	if (ep = entrypt) {
		if (ep->stype!=EXTERN+TEXT)
			error(0, "Entry point not in text");
		else
			filhdr.entry = ep->svalue | 01;
	}
	filhdr.pad = 0;
	filhdr.relflg = (rflag==0);
	mput(toutb, &filhdr, sizeof filhdr);
	return;
}

tcreat(buf, letter)
int *buf;
{
	tfname[6] = letter;
	if ((buf[0] = creat(tfname, RONLY)) < 0)
		error(1, "Can't create temp");
}

/*
 * split library files and pass modules to load2
 */
load2arg(acp)
char *acp;
{
	register char *cp;
	register struct liblist *lp;

	cp = acp;
	if (getfile(cp) == 0) { /* binary file? */
		while (*cp)
			cp++;
		while (cp >= acp && *--cp != '/');
		mkfsym(++cp); /* add file name to symbol table */
		load2(0, 0);
		return;
	}
	/* scan the library using the library table to pick required entries */
	for (lp = libp; lp->bno != -1; lp++) { /* -1 marks the end of of a library */
		dseek(&text, lp->bno, lp->off, sizeof archdr);
		mget(&archdr, sizeof archdr);
		mkfsym(archdr.aname); /* add name to symbol table */
		load2(lp->bno, lp->off + (sizeof archdr));
	}
	libp = ++lp;
}

/*
 * process a file extracting the symbols text and data,
 * load2td does the relocating.
 */
load2(bno, off)
{
	register struct symbol *sp;
	register int *lp, symno;
	int type, mtype;

	readhdr(bno, off);
	tnbase = torigin;
	dnbase = dorigin;
	bnbase = borigin;
/*
 * Reread the symbol table, recording the numbering
 * of symbols for fixing external references.
 */
	lp = local;
	symno = -1;
	off =+ (sizeof filhdr);
	dseek(&text, bno, off+(filhdr.tsize+filhdr.dsize)*2, filhdr.ssize);
	while (text.size > 0) {
		symno++;
		mget(&cursym, sizeof cursym);
		symreloc();
		type = cursym.stype;
		if (Sflag) {
			mtype = type&037;
			if (mtype==1 || mtype>4) continue;
		}
		if ((type&EXTERN) == 0) {
			if (!sflag&&!xflag&&(!Xflag||cursym.sname[0]!='L'))
				mput(soutb, &cursym, sizeof cursym);
			continue;
		}
		if ((sp = *lookup()) == 0)
			error(1, "internal error: symbol not found");
		if (cursym.stype == EXTERN+UNDEF) {
			if (lp >= &local[NSYMPR])
				error(1, "Local symbol overflow");
			*lp++ = symno;
			*lp++ = sp;
			continue;
		}
		if (cursym.stype!=sp->stype || cursym.svalue!=sp->svalue) {
			printf("%.8s: ", cursym.sname);
			error(0, "Multiply defined");
		}
	}
	/* process text segment */
	dseek(&text, bno, off, filhdr.tsize);
	dseek(&reloc, bno, off + filhdr.tsize + filhdr.dsize, filhdr.tsize);
	load2td(lp, torigin, toutb, troutb);
	/* process data segment */
	dseek(&text, bno, off + filhdr.tsize, filhdr.dsize);
	dseek(&reloc, bno, off + filhdr.tsize * 2 + filhdr.dsize, filhdr.dsize);
	load2td(lp, dorigin, doutb, droutb);
	torigin =+ filhdr.tsize;
	dorigin =+ filhdr.dsize;
	borigin =+ filhdr.bsize;
}

load2td(lp, crel, b1, b2)
int *lp;
{
	register r, t;
	register struct symbol *sp;

	for (;;) {
	/*
	 * The pickup code is copied from "get" for speed.
	 */
		if(text.size == 0)
			break;
		t = get(&text);
		if(reloc.size == 0)
			error(1, "relocation error");
		r = get(&reloc);
		if(r == 0)
		{
			putc(r,b2);
			putc(t,b1);
			continue;
		}
		t = (t<<8) + get(&text);
		r = (r<<8) + get(&reloc);
		switch (r&0160000 )
		{

		case RTEXT:
			t =+ torigin;
			break;

		case RDATA:
			t =+ dorigin;
			break;

		case RBSS:
			t =+ borigin;
			break;

		case REXT:
			sp = lookloc(lp, r);
			if (sp->stype==EXTERN+UNDEF) {
				r = (r&RELAT) + (nsym+(sp-symtab)) + REXT;
				break;
			}
			t =+ sp->svalue;
			if(r&RELAT)
			{
				t =- crel;
				r = 0;
				break;
			}
			switch(sp->stype & 07)
			{
			case TEXT:	r = RTEXT;
					break;
			case DATA:	r = RDATA;
					break;
			case BSS:	r = RBSS;
					break;
			default:	r = 0;
			}
			break;
		}
		putc(t>>8, b1);
		putc(t, b1);
		if (rflag)
		{
			putc(r>>8, b2);
			putc(r, b2);
		}
	}
}

finishout()
{
	register n, *p;

	copy(doutb, 'a'); /* copy data segment */
	if (rflag) {
		copy(troutb, 'c'); /* copy text relocation */
		copy(droutb, 'd'); /* copy data relocation */
	}
	if (sflag==0) {
		if (xflag==0)
			copy(soutb, 'b'); /* copy symbol table */
		for (p=symtab; p < symp;)
			putw(*p++, toutb);
	}
	fflush(toutb);
	close(toutb[0]);
	if (!ofilfnd) {
		unlink("a.out");
		link("l.out", "a.out");
		ofilename = "a.out";
	}
	delarg = errlev;
	delexit();
}

delexit()
{
	register c;

	unlink("l.out");
	for (c = 'a'; c <= 'd'; c++) {
		tfname[6] = c;
		unlink(tfname);
	}
	if (delarg==0)
		chmod(ofilename, 0700);
	exit(delarg);
}

/* flush and close a file, reopen and copy to output file */
copy(buf, c)
int *buf;
{
	register f, *p, n;

	fflush(buf);
	close(buf[0]);
	tfname[6] = c;
	f = open(tfname, 0);
	while ((n = read(f, doutb, 512)) > 1) {
		n =>> 1;
		p = doutb;
		do
			putw(*p++, toutb);
		while (--n);
	}
	close(f);
}

/* make a symbol name and copy it to symbol file */
mkfsym(s)
char *s;
{

	if (sflag || xflag)
		return;
	cp8c(s, cursym.sname);
	cursym.stype = 037;
	cursym.svalue = torigin;
	mput(soutb, &cursym, sizeof cursym);
}

/*
 * read for the text I/O stream an bytes
 * to be placed at location aloc
 */
mget(aloc, an)
char *aloc;
{
	register char *loc, *p;
	register n;

	n = an;
	loc = aloc;
	if ((text.nibuf =- n) >= 0) { /* is there enough */
		if ((text.size =- n) > 0) { /* is it less than requested in dseek */
			p = text.ptr;
			do
				*loc++ = *p++;
			while (--n);
			text.ptr = p;
			return;
		} else
			text.size =+ n;
	}
	/* use get it will process the end condition correctly */
	text.nibuf =+ n;
	do {
		*loc++ = get(&text);
	} while (--n);
}

/* write words to I/O buffer */
mput(buf, aloc, an)
int *aloc;
{
	register *loc;
	register n;

	loc = aloc;
	n = an>>1;
	do {
		putw(*loc++, buf);
	} while (--n);
}

/*
 * seek into a file and read a block withe the required data
 * This is stored in one of two pages which are referenced through
 * an associated I/O stream structure.
 * This is used to separate two different i/o's on a file
 *
 * asp	a I/O stream pointer
 * ab	required block number
 * o	offset into block in bytes
 * s	size of data requesed, -1 do not change old size
 */
dseek(asp, ab, o, s)
{
	register struct stream *sp;
	register struct page *p;
	register b;
	int n;

	/* offset could be in next block */
	sp = asp;
	b = ab + ((o>>9) & 0177);
	o =& 0777;
	--sp->pno->nuser; /* free the old page */
	if ((p = &page[0])->bno!=b && (p = &page[1])->bno!=b)	/* is it the block required */
		if (p->nuser==0 || (p = &page[0])->nuser==0) {	/* is a page free */
			if (page[0].nuser==0 && page[1].nuser==0) /* can we chose one */
				if (page[0].bno < page[1].bno)	/* use the one with the smallest address */
					p = &page[0];
			p->bno = b;
			seek(infil, b, 3);
			if ((n = read(infil, p->buff, 512)) < 0)
				n = 0;
			p->nibuf = n;
		} else
			error(1, "No pages");	/* both pages in use help */
	++p->nuser;	/* use this page */
	sp->bno = b;	/* set up new stream parameters */
	sp->pno = p;
	sp->ptr = p->buff + o;
	if (s != -1)
		sp->size = s;
	if ((sp->nibuf = p->nibuf-o) <= 0)
		sp->size = 0;
}

/*
 * get word form I/O stream
 * if requested size is passed free page
 * read next block if necessary
 */
get(asp)
struct stream *asp;
{
	register struct stream *sp;

	sp = asp;
	if (--sp->nibuf < 0) {	/* any left */
		/* get more but do not change requested size */
		dseek(sp, sp->bno+1, 0, -1);
		--sp->nibuf;
	}
	if (--sp->size <= 0) {	/* passed requested size? */
		if (sp->size < 0)	/* free page */
			error(1, premeof);
		++fpage.nuser;
		--sp->pno->nuser;
		sp->pno = &fpage;
	}
	return *sp->ptr++ & 0377;
}

/*
 * open named file
 * check of library file (-l[x])
 */
getfile(acp)
char *acp;
{
	register char *cp;
	register c;
	int mjn;

	cp = acp;
	archdr.aname[0] = '\0';
	filname = cp;
	if (cp[0]=='-' && cp[1]=='l') { /* library file? */
		if(cp[2] == '\0')
			cp = "-la";
		filname = "/usr/lib/libxxxxxxxxxxxxxxx"; /* standard libraries */
		for(c=0; cp[c+2]; c++)
			filname[c+12] = cp[c+2];
		filname[c+12] = '.';
		filname[c+13] = 'a';
		filname[c+14] = '\0';
		if ((infil = open(filname+4, 0)) >= 0) { /* look in /lib first */
			filname =+ 4;
			goto OK;
		}
	}
	if ((infil = open(filname, 0)) < 0)
		error(1, "cannot open");
OK:
	page[0].bno = page[1].bno = -1; /* new file so reset pages */
	page[0].nuser = page[1].nuser = 0;
	text.pno = reloc.pno = &fpage;
	fpage.nuser = 2;
	dseek(&text, 0, 0, 2); /* read majic number */
	if (text.size <= 0)
		error(1, premeof);
	mget(&mjn, 2);
	return mjn == ARCMAGIC;
}

struct symbol **lookup()
{
	int i;
	register struct symbol **hp;
	register char *cp, *cp1;

	i = 0;
	for (cp=cursym.sname; cp < &cursym.sname[8];)
		i = (i<<1) + *cp++;
	for (hp = &hshtab[(i&077777)%NSYM+2]; *hp!=0;) {
		cp1 = (*hp)->sname;
		for (cp=cursym.sname; cp < &cursym.sname[8];)
			if (*cp++ != *cp1++)
				goto no;
		break;
	    no:
		if (++hp >= &hshtab[NSYM+2])
			hp = hshtab;
	}
	return(hp);
}

/*
 * setup special symbol name and type
 * and look it up
 */
struct symbol **slookup(s)
char *s;
{
	cp8c(s, cursym.sname);
	cursym.stype = EXTERN+UNDEF;
	cursym.svalue = 0;
	return(lookup());
}

enter()
{
	register struct symbol *sp;
	
	if ((sp=symp) >= &symtab[NSYM])
		error(1, "Symbol table overflow");
	cp8c(cursym.sname, sp->sname);
	sp->stype = cursym.stype;
	sp->svalue = cursym.svalue;
	symp++;
	return(sp);
}

symreloc()
{
	switch (cursym.stype) {

	case TEXT:
	case EXTERN+TEXT:
		cursym.svalue =+ tnbase;
		return;

	case DATA:
	case EXTERN+DATA:
		cursym.svalue =+ dnbase;
		return;

	case BSS:
	case EXTERN+BSS:
		cursym.svalue =+ bnbase;
		return;

	case EXTERN+UNDEF:
		return;
	}
	if (cursym.stype&EXTERN)
		cursym.stype = EXTERN+ABS;
}

error(n, s)
char *s;
{
	if (filname) {
		printf("%s", filname);
		if (archdr.aname[0])
			printf("(%.14s)", archdr.aname);
		printf(": ");
	}
	printf("%s\n", s);
	if (n)
		delexit();
	errlev = 2;
}

lookloc(alp, r)
{
	register int *clp, *lp;
	register sn;

	lp = alp;
	sn = r&07777;
	for (clp=local; clp<lp; clp =+ 2)
		if (clp[0] == sn)
			return(clp[1]);
	error(1, "Local symbol botch");
}

readhdr(bno, off)
{
	register st, sd;

	dseek(&text, bno, off, sizeof filhdr);
	mget(&filhdr, sizeof filhdr);
	if (filhdr.fmagic != FMAGIC)
		error(1, "Bad format");
	st = (filhdr.tsize+01) & ~01;
	filhdr.tsize = st;
	filhdr.dsize = (filhdr.dsize+01) & ~01;
	filhdr.bsize = (filhdr.bsize+01) & ~01;
}

cp8c(from, to)
char *from, *to;
{
	register char *f, *t, *te;

	f = from;
	t = to;
	te = t+8;
	while ((*t++ = *f++) && t<te);
	while (t<te)
		*t++ = 0;
}
