; The use and distribution of the information
; contained herein may be restricted.
;
title	tr,<basic+ translator>,24,22-jul-74,tph/mhb/jdm

; establish translator table

	org	xt,0
	zskip	tldipl-dotabv+2/2,tler18	;established as tler18's

; translator directives (verbs)

	org	xt,tkrand-dotabv

	.word	dorand	;randomize

	org	xt,tkchng-dotabv
	.word	dochan	;change
	.word	doinpt	;input
	.word	doprin	;print
	.word	dodim	;dim(ension)
	.word	dodef	;def(ine)
	.word	dogoto	;goto
	.word	doif	;if
	.word	dofor	;for
	.word	doon	;on
	.word	doretu	;return
	.word	dolet	;let
	.word	dodata	;data
	.word	dorest	;restore
	.word	doresu	;resume
	.word	dostop	;stop
	.word	doend	;end
	.word	dooner	;on error goto
	.word	doopen	;open
	.word	doclos	;close
	.word	dochai	;chain
	.word	dorem	;rem(ark)
	.word	donext	;next
	.word	doname	;name
	.word	doread	;read
	.word	dogosb	;gosub
	.word	dofnen	;fnend
	.word	doinpl	;input line
	.word	dowhil	;while
	.word	dountl	;until
	.word	dokill	;kill

	org	xt,tkslep-dotabv
	.word	doslep	;sleep
	.word	dowait	;wait
	.word	doshel	;shell (UNIX)

	org	pu,0
pu:	errerr	!fatal	;no print using unless this is overlaid
	.csect	tr

	.globl	newold,saint,tlendp,gusint
	.globl	editor,tl,tlidxh,select,rcicom
	.globl	tler18,tytb,tlgtok,tlpair
	.globl	tlpdst,tlbegh,tlcmwd,tlener
	.globl	tlgdfn,tlgfna,tlgenp,tlgln1,tlgpds

	.globl	catsup,catsua,tlptin,mupper
	.globl	lexan,maptok,tokdec,frespc
	.globl	edpus2,edclr,edscan,edendc
	.globl	edrsth,edtype,edfipn
	.globl	getagn,getagd,getag,lstop1,dltonn
	.globl	econom,r1schk
	.globl	indary,runim,asknam,fltlen
	.globl	savreg,resreg
;function block element locations
;fnbtag	=	0	 used in dodef routines
fnbpic	=	2	;function block picture word, bits for arg type
fnbval	=	4	;function block value, value of function stored here

;subroutine called by macro iftoka

tatest:	if  toka(r0),ne,(r5)+,tates1	;br if token not equal arg
	cmpb	toke(r0),#bastok	;z set if basic verb, etc matching argument
tates1:	rts	r5
arst00:	mov	#1,r3		;fixed length
	br	arst11		;rejoin the group

aryset:	jsr	r5,savreg	;save the registers
	mov	10(r1),r5	;get the header address
	add	r0,r5		;make the address absolute
	mov	#256.,r3	;get max possible
	mov	(r1)+,r2	;get max length # words
	beq	arst06		;branch if not specified
arst01:	cmp	r2,r3		;have we found it yet?
	bgt	arst02		;if so, r3 has word count
	asr	r3		;if not, divide r3 by 2.
	bne	arst01		;and try again if non-zero
	mov	#1-8.+256.,r3	;set up as 2 bytes if 1 specified
arst06:	add	#8.-256.,r3	;default to 16 in length
arst02:	mov	r5,r0		;abs header pointer
	add	#dim1,r0	;point at dim1
	add	#pdim2,r5	;point at pdim2
	mov	(r1)+,(r5)	;set pdim2
	mov	(r1),(r0)+	;set dim1
	mov	(r5),(r0)+	;set dim2
	mov	(r1)+,-(r5)	;set pdim1
	mov	(r1)+,r2	;get flags
	cmp	(r1)+,(r0)+	;rid of header - 1 beyond aryflg
	bisb	r2,-(r0)	;set aryflg bits
	bicb	#dskary,(r0)	;but turn off disk bit
	mov	(r1)+,r4	;slot number
	asl	r4		;doubled
	movb	r4,-(r0)	;into aryslt
	beq	arst12		;br if core based
	bisb	#dskary,1(r0)	;othws, turn on disk flag
arst12:	asl	r2		;make into a branch index
	add	r2,pc		;dispatch on type
	br	arst03		;branch for floating
	br	arst00		;branch for fixed
	tstb	(r0)		;see if core or disk
	bne	arst11		;branch if disk based
	mov	#3,r3		;string are length 3
	br	arst11		;continue

arst03:	mov	#fltlen,r3	;set length
arst11:	mov	r3,r4		;copy length per item
	mov	r3,-(r5)	;set maxstr to item word length
	dec	r4		;dec pseudo-length
	mov	(r1)+,-(r5)	;low-order offset
	add	r4,(r5)		;round up to next usable offset
	bic	r4,(r5)		;isn't this cute?
	mov	(r1),-(r5)	;high-order offset
	adc	(r5)		;carry from low-order round
	bcc	arst09		;br if reasonable amount of disk
arst08:	sizerr	!fatal		;would need too much disk
arst09:	cmp	-(r1),-(r1)	;save slot & offset words
	mov	-(r0),r3	;dim2
	inc	r3		;go one beyond last entry
	mov	-(r0),-(r1)	;dim1
	mov	r3,-(r1)	;we're set to jump into indx90
	sub	#dim1,r0	;after getting back to 1st header word
	jsr	pc,indary	;calculate limit in r2,r3
	mov	r2,-(r5)	;high-order limit
	mov	r3,-(r5)	;low-order limit
	tstb	-(r5)		;disk or core?
	bpl	arst07		;br if core
	mov	r3,2(r1)	;othws, update offset - low-order
	mov	r2,4(r1)	;high-order
arst05:	mov	r1,2(sp)	;return our r1 to saint
	jsr	r5,resreg	;restore the registers
	rts	pc		;and return

arst07:	tst	r2		;check core size reasonable
	bne	arst08		;br if too much core
	tst	r3		;see if
	bpl	arst05		;not obviously too large
	br	arst08		;32k is obvious
editor:	jsr	pc,catsua	;do absolute catsup
	jsr	pc,edpus2	;set to noname for a name
	jsr	pc,edclr	;delete temporary file now
	jsr	pc,edscan	;set up program name
				;beginning of translator, new startup
tl:	bic	#jfccc,jobf
	clr	-(r1)		;zero argument
	jsr	pc,getagd	;get rid of any immediate statements
tlnewl:	mov	mdd(r0),tlmind(r0)	;save string header pointer for possible restoration
	clr	tllino(r0)	;clear line no. loc.
	jsr	pc,tlbegh	;set scth to immediate statement, so 
				;eof won't wipe out last statement
	mov	(pc)+,-(sp)	;to set up final byte
	.byte	pphalt,ppnxts
	mov	bascur(r0),basbeg(r0)	;save current text file pointer
	jsr	pc,tlgto1	;get first token
	if	toke(r0),ne,#200,tlsam3,b	;test for line number

tlsam1:	swab	(sp)		;last byte should be nxts
	mov	toka(r0),-(r1)	;delete old one if any
	mov	(r1),tllino(r0)	;save line no.
	jsr	r5,lstop1	;remove and signal no continuing
	dltonn
	jsr	pc,lexan	;avoid remark suppression
tlsam3:	jsr	pc,tlbegh	;set up a header
	movb	(sp)+,tlenby(r0);post final byte
	iftoka	eq,endol,tlnewl	;go for new line in initial <cr><lf>
				;case or line no. <cr><lf> case
tlsam2:	jsr	pc,tlptin	;init. stack pointers
	clrb	tlinfl(r0)	;flag indicates call from top level
tlscal:	jsr	pc,tlscom	;call routine to compile statement
;notice error postings during compilation and report error
	mov	#jobf,r4	;get address of posting flag word
	mov	(r4),r2		;get contents
	bpl	tlb03		;nothing to do
	bic	#jfstop!jfrts,(r4)	;clear post-related bits
	bic	#-jfrts-1,r2	;clear all but bits to index on
	add	r2,pc		;dispatch
	br	tlb03		;"impossible" case--ignore it
	flterr	!fatal		;send flt-err message
	fixerr	!fatal		;send integer error message
	divby0	!fatal		;send div-by 0 err message
tlb03:	if	toka(r0),ne,#endol,tla1	;branch around cr/lf case
	jsr	pc,tlendh	;finish header
	bit	#edeoff,edflag	;see if line included an end statement
	beq	tlb01		;no
	jmp	edendc		;just finished generating core image

tlb01:	tst	tllino(r0)
	bne	tlnewl		;not immediate get new line
	mov	scth,r5		;block executing
	tstb	tagtyp(r5)	;of for, next, dim etc.
	bne	tlb02
	jmp	runim		;run it

tlb02:	nonoim	!fatal		;not legal immediate statement

tla1:	iftoka	eq,colon,tlsam4	;multiple statement case
	eoserr	!fatal		;illegal format-statement should have
				;been over but wasn't
tlsam4:	tst	tllino(r0)	;immediate mode?
	beq	tlb02		;yep, so error
	jsr	pc,lexan	;next one please
	br	tlsam2
;subroutine to compile a statement
;called from both top level (prev. page.)  and inside doif
tlscom:	clr	tlstpc(r0)	;zero "statement prog. counter"
	clr	tltopc(r0)	;zero "program counter"
	clr	ptokf(r0)	;clear ptokf and tlcofl (prev tokn & condit expr)
	clrb	tllsfl(r0)	;clear left-side flag
	mov	toka(r0),r2	;make toka more accessable
	bitb	#basf,toke(r0)	;check for a verb
	bne	2$		;if verb, then continue
	incb	ptokf(r0)	;if not verb, assume 'let'
	jmp	dolet		;by backing up token ptr & calling let

2$:	sub	#dotabv,r2	;check for operator (<dotabv)
	bhis	4$		;if >=dotabv then really a verb
3$:	tlopnv	!fatal		;else say not a legal program verb

4$:	cmp	r2,#tldipl-dotabv;check for within top range
	blos	5$		;branch if o.k.
	jmp	tler18		;else say 'what?' or 'illegal verb'

5$:	cmp	r2,#tldipb-tldipt;check for editor command
	bge	6$		;if program verb then proceed
	tst	tllino(r0)	;if editor command then check mode
	bne	3$		;if line numbered then error
	bit	#edcomp,edflag	;also check for non-keyboard command
	bne	3$		;only editor commands from keyboard allowed
	cmp	(sp)+,#tlscal+4	;final check is for internal recall
	bne	3$		;if not main call then error
6$:	jmp	@xt+tldipt(r2)	;now disptach to the 'do' routine
;construction of statement headers is accomplished as follows:
;when a line number is typed a header is procured and posted in tlcurh.
;if no line number is specified, the line is compiled as line 0, the
;immediate line. each special do routine for those statement types which
;require their own header (such as for) terminates the existing header
;and starts a new one (except when existing one is empty), using tlidxh,
;and takes care of posting appropriate codes in tagtyp. the push-pop is arranged
;to end on even boundary and this is indicated in the header as well as in proptr.
;tlidxh is a routine to end current, and set up new header
;it returns an abs pointer to tagtyp of header in r4

tlixnc:	;bic	#edcont,edflag	;new for,next,def,enddef
tlidxh:	mov	scth,r4		;current tag
	tst	tagpul(r4)	;see if used
	beq	tlidxr		;no
	jsr	pc,tlendh	;close it
tlbegh:	mov	tllino(r0),-(r1);get first available header this line
	jsr	pc,getagn	;ie unused
	mov	(r1),r4		;it will make one if necessary
	mov	(r1),scth	;post it as current header
	mov	spta,r3		;get pushpop base
	sub	r3,(r1)		;make relative header pointer
	neg	(r1)		;to make a header-rel pointer
	add	proptr(r3),(r1)	;to the push-pop
	tst	(r4)+		;skip link
	mov	(r1)+,(r4)+	;post current code location
	clr	(r4)+		;in tagpus, clear tagpul
	add	#tagtyp-tagtxt,r4	;point to type
	rts	pc		;ends pointing to tagtyp

tlidxr:	add	#tagtyp,r4	;pointer to typ as promised
	rts	pc

tlendh:	movb	tlenby(r0),-(r1)
	jsr	pc,scbppa	;put out nexts, or halt etc.
tlener:	bit	#trnker,edflag	;reentry during error processing?
	bne	tleven		;don't mess up text pointers then
	mov	scth,r4		;statement header
	add	#tagtxt,r4	;pntr to txt
	mov	basbeg(r0),(r4)	;similarily for text
	mov	bascur(r0),-(sp);end of text
	mov	(sp),basbeg(r0)	;update basbeg
	sub	(r4)+,(sp)	;less beginning is length
	tstb	1(sp)		;see if line too long
	beq	tlenh1		;no
	movb	#377,(r4)	;set to max for as much visibility
	bis	#trnker,edflag	;indicate text pointer setup already
	tltrnk	!fatal		;fatal -- line so long cant keep complete text
tlenh1:	movb	(sp)+,(r4)+	;fill text length; point to type
tleven:	mov	spta,r5		;base for proptr
	mov	proptr(r5),r2	;current pushpop pointer
	asr	r2		;mask for low bit
	adc	proptr(r5)	;and if there bump free pointer
	rts	pc


;routine to compile code for a formula

tlcomf:	bis	#convff,stat(r0);force conversion of numbers to floating initially
tlcmf1:	bic	#outexf,stat(r0);tell lex anal we're in tlcomf 
	clr	tlpcou(r0)	;clear paren counter
	clr	tlfnaf(r0)	;clear fn. name and operator flags
	clrb	tloprf(r0)	;operand just previous token
	clr	pmode(r0)	;top level indicator
	mov	opsi,opsp	;init. operator stack ptr.
	mov	opsi,tloprp(r0)	;pick up absolute operator stack pointer
	sub	r0,tloprp(r0)	;compute rel. operator stack pointer from it
	mov	oasp,tloarp(r0)		;pick up abs. operand stack ptr.
	sub	r0,tloarp(r0)		;relativeize it
tlcoe:	ifz	ptokf(r0),tlcoe1,b	;if ptokf<>0 then ptoke=0
	clrb	ptoke(r0)		;zero it
	br	tlcoe2

tlcoe1:	clrb	toke(r0)	;otherwise toke=0
tlcoe2:	clr	cprec(r0)	;clear curr.prec. loc
	clr	prprec(r0)	;clear prev.prec.loc.
tlcoa:	jsr	pc,tlgtok	;get next token
	ifz	tlfnaf(r0),tlcon,b	;jmp if tlfnaf flag not set
	if	toka(r0),eq,#lpar,tlcon	;there also if token=(
	clr	tlfnat(r0)	;clear picture word location (corr. to fn. with 0 args)
	mov	pmode(r0),-(r1)	;save old pmode value
	jsr	pc,tlfipm	;go off to calculate pmode value
	mov	tltyct(r0),-(r1);put type of curr. token on r1 stack
	jsr	pc,tlrpf1	;fcn. w/o following (
	clrb	tlfnaf(r0)	;clear fn. name flag
	mov	(r1)+,pmode(r0)	;restore old pmode
tlcon:	jsr	pc,tlopp	;test token for operator
	br	tlcon2		;it isn't
	ifnz	tloptf(r0),tlcon3,b	;see if previous token was operator
	incb	tloptf(r0)	;it wasn't, but this one is
	br	tlcon1		;normal case
tlcon3:	if	toka(r0),eq,#4,tlcon1	;is current op. a unary -?
	if	toka(r0),eq,#11,tlcon1	;a "not" is also ok
tler10:	tlnzsp	!fatal		;two operators in succession is a nono

tlcon2:	clrb	tloptf(r0)	;clear operator flag, token not operator
tlcon1:	jsr	pc,tloap	;skip if token is an operand
	br	tlnopr		;no
	tstb	tloprf(r0)	;was prev tok an operand
	bne	tlcob		;yep, so quit
	comb	tloprf(r0)	;indicate operand
	jmp	tlcol		;yes

tlcoh1:	mov	toka(r0),r2	;pick up curr. token value in r2
	movb	tlpret(r2),r2	;look up it's precedence
	mov	r2,cprec(r0)	;and store it in cprec
tlcoi:	if	prprec(r0),ne,#11.,tlcoi1	;if prev not ^
	if	cprec(r0),eq,#10.,tlcod	;br if curr op = unary -
tlcoi1:	if	cprec(r0),gt,prprec(r0),tlcod	;curr.prec > prev. prec.,so defer action
	jsr	pc,tlgenc	;curr.prec.<=prev.prec., so make code
	mov	opsp,r2
	sub	r0,r2
	if	r2,eq,tloprp(r0),tlcod	;jmp if operators used up
	movb	@opsp,r2		;look up precedence of top element
	movb	tlpret(r2),r2		;and move it into r2
	mov	r2,prprec(r0)		;store it in pprec
	br	tlcoi

tlcobi:	clrb	tloprf(r0)		;not an operand
	jsr	pc,tlopp		;see if operator
	br	tlcobe			;not operator--see if (, etc.
	ifnz	pmode(r0),tlcoh1	;here if operator
	ifz	tllsfl(r0),tlcoh1,b	;we're doing a left side if tllsfl not=0
	tlopnv	!fatal			;not a verb--complain

tlcod:	mov	cprec(r0),prprec(r0)	;save current prec val as prev
	movb	toka(r0),-(r1)		;move current token val to stack
	jsr	pc,puopst		;push onto operator stack
	br	tlcoa			;go back for next token
tlcobe:	if	toka(r0),eq,#lpar,tlcof	;jmp if token = (
	if	toka(r0),eq,#comma,tlcoq;to tlcoq if token = ,
tlcob:	mov	oasp,r2			;pick up operand stack ptr in r2
	tst	(r2)+			;incr. r2 by 2
	if	r2,ne,oasi,tlcoz	;does operand stack have exactly one elem.?
	if	opsp,ne,opsi,tlcoz	;yes, now go generate code if operator
	jsr	pc,pooast		;stack not empty -else save result type and exit
	mov	(r1)+,tlcomr(r0)	;move result type from r1 stack into tlcomr
	bis	#outexf,stat(r0)	;tell lex anal we're out of tlcomf
	jmp	tlclcb			;close out block and exit through tlclcb

tlcoq:	ifz	ptoke(r0),tler10,b	;comma as first char of expr is bad
	if	pmode(r0),eq,#1,tler10	;comma inside expr is bad too
	bhi	tlcoj			;treat as arg delimiter
	br	tlcob			;otherwise,treat it as an expression terminator

tlcoz:	jsr	pc,tlgenc		;go off to generate code
	br	tlcob

tlnopr:	if	toka(r0),ne,#rpar,tlcobi;to tlcobi if token <> (<>)
	ifz	ptoke(r0),tlcoz2,b	;")" as 1st char of expression!
	ifz	tlpcou(r0),tlcob	;to tlcob if paren. count down to 0
	dec	tlpcou(r0)		;one less in parenthesis depth
tlcoz2:	if	ptoka(r0),ne,#lpar,tlcoz1;branch if prev. token not (
	if	pmode(r0),gt,#4,tlcok1	;() case is error except in fn call
tler11:	tlnzsp	!fatal			;illegal expre

tlcoz1:	ifz	ptoke(r0),tler11,b; ) as 1st of expression
	br	tlcow
tlgtst:	mov	oasp,r2		;subroutine to see if new items on operand stack
	sub	r0,r2		;relative operand sp
	cmp	tloarp(r0),r2	;anything added since last time we saved it
	blos	tler11		;no-error
	rts	pc		;ok to pop stuff off now

tlcof:	cmp	ptoka(r0),#rpar	;see if left paren follows right
	beq	tler11		;case of )(--always an error
	inc	tlpcou(r0)	;increase paren depth
	mov	pmode(r0),-(r1)	;( case, put pmode val. on r1 stack
	mov	#puoast,r3	;get set to move lots to operand stack
	jsr	pc,(r3)		;first pmode val
	mov	cprec(r0),-(r1)	;put prec val on r1 stack
	jsr	pc,(r3)		;and to operand stack
	mov	tloprp(r0),-(r1);put rel. operator stack ptr. on r1 stack
	jsr	pc,(r3)		;put it on operand stack
	mov	tloarp(r0),-(r1);put rel operand stack ptr on r1 stack
	jsr	pc,(r3)		;and to operand stack
	clr	-(r1)		;put 0 on r1 stack
	jsr	pc,(r3)		;put picture word on operand stack, init. to 0
	mov	#1,-(r1)	;put 1 on r1 stack
	jsr	pc,(r3)		;put no. args. on operand stack,init. to 1
	mov	opsp,tloprp(r0)	;pick up op. stack ptr. val.
	sub	r0,tloprp(r0)	;make it relative and save in tloprp
	mov	oasp,tloarp(r0)	;pick up operand satck ptr val
	sub	r0,tloarp(r0)	;make it rel & save it in tloarp
	jsr	pc,tlfipm	;calc. pmode val. for prev.token
				;and stores that value in pmode
	clrb	tlfnaf(r0)	;clear function flag
	jmp	tlcoe		;go back to clear prec. loc's and get next token

tlcop:	jsr	pc,tlgenc	;make some code
tlcoj:	mov	opsp,r2		;comma case
	sub	r0,r2		;make rel. operator stack ptr.
	if	r2,ne,tloprp(r0),tlcop	;have we used up all the operators?
	jsr	pc,pooast	;pop top element off operand stack
	jsr	pc,tlfixi	;call tlfixi
	inc	@oasp		;incr. arg. count by 1
	jmp	tlcoe		;go back to clear prec. val's, & read next token
tlcowa:	jsr	pc,tlgenc	;make some code
tlcow:	mov	opsp,r2		;pick up operator stack ptr. in r2
	sub	r0,r2		;make it relative to spda
	cmp	r2,tloprp(r0)	;see if operators used up
	bne	tlcowa		;go around again
	jsr	pc,pooast	;pop top elem. off operand stack
	mov	(r1),tlcttw(r0)	;store type of last calc. inside ()'s
	jsr	pc,tlfixi	;call tlfixi
tlcok1:	mov	#pooast,r3	;for cheap access
	jsr	pc,(r3)		;pop next elem. off operand stack
	mov	(r1)+,nargs(r0)	;and store in nargs (# of args)
	jsr	pc,(r3)		;pop next elem. off operand stack
	mov	(r1)+,tlfnat(r0);and store in tlfnat (picture wd.)
	jsr	pc,(r3)		;pop next elem. off operand stack
	mov	(r1)+,tloarp(r0);and store in tloarp (operand stack rel. ptr)
	jsr	pc,(r3)		;pop next elem. off operand stack
	mov	(r1)+,tloprp(r0);and store in tloprp (rel. stack ptr. limit)
	jsr	pc,(r3)		;pop next elem. off operand stack
	mov	(r1)+,prprec(r0);and store in prprec (prev. prec. val.)
	jsr	pc,(r3)		;pop next elem. off operand stack
	mov	(r1)+,prpmod(r0);and store in prpmod (temp. storage for pmode val.)
	mov	pmode(r0),r2	;pick up pmode value in r2
	if	r2,le,#4,tlcoy	;to tlcoy if not a fcn. call.
	inc	tlbiff(r0)	;set built-in fcn. flag
	sub	#5,r2		;subtr 5 from it
	if	r2,le,#2,tlcov	;to tlcov if a built-in fcn.
	clr	tlbiff(r0)	;clear built-in fcn flag
	sub	#3,r2		;and reduce val. in r2 by 3
tlcov:	mov	r2,tltyct(r0)	;store fcn. type in tltyct
tlcox:	jsr	pc,tlrpfx	;call tlrpfx
	mov	prpmod(r0),pmode(r0) ;move saved pmode val. into pmode, finally
	br	tlcoaa		;back for next token

tlcoy:	dec	r2		;if pmode =1 then ordinary () case
	beq	tlcox		;was a 1, so do it
	dec	r2		;data type = pmode-2
	mov	r2,tltyct(r0)	;save data type of indexed variable
	br	tlcox		;call tlprfx and try again

tlcol:	jsr	pc,tltype	;calc data type of curr. token
	tbitt	funcf,tlcor	;branch if not function
	incb	tlfnaf(r0)	;yes, set fcn. name flag
	clr	tlbiff(r0)	;clear built-in fcn. flag
	tbitt	basf,tlcom	;built in function or user defined?
	inc	tlbiff(r0)	;built in---set flag
tlcom:	mov	toka(r0),-(r1)	;move curr. token to r1 stack
	jsr	pc,puoast	;and push it onto the operand stack.
	br	tlcoaa		;go back to read a new token
tlcor:	clrb	tlfnaf(r0)	;clear the fn. name flag
	bitb	#indexf,toke(r0);see if indexed variable or simple one
	bne	tlcom		;indexed..
	mov	#push,tlgcop(r0);put "push" into the operator slot
	jsr	pc,satype	;store its data type on r1 stack
	mov	#3,-(r1)	;put 3 on r1 stack to notify typr of unary operator
	jsr	pc,tladdc	;generate code to push operand onto run-time stack.
tlcoaa:	jmp	tlcoa		;go back to read new token


;code generating routine
tlgenc:	jsr	pc,poopst	;pop top elem. off operator stack
	movb	(r1)+,tlgcop(r0) ;and put it in tlgcop
	clrb	tlgcop+1(r0)	;clear high byte of tlgcop
	jsr	pc,tlgtst	;test for exist of operand on stack
	jsr	pc,pooast	;pop top elem. off operand stack
	if	tlgcop(r0),ne,#4,tlgen2		;to tlgen2 if op. not unary -
tlgen4:	mov	#3,-(r1)	;unary op. case, notify typr by 3 as 2nd arg.
	br	tladdc		;call tladdc to gen. code & exit

tlgen2:	if	tlgcop(r0),eq,#11,tlgen4	;to tlgen4 if op. not "not"
	jsr	pc,tlgtst	;test for exist if operand on stack
	jsr	pc,pooast	;not unary, so pop 2nd item off operand stack
tladdc:	mov	2(r1),-(r1)	;copy next-to-top elem. of r1 stack (operand)
	mov	2(r1),-(r1)	;copy top elem. of r1 stack (operand)
	jsr	pc,typr		;calc. the type of the result
	mov	(r1),r2		;use this type to choose
	add	r2,r2		;which table to use
	mov	tlotix(r2),r3	;bring base. addr. of approp. table into r2
	add	tlgcop(r0),r3	;index by operator token value
	tstb	(r3)		;check pop
	beq	tler14		;0 is error, no corresp. pushpop code
	if	tlgcop(r0),eq,#push,addd ;treat push as special case
	if	4(r1),eq,(r1),addb ;is 1st operand of same type as result?
	movb	#ppflt,-(r1)	;no, float it (put "float" code on r1 stack)
	br	adde
addb:	mov	r1,r4		;make destuctable r1 pointer
	cmp	(r4)+,(r4)	;do they aggree?
	beq	addd		;same type---
	cmp	(r4),#3		;see if unary op with no 2nd operand
	beq	addd		;yes--no conversion porblems then
	movb	#ppflt1,-(r1)	;otherwise float it (put "float1" code on r1 stack
adde:	jsr	pc,pucost	;put "float" or "float1" on code stack
addd:	movb	(r3),-(r1)	;put pushpop opcode from table on r1 stack, then
	jsr	pc,pucost	;put opcode on code stack
	if	tlgcop(r0),lt,#6,addh	;for the logical op's. in condit.
	if	tlgcop(r0),eq,#23,addh	;make sure result type is integ.
	mov	#1,(r1)		;by putting 1 (i.e. integer) on r1 stack as type
addh:	jsr	pc,puoast	;put residue on operand stack
	cmp	(r1)+,(r1)+	;r1_r1+4 to clean up stack
	if	tlgcop(r0),ne,#push,addg	;done unless "push" case
	mov	toka(r0),-(r1)	;stack token on r1 stack
	jsr	pc,tlstcw	;push fullwd to code stack
addg:	rts	pc

tler14:	tlnoit	!fatal		;no opcode in table corr. to that operator and type
;routine to do miscell.fixups upon hitting )
tlrpfx:	if	pmode(r0),ne,#1,rpfa ;br if pmode value isn't = 1
	mov	tlcttw(r0),-(r1)	;ordinary parenth. expr. case
	br	rpf8

rpfa:	mov	tltyct(r0),-(r1)	;put type on r1 stack
	if	pmode(r0),gt,#4,tlrpf1	;test whether pmode val. <=4
	mov	nargs(r0),r3	;number of dimensions or args
	if	r3,gt,#2,tler12	;indexed var. case
	dec	r3		;now 0 if 1d, 1 if 2d
	movb	rpidtb(r3),-(r1);pick up right indo
	jsr	pc,pucost	;move byte to code stack
	jsr	pc,pooast	;bring dope vect. rel. ptr. to r1 stack
	mov	(r1),-(r1)	;compile a copy
	jsr	pc,tlstcw	;of it
	mov	(r1)+,r2	;make pointers with it
	add	r0,r2		;now absolute
	mov	r2,r4		;save a copy
	add	#pdim2,r4	;pointer to pdim2 