/*
 * Header for tube driver.
 */

/* WCC bits */
#define ALARM   04
#define RESTORE 02
#define RSTMDT  01

/* Buffer Control Codes (Orders) */
#define SF     0x1d     /* start field */
#define SBA    0x11     /* set buffer address */
#define IC     0x13     /* insert cursor */
#define PT     0x05     /* program tab */
#define RA     0x3c     /* repeat to address */
#define EUA    0x12     /* erase unprotected to address */
#define DUP    0x1c     /* duplicate */
#define FM     0x1e     /* field mark */

/* Attribute character bits */
#define PROT    0x20    /* protected */
#define AN      0x10    /* alphanumeric / skip */
#define MDT     0x01    /* set mdt */
#define INTENS  0x08    /* high intensity */
#define DETECT  0x04    /* selector pen detectable */
#define NODISP  0x0C    /* not displayable */

/* AIDs */
#define NOACTION 0x60    /* no action */
#define ENTER   0x7d     /* enter */
#define PF1     0xf1     /* pf1 */
#define PF2     0xf2     /* pf2 */
#define PF3     0xf3     /* pf3 */
#define PF4     0xf4     /* pf4 */
#define PF5     0xf5     /* pf5 */
#define PF6     0xf6     /* pf6 */
#define PF7     0xf7     /* pf7 */
#define PF8     0xf8     /* pf8 */
#define PF9     0xf9     /* pf9 */
#define PF10    0x7a     /* pf10 */
#define PF11    0x7b     /* pf11 */
#define PF12    0x7c     /* pf12 */
#define IMMED   0x7e     /* ? */
#define TESTREQ 0x01     /* test request (SOH) */
#define RDR     0xe6     /* reader */
#define CLEAR   0x6d     /* clear */
#define PA1     0x6c     /* PA1 */
#define PA2     0x6e     /* PA2 */
#define PA3     0x6b     /* PA3 */

/* Channel Command Codes */
#define WRITE   1       /* normal write */
#define READ    2       /* read buffer */
#define SENSE   4       /* sense */
#define EWRITE  5       /* erase/write */
#define READMOD 6       /* read modified */
#define SELECT  11      /* select */
#define WEUA    15      /* erase all unprotected */

/* sense bits */
#define COMREJ  0x80    /* command reject */
#define INTREQ  0x40    /* intervention required */
#define BUSOCHK 0x20    /* bus out check */
#define EQCHK   0x10    /* equiptment check */
#define DATACHK 0x08    /* data check */
#define UNITSPC 0x04    /* unit specify */
#define CONCHK  0x02    /* control check */
#define OPCHK   0x01    /* operation check */

/* Special characters */
#define BELL    007
#define BS      010
#define TAB     011
#define LF      012
#define FF      014
#define CR      015

#define MAXPOS  (22*80-2)       /* last output position of screen */
#define MSGPOS  (24*80-15)      /* where moremsg appears */

#define BUFLEN  2130    /* buffer length */
#define FUDGE   50      /* slop in filling buffer */
#define NPFK    12      /* number of PF keys */
#define PFLEN   80      /* length allowed for PF string */
#define ILEN    150     /* maximun length of input string */
#define NRE     5       /* number of redisplay lines saved */

/*
 * The tube structure must fit in one page.
 * The current size is:
 *
 *  Number               Type      Bytes per                Value   For
 *  2                    ccw_t         8            2 * 8 =   16   ccws
 *  33                   caddr_t       4           33 * 4 =  132   idaws
 *  3                    int           4            3 * 4 =   12   misc ints
 *  7                    short         2            7 * 2 =   14   misc shorts
 *  NRE * ILEN           char          1          5 * 150 =  750   redisplay
 *  (NPFK + 1) * PFLEN   char          1    (12 + 1) * 80 = 1040   pf keys
 *  BUFLEN               char          1                    2130   i/o buf.
 *  2                    char          1                       2   misc chars
 *                                                          ----
 *                                                          4096
 */

struct tube {          /* must fit in one page */
	ccw_t   t_ccws[2];      /* ccws */
	caddr_t t_idaws[33];    /* indirect address words for full screen i/o */
	int     t_curpos;       /* logical position */
	int     t_resid;        /* residual read count */
	struct proc *t_pkproc;  /* process to poke */
	short   t_pksig;        /* signal # for poking */
	short   t_errct;        /* error count for unit checks */
	short   t_re_back;      /* pf key for redisplay of last input */
	short   t_re_forw;      /* pf key for redisplay of last input */
	short   t_re_idx;       /* t_re_buf index */
	short   t_re_off;       /* offset for repeated redisplay */
	short   t_bits;         /* indicators */
	char    t_re_buf[NRE][ILEN];  /* buffer for saving last input */
	char    t_pfk[NPFK+1][PFLEN]; /* pfk strings */
	char    t_dbuf[BUFLEN]; /* device buffer */
	char    t_rcmd;         /* fs read ccw */
	char    t_wcmd;         /* fs write ccw */
};

/* Bits in t_bits */
#define T_ATTN     0x0001       /* unserviced attention */
#define T_SKLF     0x0002       /* skip next lf */
#define T_NOAT     0x0004       /* don't wait for attn on fs read */
#define T_FS       0x0008       /* full screen mode */
#define T_NCLS     0x0010       /* normal close done before fs close */
#define T_RIP      0x0040       /* normal read in progress */
#define T_MOREMSG  0x0080       /* moremsg is on screen */
#define T_PEND     0x0100       /* i/o pending */
#define T_ASLEEP   0x0200       /* sleeping on t_state for ~BUSY */
#define T_FSNORM   0x0400       /* normal mode interruption in full screen mode */
