/*
 * Table of 3270 control characters:
 * the lower six bits are the same as the index
 * into the table; the top 2 bits are chosen
 * to give the character a graphic representation
 * in EBCDIC. The manual says to use these, though
 * it appears not to be necessary.
 * See GA27-2749-7 p. 2-11
 */
char tubecc[64] = {
        0x40, 0xC1, 0xC2, 0xC3, 0xC4, 0xC5, 0xC6, 0xC7, 
        0xC8, 0xC9, 0x4A, 0x4B, 0x4C, 0x4D, 0x4E, 0x4F, 
        0x50, 0xD1, 0xD2, 0xD3, 0xD4, 0xD5, 0xD6, 0xD7, 
        0xD8, 0xD9, 0x5A, 0x5B, 0x5C, 0x5D, 0x5E, 0x5F, 
        0x60, 0x61, 0xE2, 0xE3, 0xE4, 0xE5, 0xE6, 0xE7, 
        0xE8, 0xE9, 0x6A, 0x6B, 0x6C, 0x6D, 0x6E, 0x6F, 
        0xF0, 0xF1, 0xF2, 0xF3, 0xF4, 0xF5, 0xF6, 0xF7, 
        0xF8, 0xF9, 0x7A, 0x7B, 0x7C, 0x7D, 0x7E, 0x7F, 
};

/*
 * Table to translate ASCII to 3270 (EBCDIC) code.
 * Memorex special characters are included
 */
char tubotab[256] = {
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  /* 000 */
        0x00, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  /* 010 */
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  /* 020 */
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  /* 030 */
        0x40, 0x5A, 0x7F, 0x7B, 0x5B, 0x6C, 0x50, 0x7D,  /* 040 */
        0x4D, 0x5D, 0x5C, 0x4E, 0x6B, 0x60, 0x4B, 0x61,  /* 050 */
        0xF0, 0xF1, 0xF2, 0xF3, 0xF4, 0xF5, 0xF6, 0xF7,  /* 060 */
        0xF8, 0xF9, 0x7A, 0x5E, 0x4C, 0x7E, 0x6E, 0x6F,  /* 070 */
        0x7C, 0xC1, 0xC2, 0xC3, 0xC4, 0xC5, 0xC6, 0xC7,  /* 000 */
        0xC8, 0xC9, 0xD1, 0xD2, 0xD3, 0xD4, 0xD5, 0xD6,  /* 110 */
        0xD7, 0xD8, 0xD9, 0xE2, 0xE3, 0xE4, 0xE5, 0xE6,  /* 120 */
        0xE7, 0xE8, 0xE9, 0x9B, 0x9C, 0x9D, 0xBF, 0x6D,  /* 130 */
        0x8C, 0x81, 0x82, 0x83, 0x84, 0x85, 0x86, 0x87,  /* 140 */
        0x88, 0x89, 0x91, 0x92, 0x93, 0x94, 0x95, 0x96,  /* 150 */
        0x97, 0x98, 0x99, 0xA2, 0xA3, 0xA4, 0xA5, 0xA6,  /* 160 */
        0xA7, 0xA8, 0xA9, 0x8B, 0x4F, 0x8D, 0xBE, 0x00,  /* 170 */
	/* The rest of these are funny characters */
        0x00, 0xAE, 0xBD, 0x00, 0x00, 0x00, 0x00, 0x00,  /* 200 */
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  /* 210 */
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  /* 220 */
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  /* 230 */
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  /* 240 */
        0x00, 0x00, 0x00, 0xAC, 0x00, 0xAD, 0x00, 0x00,  /* 250 */
        0xB0, 0xB1, 0xB2, 0xB3, 0xB4, 0xB5, 0xB6, 0xB7,  /* 260 */
        0xB8, 0xB9, 0x00, 0x00, 0xAA, 0xA0, 0xAB, 0x00,  /* 270 */
        0x00, 0x00, 0x00, 0xBC, 0x00, 0x00, 0x00, 0x00,  /* 300 */
        0x00, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  /* 310 */
        0x00, 0x00, 0xBB, 0xA1, 0xBA, 0x00, 0x00, 0x00,  /* 320 */
        0xAF, 0x00, 0x00, 0x00, 0x4A, 0x00, 0x00, 0x00,  /* 330 */
        0x00, 0x00, 0x00, 0x00, 0x8F, 0x00, 0x00, 0x00,  /* 340 */
        0x00, 0x00, 0x00, 0x00, 0x9F, 0x8A, 0x00, 0x00,  /* 350 */
        0x9A, 0x00, 0x9E, 0x00, 0x00, 0x8E, 0x00, 0x00,  /* 360 */
        0x00, 0x00, 0x00, 0x00, 0x6A, 0x00, 0x5F, 0x00,  /* 370 */
};

/*
 * Translation from 3270 to ASCII
 * Exact inverse of tubotab
 */
char tubitab[] = {
        0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, /* 00 */
        0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, /* 08 */
        0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, /* 10 */
        0000, 0000, 0000, 0000, 0000, 0000, 0011, 0000, /* 18 */
        0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, /* 20 */
        0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, /* 28 */
        0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, /* 30 */
        0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, /* 38 */
        0040, 0000, 0000, 0000, 0000, 0000, 0000, 0000, /* 40 */
        0000, 0000, 0334, 0056, 0074, 0050, 0053, 0174, /* 48 */
        0046, 0000, 0000, 0000, 0000, 0000, 0000, 0000, /* 50 */
        0000, 0000, 0041, 0044, 0052, 0051, 0073, 0376, /* 58 */
        0055, 0057, 0000, 0000, 0000, 0000, 0000, 0000, /* 60 */
        0000, 0000, 0374, 0054, 0045, 0137, 0076, 0077, /* 68 */
        0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, /* 70 */
        0000, 0000, 0072, 0043, 0100, 0047, 0075, 0042, /* 78 */
        0000, 0141, 0142, 0143, 0144, 0145, 0146, 0147, /* 80 */
        0150, 0151, 0355, 0173, 0140, 0175, 0365, 0344, /* 88 */
        0311, 0152, 0153, 0154, 0155, 0156, 0157, 0160, /* 90 */
        0161, 0162, 0360, 0133, 0134, 0135, 0362, 0354, /* 98 */
        0275, 0323, 0163, 0164, 0165, 0166, 0167, 0170, /* A0 */
        0171, 0172, 0274, 0276, 0253, 0255, 0201, 0330, /* A8 */
        0260, 0261, 0262, 0263, 0264, 0265, 0266, 0267, /* B0 */
        0270, 0271, 0324, 0322, 0303, 0202, 0176, 0136, /* B8 */
        0000, 0101, 0102, 0103, 0104, 0105, 0106, 0107, /* C0 */
        0110, 0111, 0000, 0000, 0000, 0000, 0000, 0000, /* C8 */
        0000, 0112, 0113, 0114, 0115, 0116, 0117, 0120, /* D0 */
        0121, 0122, 0000, 0000, 0000, 0000, 0000, 0000, /* D8 */
        0000, 0000, 0123, 0124, 0125, 0126, 0127, 0130, /* E0 */
        0131, 0132, 0000, 0000, 0000, 0000, 0000, 0000, /* E8 */
        0060, 0061, 0062, 0063, 0064, 0065, 0066, 0067, /* F0 */
        0070, 0071, 0000, 0000, 0000, 0000, 0000, 0000, /* F8 */
};
