/
/ Function:
/   STRNCPY copies s2 into s1, and returns --> s1.
/    Exactly n characters are copied; s1 is null-padded
/    if s2 is less than n characters.
/
/ Calling Sequence:
/   strncpy(s1, s2, n) char *s1, *s2; int n;
/
	entry   strncpy
	using   strncpy,15
strncpy:
	lr	r0,sp
	s	sp,=f'64'
	stm	0,15,0(sp)
	st	0,52(,sp)
	lr	r12,sp

	l       r0,68(,sp)          / Get s2 address
	lr      r3,r0
	l       r4,=v(_strtabl)     / Get trt table address
	sr      r1,r1               / trt doesn't clear high byte
	l       r5,72(,sp)          / get n
0:
	c       r5,=f'256'          / at least 256 chars ?
	bl      1f                  / no...almost done
	trt     0(256,r3),0(r4)     / Scan for null
	bnz     2f                  / CC=0?  No null found
	la      r3,256(r3)          / Increment address
	s       r5,=f'256'          / reduce char count
	b       0b                  / Continue scan
1:
	ltr     r5,r5               / any chars left ?
	bz      2b                  / no...got length now
	bm      3f                  / negative length ... get out
	s       r5,=f'1'            / decrement for ex
	ex      r5,extrt            / one last look for null
2:
	sr      r1,r0               / Else calc length
	n       r1,=x'00ffffff'     / clear high byte
	l       r2,64(,sp)          / s1
	l       r3,72(,sp)          / n
	mvcl    r2,r0               / move and null-pad
3:
	l       r0,64(,sp)
	lm      r1,r15,4(r12)       / and return
	br      r14
extrt:  trt     0(,r3),0(r4)
