#include <stdio.h>
#include <stdioerr.h>
#include <signal.h>

#define	tst(a,b)	(*mode == 'r'? (b) : (a))
#define	RDR	0
#define	WTR	1
static	int	popen_pid[20];

FILE *
popen(cmd,mode)
char	*cmd;
char	*mode;
{
	int p[2];
	register myside, hisside, pid;
	extern int errno;

	if (pipe(p) < 0)
		return(_stdioerr(errno, "popen"));
	myside = tst(p[WTR], p[RDR]);
	hisside = tst(p[RDR], p[WTR]);
	if((pid = fork()) == 0) {
		/* myside and hisside reverse roles in child */
		close(myside);
		movefd(hisside, tst(0, 1));
		execl("/bin/sh", "sh", "-c", cmd, 0);
		_exit(_stdioerr(errno, "popen"));
	}
	if (pid == -1)
		return(_stdioerr(errno, "popen"));
	popen_pid[myside] = pid;
	close(hisside);
	return(fdopen(myside, mode));
}

pclose(ptr)
FILE *ptr;
{
	register int f, r, (*hstat)(), (*istat)(), (*qstat)();
	int status;
	extern int errno;

	if (ptr == NULL)
		return(_stdioerr(EFPNULL, "pclose"));
	f = fileno(ptr);
	fclose(ptr);
	istat = signal(SIGINT, SIG_IGN);
	qstat = signal(SIGQUIT, SIG_IGN);
	hstat = signal(SIGHUP, SIG_IGN);
	while((r = wait(&status)) != popen_pid[f] && r != -1)
		;
	if (r == -1)
		status = -1;
	signal(SIGINT, istat);
	signal(SIGQUIT, qstat);
	signal(SIGHUP, hstat);
	if (status == -1)
		return(_stdioerr(errno, "pclose"));
	return(status);
}
