/*
 * Standard I/O library error messages and default actions
 */

#include <stdioerr.h>

_ERRINFO _errinfo[] ={
/* 0       */   0,      "C library: error 0 unused",
/* EPERM   */   0,      "must be owner or super-user to access \"%s\"",
/* ENOENT  */   0,      "file \"%s\" does not exist",
/* ESRCH   */   0,      "process %d does not exist or is dead",
/* EINTR   */   -1,     "interrupted by signal",
/* EIO     */   -1,     "I/O error while %s \"%s\"",
/* ENXIO   */   0,      "no such device called \"%s\"",
/* E2BIG   */   0,      "argument list too long to exec",
/* ENOEXEC */   0,      "exec format error on \"%s\"",
/* EBADF   */   -1,     "bad file number",
/* ECHILD  */   0,      "wait for non-existent child",
/* EAGAIN  */   0,      "no more processes",
/* ENOMEM  */   0,      "no more memory",
/* EACCES  */   0,      "access denied to file \"%s\"",
/* EFAULT  */   0,      "bad address to system call",
/* ENOTBLK */   0,      "block device required",
/* EBUSY   */   0,      "mount device busy",
/* EEXIST  */   0,      "file \"%s\" already exists",
/* EXDEV   */   0,      "cross device link",
/* ENODEV  */   -1,     "inappropriate call for device %s",
/* ENOTDIR */   0,      "non-directory in path \"%s\"",
/* EISDIR  */   -1,     "attempted to write on directory \"%s\"",
/* EINVAL  */   -1,     "invalid argument",
/* ENFILE  */   0,      "can't open \"%s\", system file table overflow",
/* EMFILE  */   0,      "can't open \"%s\", too many files open",
/* ENOTTY  */   -1,     "\"%s\" is not a tty",
/* ETXTBSY */   0,      "pure text file \"%s\" busy",
/* EFBIG   */   -1,     "file \"%s\" is too large",
/* ENOSPC  */   -1,     "ran out of space while writing to \"%s\"",
/* ESPIPE  */   -1,     "illegal seek on \"%s\"",
/* EROFS   */   -1,     "file system for \"%s\" is read-only",
/* EMLINK  */   0,      "file \"%s\" has too many links",
/* EPIPE   */   -1,     "attempt to write to broken pipe",
/* EDOM    */   0,      "math package argument outside of domain",
/* ERANGE  */   0,      "math package argument outside of range",

/* ESCANPTR */  0,      "NULL address for %%%c in formatted scan from \"%s\"",
/* ESCANF   */  0,      "%%%c format failed in formatted scan from \"%s\"",
/* EMODE    */  0,      "bad mode for opening file \"%s\"",
/* EFPNULL  */  -1,     "NULL file pointer",
/* EPASTEOF */  -1,     "tried to read past EOF on \"%s\"",
/* EPRTNULL */  0,      "tried to print NULL as string to file \"%s\"",
/* EBADUSE  */  -1,     "file \"%s\" is not open for %s",
/* EPWENT   */  1,      "can't find entry in password file for uid %d",
/* EPWBAD   */  1,      "bad password file format",
/* ENOTMEM  */  0,      "\"%s\" is not a memory file",
/* EUNEOF   */  -1,     "tried to unget EOF on \"%s\"",
/* EUNGET   */  -1,     "can't unget '%c' to file \"%s\"",
/* ESETBUF  */  0,      "tried to setbuf memory file \"%s\"",
/* EWRTCNT  */  -1,     "short count on write to file \"%s\"",
	};

_INTFUNC _erract[] ={
/* 0       */   ECATCH,
/* EPERM   */   ECATCH,
/* ENOENT  */   EIGNORE,        /* for backward compatibility only */
/* ESRCH   */   ECATCH,
/* EINTR   */   ECATCH,
/* EIO     */   ECATCH,
/* ENXIO   */   ECATCH,
/* E2BIG   */   ECATCH,
/* ENOEXEC */   ECATCH,
/* EBADF   */   ECATCH,
/* ECHILD  */   EIGNORE,
/* EAGAIN  */   ECATCH,
/* ENOMEM  */   ECATCH,
/* EACCES  */   ECATCH,
/* EFAULT  */   ECATCH,
/* ENOTBLK */   ECATCH,
/* EBUSY   */   ECATCH,
/* EEXIST  */   ECATCH,
/* EXDEV   */   ECATCH,
/* ENODEV  */   ECATCH,
/* ENOTDIR */   ECATCH,
/* EISDIR  */   ECATCH,
/* EINVAL  */   ECATCH,
/* ENFILE  */   ECATCH,
/* EMFILE  */   ECATCH,
/* ENOTTY  */   ECATCH,
/* ETXTBSY */   ECATCH,
/* EFBIG   */   ECATCH,
/* ENOSPC  */   ECATCH,
/* ESPIPE  */   ECATCH,
/* EROFS   */   ECATCH,
/* EMLINK  */   ECATCH,
/* EPIPE   */   EIGNORE,
/* EDOM    */   ECATCH,
/* ERANGE  */   ECATCH,

/* ESCANPTR */  ECATCH,
/* ESCANF   */  EIGNORE,
/* EMODE    */  ECATCH,
/* EFPNULL  */  ECATCH,
/* EPASTEOF */  EIGNORE,
/* EPRTNULL */  ECATCH,
/* EBADUSE  */  ECATCH,
/* EPWENT   */  EIGNORE,
/* EPWBAD   */  EIGNORE,
/* ENOTMEM  */  ECATCH,
/* EUNEOF   */  EIGNORE,
/* EUNGET   */  ECATCH,
/* ESETBUF  */  ECATCH,
/* EWRTCNT  */  ECATCH,
	};
