/*
 * C long arithmetic routines
 */

#define VERYNEG 0x80000000
#define VNEGDOUB 0xD0800000
#define KINDABIG 0x01000000
#define EXP16 0x4E

/*
 * long divide and mod
 *	a simplistic approach
 */

struct longint { int high, low; };

long _lldiv(a, b)
long a, b;{

	long r;
	register int s, sign, neg, overflow;
	unsigned long c,d;

	overflow = 0;
	if (b.low == 0) return( (long) (a.high/b.high) );
	if (a.high == 0 && b.high == 0 && b.low >= 0)
		return( (long) (ldiv(0, a.low, b.low)) );
	if (a.high == -1 && a.low < 0 && b.high == -1 && b.low < 0)
		return( (long) (a.low/b.low) );
	if (a.high == 0 && b.high == -1 && b.low < 0)
		return ( (long) (ldiv(0, a.low, b.low)) );
	if (a.high == -1 && a.low < 0 && b.high == 0 && b.low >= 0)
		return( (long) (a.low/b.low) );
	sign = 1;
	neg = 0;
	if (a == b) return(1);
	if (a.high == VERYNEG && a.low == 0) {
		neg = 1;
		if ((a += b) > 0) sign = -1;
		}
	if (a < 0) {
		a = -a;
		sign = -sign;
		}
	if (b < 0) {
		b = -b;
		sign = -sign;
		}
	if (a < b) return( (long) neg);

	c=a;
	d=b;
	/*
	 * Shift 'd' left until it is greater than 'c'. Must use unsigned
	 * longs so that a 1 bit shifted into sign position does not
	 * make 'd' a negative number.
	 */
	for (s = 0; c >= d && d!=0; s++)
		d <<= 1;

	if (d == 0)
	        /*
		 * Simulate a 65 bit integer.  The sole 1 bit of 'd' was
		 * shifted into this 65th bit position. The remainder of
		 * 'd' is all zeroes.
		 */
		overflow = 1;

	for (r = 0; s > 0; s--) {
		if (overflow) {
			/*
		         * Simulate a right shift of 1 on a 65 bit
		         * integer whose 65th bit is a 1 and all other
			 * bits are zeroes. Result is a positive unsigned
			 * long integer with 1 in the 64th bit position
			 * and zeroes in the remaining bit positions.
			 */
			d = 0x8000000000000000;
			overflow = 0;
		}
		else
		        d >>= 1;
		r <<= 1;
		if (c >= d) {
			r |= 1;
			c -= d;
			}
		}
	if (neg) r++;
	if (sign < 0) return(-r);
	else return(r);
	}

long _llrem(a, b)
long a, b;{

	register int s, sign;
	unsigned long c,d;
	int overflow;

	overflow = 0;
	if (a == b || b == 0 || b == 1) return(0);
	if (a.high == VERYNEG && a.low == 0)
		a += b;
	if (a < 0) {
		a = -a;
		sign = -1;
		}
	if (b < 0) {
		b = -b;
		sign = -1;
		}
	c=a;
	d=b;
	/*
	 * Shift 'd' left until it is greater than 'c'. Must use unsigned
	 * longs so that a 1 bit shifted into sign position does not
	 * make 'd' a negative number.
	 */
	for (s = 0; c >= d && d!=0; s++)
		d <<= 1;
	if (d == 0)
	        /*
		 * Simulate a 65 bit integer.  The sole 1 bit of 'd' was
		 * shifted into this 65th bit position. The remainder of
		 * 'd' is all zeroes.
		 */
		overflow = 1;
	for (; s > 0; s--) {
		if (overflow) {
			/*
		         * Simulate a right shift of 1 on a 65 bit
		         * integer whose 65th bit is a 1 and all other
			 * bits are zeroes. Result is a positive unsigned
			 * long integer with 1 in the 64th bit position
			 * and zeroes in the remaining bit positions.
			 */
			d = 0x8000000000000000;
			overflow = 0;
		}
		else
		        d >>= 1;
		if (c >= d) c -= d;
		}
	if (sign == -1) return(-c);
	else return(c);
	}

unsigned long _ulldiv(a, b)
unsigned long a, b;{

	unsigned long r;
	register int s, overflow;

	overflow = 0;

	/*
	 * Shift 'b' left until it is greater than 'a'. Must use unsigned
	 * longs so that a 1 bit shifted into sign position does not
	 * make 'b' a negative number.
	 */
	for (s = 0; a >= b && b!=0; s++)
		b <<= 1;

	if (b == 0)
	        /*
		 * Simulate a 65 bit integer.  The sole 1 bit of 'b' was
		 * shifted into this 65th bit position. The remainder of
		 * 'b' is all zeroes.
		 */
		overflow = 1;

	for (r = 0; s > 0; s--) {
		if (overflow) {
			/*
		         * Simulate a right shift of 1 on a 65 bit
		         * integer whose 65th bit is a 1 and all other
			 * bits are zeroes. Result is a positive unsigned
			 * long integer with 1 in the 64th bit position
			 * and zeroes in the remaining bit positions.
			 */
			b = 0x8000000000000000;
			overflow = 0;
		}
		else
		        b >>= 1;
		r <<= 1;
		if (a >= b) {
			r |= 1;
			a -= b;
			}
		}
	return(r);
	}

unsigned long _ullrem(a, b)
unsigned long a, b;{

	register int s;
	int overflow;

	overflow = 0;
	if (a == b || b == 0 || b == 1) return(0);

	/*
	 * Shift 'b' left until it is greater than 'a'. Must use unsigned
	 * longs so that a 1 bit shifted into sign position does not
	 * make 'b' a negative number.
	 */
	for (s = 0; a >= b && b!=0; s++)
		b <<= 1;
	if (b == 0)
	        /*
		 * Simulate a 65 bit integer.  The sole 1 bit of 'b' was
		 * shifted into this 65th bit position. The remainder of
		 * 'b' is all zeroes.
		 */
		overflow = 1;
	for (; s > 0; s--) {
		if (overflow) {
			/*
		         * Simulate a right shift of 1 on a 65 bit
		         * integer whose 65th bit is a 1 and all other
			 * bits are zeroes. Result is a positive unsigned
			 * long integer with 1 in the 64th bit position
			 * and zeroes in the remaining bit positions.
			 */
			b = 0x8000000000000000;
			overflow = 0;
		}
		else
		        b >>= 1;
		if (a >= b) a -= b;
		}
	return(a);
	}

/*
 * ftol - floating point -> long
 */

long _ftol(x)
double x;{

	int exp;
	double y;
	long r;

	if (x < 0) y = -x;
	else y = x;
	r.low = y.low;
	r.high = y.high;
	exp = ((r.high >> 24)-0x4e) << 2;
	r.high &= 0x00ffffff;
	if (exp > 0) r <<= exp;
	else r >>= -exp;
	if (x < 0) return(-r);
	else return(r);
	}

/*
 * ltof - long -> floating point
 */

double _ltof(a)
long a;{

	double x, y;
	register struct longint *ap;
	register int sign, exp;

	ap = &a;
	sign = 1;
	exp = 0;
	if (ap->high == VERYNEG && ap->low == 0) {
		x.high = VNEGDOUB;
		x.low = 0;
		return(x);
		}
	else if (ap->high < 0) {
		sign = -1;
		a = -a;
		}
	while (ap->high >= KINDABIG) {
		a >>= 4;
		exp++;
		}
	exp = (exp+EXP16) << 24;
	x.high = ap->high | exp;
	x.low = ap->low;
	y.high = exp;
	y.low = 0;
	x -= y;
	if (sign < 0) x = -x;
	return(x);
	}
