/*
 * tunable variables
 */

#define NUSER   4
#define NBUF    20              /* size of buffer cache */
#define NINODE  (20*NUSER)      /* number of in core inodes */
#define NFILE   (20*NUSER)      /* number of in core file structures */
#define NMOUNT  5               /* number of mountable file systems */
#define NDASD   2               /* number of DASD devices */
#define NFLOP   2               /* number of floppy devices */
#define NCALL   12              /* number of callout structures */
#define NEXEC   NUSER           /* number of simultaneous exec's */
#define MAXMEM  256           /* max core per process in units of pages */
#define SSIZE   1               /* initial stack size in pages */
#define NOFILE  15              /* max open files per process */
#define CANBSIZ 256             /* max size of typewriter line */
#define NSIG    32              /* number of signal types */
#define NPROC   30              /* max number of processes */
#define NTEXT   30              /* max number of pure texts */
#define NCLIST	(8*NUSER)	/* max total clist size */
#define NINFO   60              /* number of chars per cblock */
#define INFSIZ  32              /* user info size */
#define NAMESIZE 32             /* process name size */

/*
 * priorities
 * probably should not be
 * altered too much
 */

#define PINOD	-90
#define PRIBIO	-50
#define PRIRIO  -45
#define PPPF    -30
#define PPAGE   -1
#define PPIPE	1
#define PWAIT	40
#define PSLEP	90
#define URPRI   100
#define PUSER	100
#define RECPRI  90
#define XMTPRI  90
#define CRITPRI -30
#define LINKPRI -1
