#include <stdio.h>
#include <ctype.h>
#define getchar(fp) getc(fp)
#define    MAXLINE    100
#define    LETTER     'a'
#define    DIGIT      '0'
#define    MAXWORD    20


main()
{
	char *arglist[9];

	hashtst1();
	hashtst2();
	fldtst1();
	hashtst3();
	union1();
	datetst7();
	datetst8();
	freqtst2();
	arglist[0] = "6";
	arglist[1] = "sort the following lines\n";
	arglist[2] = "into alphabetical order\n";
	arglist[3] = "And make sure that the\n";
	arglist[4] = "sort results are correct.\n";
	arglist[5] = "\n";
        sortst8(6, arglist);
	arglist[0] = "9";
	arglist[1] = "-n\n";
	arglist[2] = "234\n";
	arglist[3] = "3\n";
	arglist[4] = "78\n";
	arglist[5] = "9\n";
	arglist[6] = "34\n";
	arglist[7] = "-23\n";
	arglist[8] = "\n";
        sortst8(9, arglist);
	convrtst();
	printst();
	scantst1();
	scantst2();
	scantst3();
	arglist[0] = "4";
	arglist[1] = "in1.c";
	arglist[2] = "in2.c";
	arglist[3] = "in3.c";
	catst1(4, arglist);
}

strcmp2(s, t)     /* copy t to s - pointer version */
register char *s, *t;
{
	for ( ; *s == *t; s++, t++)
		if (*s == '\0')
			return(0);
	return(*s - *t);
}

char *strsave1(s)     /* save string s somewhere */
register char *s;
{
	register char *p;
	char *malloc();

	if ((p = malloc((unsigned) (strlen4(s) + 1))) != NULL)
		strcpy4(p, s);
	else
		printf("ALLOC OUT OF SPACE\n");
	return(p);
}

getline3(s, lim, fp)
register char s[];
register int lim;
FILE *fp;
{
        int c, i;

        for (i=0; i<lim-1 && (c=getchar(fp))!=EOF && c!='\n'; ++i)
                s[i] = c;
        if (c == '\n')
                s[i++] = c;
        s[i] = '\0';
        return(i);
}

strcpy4(s, t)     /* copy t to s - pointer version 3 */
register char *s, *t;
{
	while (*s++ = *t++)
		;
}

atoi4(s)
register char s[];
{
        register int i, val, sign;

        for (i=0; s[i]==' ' || s[i]=='\n' || s[i]=='\t'; i++)
                ;
        sign = 1;
        if (s[i] == '+' || s[i] == '-')
                sign = (s[i++] == '+') ? 1 : -1;
        for (val = 0; s[i] >= '0' && s[i] <= '9'; i++)
                val = 10 * val + s[i] - '0';

        return(sign * val);
}

squeeze1(s, c)
register char s[];
register int c;
{
        int i, j;

        for (i = j = 0; s[i] != '\0'; i++)
                if (s[i] != c)
                        s[j++] = s[i];
                s[j] = '\0';
}

getword2(w, lim, fp)     /* get next word from input */
register char *w;
register int lim;
FILE *fp;
{
	register c, t;

        if (type2(c = *w++ = getch(fp)) != LETTER) {
		*w = '\0';
		return(c);
	}
	while (--lim > 0) {
		t = type2(c = *w++ = getch(fp));
		if (t != LETTER && t != DIGIT)  {
			ungetch(c);
			break;
		}
	}
	*(w-1) = '\0';
	return(LETTER);
}

index2(s, t)
register char s[], t[];
{
        register int i, j, k;

	for(i = 0; s[i] != '\0'; i++) {
	       for (j=i, k=0; t[k]!='\0' && s[j]==t[k]; j++, k++)
			;
		if (t[k] == '\0')
			return(i);
	}
	return(-1);
}

#define HASHSIZE  100

struct nlist1 { /* basic table entry */
	char *name;
	char *def;
	struct nlist1 *next1;  /* next entry in chain */
};
static struct nlist1 *hashtab1[HASHSIZE];  /* pointer table */

hashtst1()
{
	register char word[MAXWORD];
	register char str[MAXWORD];
	register def, n, t;
	struct nlist1 *install1();
	FILE *fp, *fopen();

	printf("\n\nRESULTS FROM hashtst1()\n\n");

	fp = fopen("in11.c", "r");

	def = 0;
	while ((t = getword2(word, MAXWORD, fp)) != EOF)
		if (t == LETTER) {
			itoa1(def++, str);
			n = (int) install1(word, str);
			if (n == NULL)
				return;
		}
        printab1();

	fclose(fp);
}

hash1(s)    /* form hash value for string */
register char *s;
{
	register int hashval;

	for (hashval = 0; *s != '\0'; )
		hashval += *s++;
	return(hashval % HASHSIZE);
}

struct nlist1 *lookup1(s)    /* look for s in hashtab */
register char *s;
{
	register struct nlist1 *np;

	for (np = hashtab1[hash1(s)]; np != NULL; np = np->next1)
		if (strcmp2(s, np->name) == 0)
			return(np);     /* found it */
	return(NULL);   /* not found */
}

struct nlist1 *install1(name, def)    /* put (name, def) */
register char *name, *def;
{
	register struct nlist1 *np;
	struct nlist1 *lookup1();
	char *strsave1(), *malloc();
	register int hashval;

	if ((np = lookup1(name)) == NULL)  {  /* not found */
		np = (struct nlist1 *) malloc(sizeof(*np));
		if (np == NULL) {
			printf("ALLOC OUT OF SPACE\n");
			return(NULL);
		}
		if ((np->name = strsave1(name)) == NULL)
			return(NULL);
		hashval = hash1(np->name);
		np->next1 = hashtab1[hashval];
		hashtab1[hashval] = np;
	}
	else    /* already there */
		free(np->def);  /* free previous definition */
	if ((np->def = strsave1(def)) == NULL)
		return(NULL);
	return(np);
}

printab1()
{
	register struct nlist1 **np;

	printf("table:\n\n");
	for(np = hashtab1; np <= &hashtab1[HASHSIZE-1]; np++)
		if (*np)
		        printf("name = %s  def = %s\n",(*np)->name, (*np)->def);
}

itoa1(n, s)
register char s[];
register int n;
{
        register i, sign;

        if ((sign = n) < 0)
                n = -n;
        i = 0;
        do {
                s[i++] = n % 10 + '0';
        } while (( n /= 10) > 0);
        if (sign < 0)
                s[i++] = '-';
        s[i] = '\0';
        reverse1(s);
}

reverse1(s)
register char s[];
{
        register c, i, j;

        for (i=0, j = strlen4(s)-1; i < j; i++, j--) {
		c = s[i];
		s[i] = s[j];
		s[j] = c;
	}
}

strlen4(s)
register char *s;
{
	register char *p = s;

	while (*p)
		p++;
	return(p-s);
}

#define  BUFSIZE   100

char buf[BUFSIZE];
int bufp = 0;

getch(fp)
FILE *fp;
{
	return((bufp > 0) ? buf[--bufp] : getchar(fp));
}

ungetch(c)
register int c;
{
	if (bufp > BUFSIZE)
		printf("ungetch: too many characters\n");
	else
		buf[bufp++] = c;
}

type2(c)   /* return type of ASCII character */
register int c;
{
	if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z')
		return(LETTER);
	else if (c >= '0' && c <= '9')
		return(DIGIT);
	else
		return(c);
}

struct nlist2 { /* basic table entry */
	char *name;
	char *def;
	int is_a : 2;
	int is_b : 2;
	int is_c : 2;
	struct nlist2 *next2;  /* next entry in chain */
};
static struct nlist2 *hashtab2[HASHSIZE];  /* pointer table */

hashtst2()
{
	register def, n, t;
	register char word[MAXWORD];
	register char str[MAXWORD];
	struct nlist2 *install2();
	FILE *fp, *fopen();

	printf("\n\nRESULTS FROM hashtst2()\n\n");

	fp = fopen("in11.c", "r");

	def = 0;

	while ((t = getword2(word, MAXWORD, fp)) != EOF)
		if (t == LETTER) {
			itoa1(def++, str);
			n = (int) install2(word, str);
			if (n == NULL)
				return;
		}
        printab2();

	fclose(fp);
}

hash2(s)    /* form hash value for string */
register char *s;
{
	register int hashval;

	for (hashval = 0; *s != '\0'; )
		hashval += *s++;
	return(hashval % HASHSIZE);
}

struct nlist2 *lookup2(s)    /* look for s in hashtab */
register char *s;
{
	register struct nlist2 *np;

	for (np = hashtab2[hash2(s)]; np != NULL; np = np->next2)
		if (strcmp2(s, np->name) == 0)
			return(np);     /* found it */
	return(NULL);   /* not found */
}

struct nlist2 *install2(name, def)    /* put (name, def) */
register char *name, *def;
{
	register struct nlist2 *np;
	struct nlist2 *lookup2();
	char *strsave1(), *malloc();
	int hashval;

	if ((np = lookup2(name)) == NULL)  {  /* not found */
		np = (struct nlist2 *) malloc(sizeof(*np));
		if (np == NULL) {
		        printf("ALLOC OUT OF SPACE\n");
			return(NULL);
		}
		if ((np->name = strsave1(name)) == NULL)
			return(NULL);
		hashval = hash2(np->name);
		np->next2 = hashtab2[hashval];
		if (index2(name, "a") != -1)
			np->is_a = 1;
		else
			np->is_a = 0;
		if (index2(name, "b") != -1)
			np->is_b = 1;
		else
			np->is_b = 0;
		if (index2(name, "c") != -1)
			np->is_c = 1;
		else
			np->is_c = 0;
		hashtab2[hashval] = np;
	}
	else    /* already there */
		free(np->def);  /* free previous definition */
	if ((np->def = strsave1(def)) == NULL)
		return(NULL);
	return(np);
}

printab2()
{
	register struct nlist2 **np;

	printf("table:\n\n");
	for(np = hashtab2; np <= &hashtab2[HASHSIZE-1]; np++)
		if (*np)
		        printf("name = %s  def = %s  a = %d  b = %d  c = %d\n",
		              (*np)->name, (*np)->def, (*np)->is_a, (*np)->is_b, (*np)->is_c);
}

fldtst1()
{
	struct {
		int is_A : 2;
		int is_B : 2;
		int is_C : 2;
	} flags;

	printf("\n\nRESULTS FROM fldtst1()\n\n");

	flags.is_A = 1;
	flags.is_B = 0;
	flags.is_C = 1;

	printf("a = %d\nb = %d\nc = %d\n",flags.is_A, flags.is_B, flags.is_C);
}

struct nlist3 { /* basic table entry */
	char *name;
	char *def;
	int type;
	union u_tag {
	        int ival;
	        char cval;
	        char *strval;
	} uval;
	struct nlist3 *next3;  /* next entry in chain */
};
static struct nlist3 *hashtab3[HASHSIZE];  /* pointer table */

hashtst3()
{
	register def, n, t;
	register char word[MAXWORD];
	register char str[MAXWORD];
	struct nlist3 *install3();
	FILE *fp, *fopen();

	printf("\n\nRESULTS FROM hashtst3()\n\n");

	fp = fopen("in11.c", "r");

	def = 0;

	while ((t = getword2(word, MAXWORD, fp)) != EOF)
		if (t == LETTER) {
			itoa1(def++, str);
			n = (int) install3(word, str);
			if (n == NULL)
				return;
		}
        printab3();

	fclose(fp);
}

hash3(s)    /* form hash value for string */
register char *s;
{
	register int hashval;

	for (hashval = 0; *s != '\0'; )
		hashval += *s++;
	return(hashval % HASHSIZE);
}

struct nlist3 *lookup3(s)    /* look for s in hashtab */
register char *s;
{
	register struct nlist3 *np;

	for (np = hashtab3[hash3(s)]; np != NULL; np = np->next3)
		if (strcmp2(s, np->name) == 0)
			return(np);     /* found it */
	return(NULL);   /* not found */
}

struct nlist3 *install3(name, def)    /* put (name, def) */
register char *name, *def;
{
	register struct nlist3 *np;
	struct nlist3 *lookup3();
	char *strsave1(), *malloc();
	register int hashval;

	if ((np = lookup3(name)) == NULL)  {  /* not found */
		np = (struct nlist3 *) malloc(sizeof(*np));
		if (np == NULL) {
			printf("ALLOC OUT OF SPACE\n");
			return(NULL);
		}
		if ((np->name = strsave1(name)) == NULL)
			return(NULL);
		hashval = hash3(np->name);
		np->next3 = hashtab3[hashval];
		np->type = 0;
		if (index2(name, "a") != -1) {
			np->type = 1;   /* integer */
			np->uval.ival = 10;
		}
		if (index2(name, "b") != -1) {
			np->type = 2;    /* char */
			np->uval.cval = 'b';
		}
		if (index2(name, "c") != -1)  {
			np->type = 3;    /* string */
			np->uval.strval = "string";
		}
		hashtab3[hashval] = np;
	}
	else    /* already there */
		free(np->def);  /* free previous definition */
	if ((np->def = strsave1(def)) == NULL)
		return(NULL);
	return(np);
}

printab3()
{
	register struct nlist3 **np;

	printf("table:\n\n");
	for (np = hashtab3; np <= &hashtab3[HASHSIZE-1]; np++)
		if (*np) {
		        printf("name = %s  def = %s    ",
		              (*np)->name, (*np)->def);
			if ((*np)->type)
				switch ((*np)->type) {
				   case 1:
				   printf("val = %d\n", (*np)->uval.ival);
				   break;
				   case 2:
				   printf("val = %c\n", (*np)->uval.cval);
				   break;
				   case 3:
				 printf("val = %s\n", (*np)->uval.strval);
				   break;
				   default:
					  printf("wrong type\n");
			        }
			else
				printf("\n");
		}
}

#define    SYMLNGTH   30

struct block1 {
	union {
	        char *Uname;
		int iname;
	} uname;
        int blklvl;
        int type;
        struct block1 *left1;
        struct block1 *right1;
};

union1()
{
	/* test unions */

	register struct block1 *head, *t1, *t2;
	char *malloc();

	printf("\n\nRESULTS FROM union1()\n\n");

	head = (struct block1 *) malloc(sizeof(struct block1));
	head -> uname.Uname = "HEADNODE";
	head -> blklvl = 0;
	head -> type = 1;

	t1 = (struct block1 *) malloc(sizeof(struct block1));
	if (t1 == NULL) {
		printf("ALLOC OUT OF SPACE\n");
		return;
	}
	t1 -> uname.Uname = "LEFT TREE";
	t1 -> blklvl = 1;
	t1 -> type = 2;
	t1 -> left1 = NULL;
	t1 -> right1 = NULL;

	t2 = (struct block1 *) malloc(sizeof(struct block1));
	if (t2 == NULL) {
		printf("ALLOC OUT OF SPACE\n");
		return;
	}
	t2 -> uname.Uname = "RIGHT TREE";
	t2 -> blklvl = 0;
	t2 -> type = 3;
	t2 -> left1 = NULL;
	t2 -> right1 = NULL;

	/* set the tree pointers */

	head -> left1 = t1;
	head -> right1 = t2;

	/* traverse the tree */

	traverse1(head);
}

traverse1(p)
register struct block1 *p;
{
	printf("name = %s\n", p-> uname.Uname);
	printf("blklvl =  %d\n", p -> blklvl);
	printf("type =  %d\n", p -> type);
	if (p -> left1 != NULL)
		traverse1(p -> left1);

	if (p -> right1 != NULL)
		traverse1(p -> right1);

}

union date7 {
	struct {
	        int day;
	        int month;
	        int year;
	        int yearday;
	        char *mon_name;
	} strname7;
	char dummy;
} d7;

char *months7[13] = { "XXX", "JAN", "FEB", "MAR", "APR", "MAY", "JUN",
                         "JUL", "AUG", "SEP", "OCT", "NOV", "DEC" };


datetst7()
{
	/* test unions */

        register char flag[MAXLINE];
        register char year[MAXLINE];
        register char month[MAXLINE];
        register char day[MAXLINE];
	FILE *fp, *fopen();

	printf("\n\nRESULTS FROM datetst7()\n\n");

	fp = fopen("in9.c", "r");

	d7.strname7.day = 0;
	d7.strname7.month = 0;
	d7.strname7.year = 0;
	d7.strname7.yearday = 0;
	d7.strname7.mon_name = "XXX";

        while(getline3(flag, MAXLINE, fp) > 0) {
		squeeze1(flag, ' ');
		squeeze1(flag, '\n');
		if (strcmp2(flag, "year") == 0) {
		        getline3(year, MAXLINE, fp);
		        getline3(month, MAXLINE, fp);
		        getline3(day, MAXLINE, fp);
			d7.strname7.year = atoi4(year);
			d7.strname7.month = atoi4(month);
			d7.strname7.day = atoi4(day);
			strcpy4(d7.strname7.mon_name,
			        months7[d7.strname7.month]);
			d7.strname7.yearday = day7_of_year((union date7 *) &d7.strname7);
		}
	        else if (strcmp2(flag, "month") == 0) {
		        getline3(year, MAXLINE, fp);
		        getline3(day, MAXLINE, fp);
			d7.strname7.year = atoi4(year);
			d7.strname7.yearday = atoi4(day);
			month7_day((union date7 *) &d7.strname7);
			strcpy4(d7.strname7.mon_name,
			           months7[d7.strname7.month]);
	        }
	        else {
		printf("error - wrong flag\n");
		return;
	        }
  printf("day = %d\nmonth = %d\nyear = %d\nyearday = %d\nname = %s\n",
           d7.strname7.day, d7.strname7.month, d7.strname7.year,
                d7.strname7.yearday, d7.strname7.mon_name);
        }

	fclose(fp);
}

static int day7_tab[2][13] = {
	{0, 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31},
	{0, 31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31}
};

day7_of_year(pd)           /* set day of year from month & */
register union date7 *pd;           /* day - pointer version        */
{
	register int i, day, leap;

	day = (*pd).strname7.day;
	leap = (*pd).strname7.year % 4 == 0 && pd->strname7.year % 100 != 0
	          || (*pd).strname7.year % 400 == 0;

	for (i = 1; i < (*pd).strname7.month; i++)
		day += day7_tab[leap][i];
	return(day);
}

month7_day(pd)         /* set month, day from day of */
register union date7 *pd;       /* year - pointer version     */
{
	register i, leap;

	leap = (*pd).strname7.year%4 == 0 && pd->strname7.year%100 != 0
	                       || pd->strname7.year%400 == 0;

	(*pd).strname7.day = pd->strname7.yearday;
	for (i = 1; (*pd).strname7.day > day7_tab[leap][i]; i++)
		(*pd).strname7.day -= day7_tab[leap][i];
	(*pd).strname7.month = i;
}

typedef int LENGTH;
typedef char *STRING;

union date8 {
	struct {
	        LENGTH day;
	        LENGTH month;
	        LENGTH year;
	        LENGTH yearday;
	        STRING mon_name;
	} strname8;
	char dummy;
} d8;

STRING months8[13] = { "XXX", "JAN", "FEB", "MAR", "APR", "MAY", "JUN",
                          "JUL", "AUG", "SEP", "OCT", "NOV", "DEC" };


datetst8()
{
	/* test unions */

        register char flag[MAXLINE];
        register char year[MAXLINE];
        register char month[MAXLINE];
        register char day[MAXLINE];
	FILE *fp, *fopen();

	printf("\n\nRESULTS FROM datetst8()\n\n");

	fp = fopen("in9.c", "r");

	d8.strname8.day = 0;
	d8.strname8.month = 0;
	d8.strname8.year = 0;
	d8.strname8.yearday = 0;
	d8.strname8.mon_name = "XXX";

        while(getline3(flag, MAXLINE, fp) > 0) {
		squeeze1(flag, ' ');
		squeeze1(flag, '\n');
		if (strcmp2(flag, "year") == 0) {
		        getline3(year, MAXLINE, fp);
		        getline3(month, MAXLINE, fp);
		        getline3(day, MAXLINE, fp);
			d8.strname8.year = atoi4(year);
			d8.strname8.month = atoi4(month);
			d8.strname8.day = atoi4(day);
			strcpy4(d8.strname8.mon_name,
			        months8[d8.strname8.month]);
			d8.strname8.yearday = day8_of_year((union date8 *) &d8.strname8);
		}
	        else if (strcmp2(flag, "month") == 0) {
		        getline3(year, MAXLINE, fp);
		        getline3(day, MAXLINE, fp);
			d8.strname8.year = atoi4(year);
			d8.strname8.yearday = atoi4(day);
			month8_day((union date8 *) &d8.strname8);
			strcpy4(d8.strname8.mon_name,
			           months8[d8.strname8.month]);
	        }
	        else {
		printf("error - wrong flag\n");
		return;
	        }
  printf("day = %d\nmonth = %d\nyear = %d\nyearday = %d\nname = %s\n",
           d8.strname8.day, d8.strname8.month, d8.strname8.year,
                d8.strname8.yearday, d8.strname8.mon_name);
        }

	fclose(fp);
}

static LENGTH day8_tab[2][13] = {
	{0, 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31},
	{0, 31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31}
};

day8_of_year(pd)           /* set day of year from month & */
register union date8 *pd;           /* day - pointer version        */
{
	register LENGTH i, day, leap;

	day = (*pd).strname8.day;
	leap = (*pd).strname8.year % 4 == 0 && pd->strname8.year % 100 != 0
	          || (*pd).strname8.year % 400 == 0;

	for (i = 1; i < (*pd).strname8.month; i++)
		day += day8_tab[leap][i];
	return(day);
}

month8_day(pd)         /* set month, day from day of */
register union date8 *pd;       /* year - pointer version     */
{
	register i, leap;

	leap = (*pd).strname8.year%4 == 0 && pd->strname8.year%100 != 0
	                       || pd->strname8.year%400 == 0;

	(*pd).strname8.day = pd->strname8.yearday;
	for (i = 1; (*pd).strname8.day > day8_tab[leap][i]; i++)
		(*pd).strname8.day -= day8_tab[leap][i];
	(*pd).strname8.month = i;
}

typedef struct tnode2 {         /* the basic node */
        char *word;              /* points to the text */
        int count;               /* number of occurrences */
	struct tnode2 *left2;    /* left child */
	struct tnode2 *right2;   /* right child */
} TREENODE, *TREEPTR;

freqtst2()    /* word frequency count */
{
	/* test TYPEDEF */

	register TREEPTR root;
	TREEPTR tree2();
	register char word[MAXWORD];
	register int t;
	FILE *fp, *fopen();

	printf("\n\nRESULTS FROM freqtst2()\n\n");

	fp = fopen("in11.c", "r");

	root = NULL;
	while ((t = getword2(word, MAXWORD, fp)) != EOF)
		if (t == LETTER)
			root = tree2(root, word);
	treeprint2(root);

	fclose(fp);
}

TREEPTR tree2(p, w)    /* install w at or below p */
register TREEPTR p;
register char *w;
{
	TREEPTR talloc2();
	char *strsave1();
	register cond;

	if (p == NULL)  {    /* a new word has arrived */
		p = talloc2();        /* make a new word */
		if (p == NULL) {
			printf("ALLOC OUT OF SPACE\n");
			return(NULL);
		}
		p->word = strsave1(w);
		p->count = 1;
		p->left2 = p->right2 = NULL;
	}
	else if ((cond = strcmp2(w, p->word)) == 0)
		p->count++;    /* repeated word */
	else if (cond < 0)  /* lower goes into left subtree */
		p->left2 = tree2(p->left2, w);
	else     /* greater into right subtree */
		p->right2 = tree2(p->right2, w);
	return(p);
}

treeprint2(p)    /* print tree p recursively */
register TREEPTR p;
{
	if (p != NULL)  {
		treeprint2(p->left2);
		printf("%4d  %s\n", p->count, p->word);
		treeprint2(p->right2);
	}
}

TREEPTR talloc2()
{
        char *malloc();

        return((TREEPTR) malloc(sizeof(TREENODE)));
}

#define  LINES  15        /* max number of lines to be sorted */

int nlines;               /* number of input lines read */
char *lineptr[LINES];   /* pointers to text lines */

typedef int (PFI());

sortst8(argc, argv)       /* sort input lines */
register int argc;
register char *argv[];
{
	/* test TYPEDEF */

        PFI strcmp2, numcmp8;  /* comparison functions */
        PFI swap8;    /* exchange function */
        register numeric = 0;   /* 1 if numeric sort */
	register idx = 0;

	printf("\n\nRESULTS FROM sortst8()\n\n");

	printf("UNSORTED LINES\n");
        if (argc>1 && argv[1][0] == '-' && argv[1][1] == 'n') {
                numeric = 1;
		idx = 1;
	}
        if ((nlines = read8lines(lineptr, LINES, &argv[idx])) >= 0) {
                write8lines(lineptr, nlines);
		printf("\n\nSORTED LINES\n");
                if (numeric)
                        sort8(lineptr, nlines, numcmp8, swap8);
                else
                        sort8(lineptr, nlines, strcmp2, swap8);
                write8lines(lineptr, nlines);
        }
        else
                printf("input too big to sort\n");
}

sort8(v, n, comp, exch)    /* sort strings v[0] ... v[n-1]  */
register char *v[];      /* into increasing order             */
register int n;
int (*comp)(), (*exch)();
{
	register int gap, i, j;

	for(gap = n/2; gap > 0; gap /= 2)
		for (i = gap; i < n; i++)
			for (j = i-gap;j >= 0 & (j+gap) < n;j -= gap) {
				if ((*comp)(v[j], v[j+gap]) <= 0)
					break;
				(*exch)(v + j, v + (j+gap));
			}
}

numcmp8(s1, s2)   /* compare s1 and s2 numerically */
register char *s1, *s2;
{
	register v1, v2;

	v1 = atoi4(s1);
	v2 = atoi4(s2);
	if (v1 < v2)
		return(-1);
	else if (v1 > v2)
		return(1);
	else
		return(0);
}

swap8(px, py)    /* interchange *px and *py */
register char *px[], *py[];
{
	register char *temp;

	temp = *px;
	*px = *py;
	*py = temp;
}

#define   MAXLEN   50

read8lines(Lineptr, maxlines, addr)    /* read input lines */
register char *Lineptr[];                     /* for sorting      */
register int maxlines;
register char **addr;
{
        register char *p, line[MAXLEN];
        register len, Nlines;
        char *malloc();

        Nlines = 0;
        while ((len = getline8(line, MAXLEN, *++addr)) > 0)
                if (Nlines >= maxlines)
                        return(-1);
                else if ((p = malloc((unsigned) len)) == NULL) {
			printf("ALLOC OUT OF SPACE\n");
                        return(-1);
		}
                else {
                        line[len-1] = '\0';   /* zap newline */
                        strcpy4(p, line);
                        Lineptr[Nlines++] = p;
                }
        return(Nlines);
}

write8lines(Lineptr, Nlines)    /* write output lines */
register char *Lineptr[];
register int Nlines;
{
        while (--Nlines >= 0)
                printf("%s\n", *Lineptr++);
}

getline8(s, lim, str)
register char s[];
register int lim;
register char str[];
{
        register int c, i;

        for (i=0; i<lim-1 && (c = str[i]) && c!='\n'; )
                s[i++] = c;
        if ((c == '\n') && i!=0)
                s[i++] = c;
        s[i] = '\0';
        return(i);
}

convrtst()     /* convert input to lower case */
{
	/*  test system macros  */

        register c;
	FILE *fp, *fopen();

	printf("\n\nRESULTS FROM convrtst()\n\n");

	fp = fopen("in12.c", "r");

        while ((c=getchar(fp)) != EOF)
                putchar(isupper(c) ? tolower(c) : c);

	fclose(fp);
}

printst()
{
	/* test printf */

	register i;

	printf("\n\nRESULTS FROM printst()\n\n");

	for (i= -7; i <= 19; i++) {
		printf("dec i = %d\n", i);
		printf("oct i = %o\n", i);
		printf("hex i = %x\n", i);
		printf("uns i = %u\n", i);
	}
}

scantst1()
{
	/* test scanf */

	int i;
	float x;
	register char name[50];
	FILE *fp, *fopen();

	printf("\n\nRESULTS FROM scantst1()\n\n");

	fp = fopen("in13.c", "r");

	fscanf(fp, "%d %f %s", &i, &x, name);
	printf("i = %d  x = %f  name = %s\n", i, x, name);

	fclose(fp);
}

scantst2()
{
	/* test scanf */

	int i;
	float x;
	register char name[50];
	FILE *fp, *fopen();

	printf("\n\nRESULTS FROM scantst2()\n\n");

	fp = fopen("in14.c", "r");

	fscanf(fp, "%2d %f %*d %2s", &i, &x, name);
	printf("i = %d  x = %f  name = %s\n", i, x, name);

	fclose(fp);
}

scantst3()   /* rudimentary desk calculator */
{
	double sum, v;
	FILE *fp, *fopen();

	printf("\n\nRESULTS FROM scantst3()\n\n");

	fp = fopen("in15.c", "r");

	sum = 0;
	while(fscanf(fp, "%lf", &v) != EOF)
		printf("\t%.2f\n", sum += v);

	fclose(fp);
}

catst1(argc, argv)   /* cat: concatenate files */
register int argc;
register char *argv[];
{
	FILE *fp, *fopen();

	printf("\n\nRESULTS FROM catst1()\n\n");

	if (argc == 1)   /* no args; copy standard input */
		filecopy(stdin);
	else
		while (--argc > 0)
			if ((fp = fopen(*++argv, "r")) == NULL)  {
				printf("cat: can't open %s\n", *argv);
				break;
			}
			else {
				filecopy(fp);
				fclose(fp);
			}
}

filecopy(fp)    /* copy file fp to standard output */
FILE *fp;
{
	register int c;

	while ((c = getc(fp)) != EOF)
		putc(c, stdout);
}
