struct key {
        char *keyword;
        int keycount;
} keytab[] = {
	"auto",0,
	"break",0,
	"case",0,
	"char",0,
	"continue",0,
	"default",0,
	"define",0,
	"do",0,
	"double",0,
	"else",0,
	"endif",0,
	"extern",0,
	"float",0,
	"for",0,
	"goto",0,
	"if",0,
	"ifdef",0,
	"ifndef",0,
	"include",0,
	"int",0,
	"long",0,
	"register",0,
	"return",0,
	"short",0,
	"sizeof",0,
	"static",0,
	"struct",0,
	"switch",0,
	"typedef",0,
	"undef",0,
	"union",0,
	"unsigned",0,
	"while",0
};

#define    MAXWORD  20
#define    EOF        -1
#define    NKEYS  (sizeof(keytab) / sizeof(struct key))
#define    LETTER   'a'
#define    DIGIT    '0'
#include   "getch.c"
#include   "strcmp.c"

main()    /* count C keywords */
{
        register n, t;
        char word[MAXWORD];

        while ((t = getword(word, MAXWORD)) != EOF)
                if (t == LETTER)
                        if ((n = binary(word, keytab, NKEYS)) >= 0)
                                keytab[n].keycount++;
        for (n = 0; n < NKEYS; n++)
                if (keytab[n].keycount > 0)
                        printf("%4d %s\n",
                               keytab[n].keycount, keytab[n].keyword);
}

binary(word, tab, n)   /* find word in tab[0] ... tab[n-1] */
char *word;
struct key tab[];
int n;
{
        register low, high, mid, cond;

        low = 0;
        high = n - 1;
        while (low <= high) {
                mid = (low+high) / 2;
                if ((cond = strcmp(word, tab[mid].keyword)) < 0)
	                high = mid - 1;
		else if (cond > 0)
			low = mid + 1;
                else
                        return(mid);
        }
        return(-1);
}

getword(w, lim)     /* get next word from input */
char *w;
int lim;
{
	register c, t;

        if (type(c = *w++ = getch()) != LETTER) {
		*w = '\0';
		return(c);
	}
	while (--lim > 0) {
		t = type(c = *w++ = getch());
		if (t != LETTER && t != DIGIT)  {
			ungetch(c);
			break;
		}
	}
	*(w-1) = '\0';
	return(LETTER);
}

type(c)   /* return type of ASCII character */
int c;
{
	if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z')
		return(LETTER);
	else if (c >= '0' && c <= '9')
		return(DIGIT);
	else
		return(c);
}
