
# line 2 "ioconf.y"
/*
 * Description:
 *   This component contains the YACC grammar for the
 *   input to the I/O configurator.
 */
#include <stdio.h>

extern  int     errors;         /* record errors */
extern  char    yytext[];
char    devtype[30];
char    mountdir[30];
char    *mnt;
int     lowaddr,                /* beginning of an address range */
        highaddr;               /* end of the address range */
# define COMMENT 257
# define ADDR 258
# define DEVTYPE 259
# define MOUNT 260
#define yyclearin yychar = -1
#define yyerrok yyerrflag = 0
extern int yychar;
extern short yyerrflag;
#ifndef YYMAXDEPTH
#define YYMAXDEPTH 150
#endif
#ifndef YYSTYPE
#define YYSTYPE int
#endif
YYSTYPE yylval, yyval;
# define YYERRCODE 256

# line 42 "ioconf.y"

dodev(devtype, mount)
char    *devtype;
char    *mount;
{
        register i, rc;

	for (i = lowaddr;i <= highaddr; i++) {
		rc = dev(i, devtype, mount);
                /*
                 *  Check for errors (message
                 *  was issued by dev)
                 */
                switch (rc) {
                case 0:
                     continue;
                case 2:  /* go on with next */
                     errors += 1;
                     continue;
                case 1:  /* skip rest of this request */
                     errors += 1;
                     i = highaddr;
                     break;
                case 3:  /* quit */
                default:
                     error(1, "configuration not generated due to errors");
                }
        }
}
short yyexca[] ={
-1, 1,
	0, -1,
	-2, 0,
	};
# define YYNPROD 12
# define YYLAST 250
short yyact[]={

  14,   4,   9,  12,  10,   2,   8,  13,  11,   6,
   3,   1,   0,   0,   0,   0,   0,  15,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   5,   7 };
short yypact[]={

-1000,  -9,-1000,  -4,-1000,-1000,-257, -41,-1000,-1000,
-255,-260,-1000,-1000,-1000,-1000 };
short yypgo[]={

   0,  11,  10,   5,   9,   8,   7 };
short yyr1[]={

   0,   1,   1,   1,   2,   5,   2,   4,   4,   6,
   6,   3 };
short yyr2[]={

   0,   3,   2,   1,   1,   0,   4,   1,   3,   1,
   1,   0 };
short yychk[]={

-1000,  -1,  -3,  -2,  10, 257,  -4, 258,  10, 259,
  45,  -5, 258,  -6, 260,  -3 };
short yydef[]={

  11,  -2,   3,   0,   2,   4,   0,   7,   1,   5,
   0,  11,   8,   6,   9,  10 };
#
# define YYFLAG -1000
# define YYERROR goto yyerrlab
# define YYACCEPT return(0)
# define YYABORT return(1)

/*	parser for yacc output	*/

int yydebug = 0; /* 1 for debugging */
YYSTYPE yyv[YYMAXDEPTH]; /* where the values are stored */
int yychar = -1; /* current input token number */
int yynerrs = 0;  /* number of errors */
short yyerrflag = 0;  /* error recovery flag */

yyparse() {

	short yys[YYMAXDEPTH];
	short yyj, yym;
	register YYSTYPE *yypvt;
	register short yystate, *yyps, yyn;
	register YYSTYPE *yypv;
	register short *yyxi;

	yystate = 0;
	yychar = -1;
	yynerrs = 0;
	yyerrflag = 0;
	yyps= &yys[-1];
	yypv= &yyv[-1];

 yystack:    /* put a state and value onto the stack */

	if( yydebug  ) printf( "state %d, char 0%o\n", yystate, yychar );
		if( ++yyps> &yys[YYMAXDEPTH] ) { yyerror( "yacc stack overflow" ); return(1); }
		*yyps = yystate;
		++yypv;
		*yypv = yyval;

 yynewstate:

	yyn = yypact[yystate];

	if( yyn<= YYFLAG ) goto yydefault; /* simple state */

	if( yychar<0 ) if( (yychar=yylex())<0 ) yychar=0;
	if( (yyn += yychar)<0 || yyn >= YYLAST ) goto yydefault;

	if( yychk[ yyn=yyact[ yyn ] ] == yychar ){ /* valid shift */
		yychar = -1;
		yyval = yylval;
		yystate = yyn;
		if( yyerrflag > 0 ) --yyerrflag;
		goto yystack;
		}

 yydefault:
	/* default state action */

	if( (yyn=yydef[yystate]) == -2 ) {
		if( yychar<0 ) if( (yychar=yylex())<0 ) yychar = 0;
		/* look through exception table */

		for( yyxi=yyexca; (*yyxi!= (-1)) || (yyxi[1]!=yystate) ; yyxi += 2 ) ; /* VOID */

		while( *(yyxi+=2) >= 0 ){
			if( *yyxi == yychar ) break;
			}
		if( (yyn = yyxi[1]) < 0 ) return(0);   /* accept */
		}

	if( yyn == 0 ){ /* error */
		/* error ... attempt to resume parsing */

		switch( yyerrflag ){

		case 0:   /* brand new error */

			yyerror( "syntax error" );
		yyerrlab:
			++yynerrs;

		case 1:
		case 2: /* incompletely recovered error ... try again */

			yyerrflag = 3;

			/* find a state where "error" is a legal shift action */

			while ( yyps >= yys ) {
			   yyn = yypact[*yyps] + YYERRCODE;
			   if( yyn>= 0 && yyn < YYLAST && yychk[yyact[yyn]] == YYERRCODE ){
			      yystate = yyact[yyn];  /* simulate a shift of "error" */
			      goto yystack;
			      }
			   yyn = yypact[*yyps];

			   /* the current yyps has no shift onn "error", pop stack */

			   if( yydebug ) printf( "error recovery pops state %d, uncovers %d\n", *yyps, yyps[-1] );
			   --yyps;
			   --yypv;
			   }

			/* there is no state on the stack with an error shift ... abort */

	yyabort:
			return(1);


		case 3:  /* no shift yet; clobber input char */

			if( yydebug ) printf( "error recovery discards char %d\n", yychar );

			if( yychar == 0 ) goto yyabort; /* don't discard EOF, quit */
			yychar = -1;
			goto yynewstate;   /* try again in the same state */

			}

		}

	/* reduction by production yyn */

		if( yydebug ) printf("reduce %d\n",yyn);
		yyps -= yyr2[yyn];
		yypvt = yypv;
		yypv -= yyr2[yyn];
		yyval = yypv[1];
		yym=yyn;
			/* consult goto table to find next state */
		yyn = yyr1[yyn];
		yyj = yypgo[yyn] + *yyps + 1;
		if( yyj>=YYLAST || yychk[ yystate = yyact[yyj] ] != -yyn ) yystate = yyact[yypgo[yyn]];
		switch(yym){
			
case 5:
# line 29 "ioconf.y"
{ strcpy(devtype, yytext); } break;
case 6:
# line 30 "ioconf.y"
{ dodev(devtype, mnt); } break;
case 7:
# line 33 "ioconf.y"
{ lowaddr = highaddr = yypvt[-0]; } break;
case 8:
# line 34 "ioconf.y"
{ lowaddr = yypvt[-2]; highaddr = yypvt[-0]; } break;
case 9:
# line 37 "ioconf.y"
{ strcpy(mountdir, yytext); mnt = mountdir; } break;
case 10:
# line 38 "ioconf.y"
{ mnt = NULL; } break;
		}
		goto yystack;  /* stack new state and value */

	}
