/*
 *      ww - who what
 *      modified from ps - examine and print certain
 *          things about processes
 */

#include <stdio.h>
#include <a.out.h>
#include <sys/param.h>
#include <sys/proc.h>
#include <sys/tty.h>
#include <sys/dir.h>
#include <sys/user.h>
#include <sys/stat.h>
#include <pwd.h>

struct proc proc[NPROC];
struct user user;

#define PTSIZE 16
struct pagetab {
	int     *pt_next;
	int     pt_junk;
	short   pt_entry[PTSIZE];
} pagetab;

int     lflg;
int     sflg;
int     mem;
int     prot;

int     ndev;
char    devc[65][16];
int     devl[65];
char    *coref;
char    *procf;

char    stgtty[10];
char    stgpid[10];
int     print;

main(argc, argv)
char **argv;
{
        struct proc *p;
        int i, c;
        char *ap;
        char *cs;
        char *ttyname();
        int puid;

        if (argc>1) {
                ap = argv[1];
                while (*ap) switch (*ap++) {
                case 'l':
                        lflg++;
                        break;
                case 's':
                        sflg++;
                        break;
                }
        }

        if(chdir("/dev") < 0) {
                printf("cannot change to /dev\n");
                done();
        }
        coref = "/dev/mem";
        procf = "/dev/kmem/proc";
        if ((mem = open(coref, 0)) < 0) {
                printf("No mem\n");
                done();
        }
        if ((prot = open(procf, 0)) < 0) {
                printf("No process table\n");
                done();
        }
        read(prot, (char *)proc, NPROC*sizeof *p);
        getdev();
	if (lflg)
	        printf("TTY       WHO         PID   COMMAND\n");
        else
	        printf("WHO      COMMAND\n");
        for (i=0; i<NPROC; i++) {
                if (proc[i].p_stat==0)
                        continue;
	        seek(mem, (int)proc[i].p_addr, 0);
	        read(mem, (char *)&user, sizeof user);
                if (user.u_ttyp==0) {
                        cs = "?";
                } else {
                        for(c=0; c<ndev; c++)
	                        if(devl[c] == user.u_ttyd) {
	                                cs = devc[c];
	                                goto out;
	                        }
                        for(c=0; c<ndev; c++)
	                        if(devl[c] == user.u_ttyd) {
	                                cs = devc[c];
	                                goto out;
	                        }
                        cs = "?";
                out:;
                }
                puid = proc[i].p_uid & 0377;
/*Here*/
		sprintf(stgtty, "%-8.8s", cs);
		sprintf(stgpid, "%6d", proc[i].p_pid);
		if(strcmp(cs, "?")) {
                        if(proc[i].p_stat == SZOMB)
                                if(lflg) {
                                        printf("%s  ", stgtty);
                                        who(puid);
                                        printf("%s  <defunct>", stgpid);
                                        print = 1;
                                }
                                else {
                                        who(puid);
                                        printf("  <defunct>");
                                        print = 1;
                                }
                        else
                                prcom(i);
		}
		if(print) {
			printf("\n");
			print = 0;
		}
        }
        done();
}

getdev()
{
        register i, c;
        int f;
        struct direct dbuf;
        struct stat sbuf;

        f = open("/dev",0);
        if(f < 0) {
                printf("cannot open /dev\n");
                done();
        }
        c = 0;

	for(;;) {
                i = read(f, (char *)&dbuf, sizeof dbuf);
                if(i <= 0) {
                        close(f);
                        ndev = c;
                        return;
                }
                if(dbuf.d_ino == 0)
                        continue;
                if(dbuf.d_name[0] == 't' &&
                   dbuf.d_name[1] == 't' &&
                   dbuf.d_name[2] == 'y' &&
                   dbuf.d_name[3] != 0) {
                        if(stat(dbuf.d_name, &sbuf) < 0)
                                continue;
                        strcpy(devc[c], dbuf.d_name);
                        devl[c] = sbuf.st_rdev;
                        c++;
                        continue;
                }
        }
}

prcom(i)
{
        register int *ip;
        register char *cp, *cp1;
        int c, nbad, addr;
	char abuf[512];

        if(i == 0) {    /* process 0 */
                return(0);
        }
        seek(mem, (int)user.u_sseg.u_pages, 0);
        read(mem, (char *)&pagetab, sizeof pagetab);
        addr = pagetab.pt_entry[PTSIZE - 1];
        addr = (addr >> 4) << 12;
	addr += (4096 - 512);
        seek(mem, addr, 0);
	if (read(mem, abuf, sizeof(abuf)) != sizeof(abuf))
		return(1);
	for (ip = (int *)&abuf[512]-2; ip > (int *)abuf; ) {
		if (*--ip == -1 || *ip==0) {
			cp = (char *)(ip+1);
			if (*cp==0)
				cp++;
			nbad = 0;
			for (cp1 = cp; cp1 < &abuf[512]; cp1++) {
				c = *cp1&0177;
				if (c==0)
					*cp1 = ' ';
				else if (c < ' ' || c > 0176) {
					if (++nbad >= 5) {
						*cp1++ = ' ';
						break;
					}
					*cp1 = '?';
				} else if (c=='=') {
					*cp1 = 0;
					while (cp1>cp && *--cp1!=' ')
						*cp1 = 0;
					break;
				}
			}
			while (*--cp1==' ')
				*cp1 = 0;
			/*
			 * if -s, print shells,
			 * but never the spooler or inits.
			 */
			if(((strcmp(cp, "-sh ") && strcmp(cp, "/etc/init")) || sflg) &&
			    strcmp(cp, "spooler ")) {
				if(lflg)
					printf("%s  ", stgtty);
				who(user.u_ruid);
                                if(lflg)
                                        printf(" %s   %.40s", stgpid, cp);
                                else
                                        printf(" %.60s", cp);
                                print = 1;
			}
                        return(1);
		}
	}
	return(1);
}
done()
{

        exit(0);
}

who(uid)                                /* get & print uid's logon name */
int uid;
{
	struct passwd *getpwuid();

	printf("%-8.8s",getpwuid(uid)->pw_name); /* print logon name    */
	return;
}
