#include <stdio.h>
#include <pwd.h>


#define FILENAME        'f'
#define QUIET           'q'
#define DASH            '-'
#define EOS             '\0'

char usage[] = "Usage: %s system outfile [cmd ...] [-] [-f shfile ...]\n";
extern  char    *cmdname;

main(argc, argv)
int argc;
char **argv;
{
	FILE    *pfd;
	FILE    *fd;
	FILE    *popen();
	char    *qual();
	char    *userid;
	char    *quiet = "LOUD";
	char    cmd[60];
	struct  passwd  *pw;

	*argv++;
        if (**argv == DASH) {
                switch(*++(*argv)) {
                case QUIET:
                        argv++;
                        argc--;
			quiet = "-q";
			break;
		}
	}
	if (argc < 3) {
		fprintf(stderr, usage, cmdname);
		exit(1);
	}
        sprintf(cmd, "vmpunch -v %s -x douux", *argv++);
        pfd = popen(cmd, "w");
	if ((userid = getlogin()) == NULL) {
		if ((pw = getpwuid(getuid())) == NULL)
			exit(1);
		userid = pw->pw_name;
	}
	fprintf(pfd, "%s\n", userid);
	fprintf(pfd, "%s\n", vmid());
	fprintf(pfd, "%s\n", qual(*argv++));
	fprintf(pfd, "%s\n", quiet);
	argc -= 3;
	if (!argc)
		copy(stdin, pfd);
	else while (argc--) {
                if (**argv == DASH) {
			switch(*++(*argv)) {
                        case FILENAME:
                                argv++;
                                argc--;
                                if ((fd = fopen(*argv++, "r")) == NULL) {
                                        fprintf(stderr, "%s: unable to open\n", *--argv);
                                        exit(1);
                                }
                                copy(fd, pfd);
                                break;
                        case EOS:
                                copy(stdin, pfd);
                                argv++;
                                break;
                        default:
                                fprintf(stderr, usage, cmdname);
                                exit(1);
                        }
		} else
                        fprintf(pfd, "%s\n", *argv++);
	}
        pclose(pfd);
	exit(0);
}

/*
 * If the receiving file name doesn't begin with a slash,
 * prepend the current working directory.
 */
char *qual(fn)
char *fn;
{
	FILE    *pfd, *popen();
	static char name[200];

	if(*fn == '/')
		return(fn);
	pfd = popen("pwd", "r");
	fgets(name, 200, pfd);
	pclose(pfd);
	name[strlen(name)-1] = EOS;
	strcat(name, "/");
	strcat(name, fn);
	return(name);
}

copy(ifd, ofd)
	FILE    *ifd;
	FILE    *ofd;
{
	int     c;

	while ((c = getc(ifd)) != EOF)
		putc(c, ofd);
}
