/* The 'untab' command unpacks the given files, replacing leading    */
/* tab characters with blanks.  If no filename is given, the         */
/* standard input is read, and the result is placed on the standard  */
/* output.                                                           */

#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <signal.h>

#define   MAXLINE 512

extern int cancel();

char   tname[51];
char   line[MAXLINE];
FILE   *outfil;
FILE   *infil;
struct stat sb;


main(argc, argv) char **argv;
{
        int fildes;

        signal(SIGINT, cancel);
        if (--argc <= 0) {
                infil  = stdin;
                outfil = stdout;
                process();
        }
        else {
                ++argv;
                do {
                        if ((infil=fopen(*argv,"r"))==NULL) {
                               fprintf(stderr, "Cannot open %s\n", *argv);
                                continue;
                        }
                        maketemp(*argv, tname);
                        fstat(fileno(infil), &sb);
                        if ((fildes=creat(tname, (int)sb.st_mode))<0) {
                             fprintf(stderr, "Cannot create %s\n", tname);
                                continue;
                        }
                        outfil=fdopen(fildes,"w");
                        process();
                        fclose(infil);
                        fclose(outfil);
                        unlink(*argv);
                        if (link(tname, *argv) < 0)
                           fprintf(stderr, "Link failed for %s\n", tname);
                        else
                                unlink(tname);
                        ++argv;
                } while(--argc > 0);
        }
}


maketemp(src, tn)  char *src, *tn;

/* This thing makes a temporary filename which will exist in the same */
/* directory as that of the given source file.                        */
{
        register char *s, *t;

        t = tn;
        s = src;
        *tn = '\0';

        while(*++s);
        while(s>src && *--s != '/');
        if (s>src)
                while(src <= s) *t++ = *src++;
        strcpy(t, "untabXXXXX");
        mktemp(tn);
}


process()

/* This is the thing that reads lines from infil, converts leading   */
/* tab characters to blanks, and writes the lines to outfil.         */
{
        while (getline(infil) > 0) {
                putline(outfil);
        }
        fflush(outfil);
}


getline(infil)

/* Get the next line, expanding all leading tab characters to an     */
/* appropriate number of blanks.  Return the length.                 */

FILE *infil;
{
        register c;
        register char *l;
        int len, i, mode;

        l = &line[0];
        len  = 0;
        mode = 0;
        while ((c=getc(infil)) != EOF) {
                len++;
                if (len > MAXLINE-1) {
                        fprintf(stderr, "Max line length exceeded.\n");
                        cancel();
                }
                if (mode == 0)
                        if (c != ' ' && c != '\t')
                                mode = 1;

                if (c == '\t' && mode == 0) {
                        i = len + (8-(len-1)%8) - 1;
                        while (len < i) {
                                len++;
                                *l++ = ' ';
                        }
                        *l++ = ' ';
                }
                else {
                        *l++ = c;
                        if (c == '\n') break;
                }
        }
        if (len == 0)
                return(EOF); /* hit end of file */
        *l = '\0';
        return(len);
}



putline(outfil)

/* Now we can write the line out ... hurray ....  */

FILE *outfil;
{
        register char *l;

        l = &line[0];
        while (*l != '\0')
                putc(*l++, outfil);
}


cancel()
{
        fclose(outfil);
        unlink(tname);
        exit(1);
}
