#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include "save.h"

#define SOH             01
#define DEE             'd'             /* delta */
#define CEE             'c'             /* comment */
#define RMDEL           'R'             /* removed delta */

#define MAXLINE 512
/*
 *  structure for each file to be converted
 */
struct files {
	struct  files   *f_next;        /* ptr to next file */
	struct  delta   *f_delta;       /* ptr to delta info */
	char    f_sccs[16];             /* SCCS file name */
	char    f_save[16];             /* save file name */
};
/*
 *  structure for each release.level within the SCCS file
 */
struct delta {
	struct  delta   *i_next;        /* ptr to next delta */
	char    i_rel[10];              /* release.level */
	char    i_date[10];             /* date of change */
	char    i_time[10];             /* time of change */
	char    i_owner[10];            /* owner of change */
	struct  comment *i_cmt;         /* ptr to comments */
};

char    *temp = "sccsXXXXXX";
char    *malloc();
char    *tmp = "/tmp/sccsXXXXXX";
char    *tmp2 = "/tmp/sccsXXXXXX";
char    vflg;
char    fflg;
char    error;
struct  delta   *cdelta;
extern  struct  version *verhdr;
extern  char    *filestor;
extern  char    *cmdname;
/*
 *  Converts an SCCS file to a save file.
 */
main(argc, argv)
int     argc;
char    **argv;
{
	FILE    *fopen(), *fp;
	char    savename[16];
	struct  files   *f;
	struct  files   *fhdr = NULL;
	struct  stat    statb;

	argv++;
        freopen("/dev/null", "w", stdout);
        while (--argc) {
		if (strncmp(*argv, "s.", 2) != 0) {
			fprintf(stderr, "%s: not an SCCS file\n", *argv);
			error++;
			continue;
		}
		if ((fp = fopen(*argv, "r")) == NULL) {
			fprintf(stderr, "%s: unable to open\n", *argv);
			error++;
			continue;
		}
		strcpy(savename, *argv + 2);
		strcat(savename, SUFFIX);
		if (stat(savename, &statb) != -1) {
			fprintf(stderr, "%s: savefile already exists\n", savename);
			fclose(fp);
			error++;
			continue;
		}
		f = (struct files *) malloc(sizeof(struct files));
                strcpy(f->f_sccs, *argv);
                strcpy(f->f_save, savename);
		f->f_delta = NULL;
		f->f_next = fhdr;
		fhdr = f;
		deltas(f, fp);
                fclose(fp);
		argv++;
	}
	mktemp(temp);
	mktemp(tmp);
	for (f = fhdr; f != NULL; f = f->f_next)
		sccstosave(f);
	unlink(temp);
	exit(error);
}
/*
 *  sccstosave - make the conversion
 *  Do repeated get's and save's until all versions
 *  have been converted.
 */
sccstosave(f)
struct  files   *f;
{
	struct  delta    *i;
	char    cmd[MAXLINE];
	char    tempplus[16];
	struct  version *v, *nv;

	for (i = f->f_delta; i != NULL; i = i->i_next) {
		sprintf(cmd, "get -p -r%s %s > %s 2> /dev/null\n",
                        i->i_rel, f->f_sccs, temp);
		if (system(cmd) != 0) {
			fprintf(stderr, "get -p -r%s %s: failed\n",
                                i->i_rel, f->f_sccs);
			return;
		}
		cdelta = i;
		save(temp, 0);
		free(filestor);
		for (v = verhdr; v != NULL; v = nv) {
			nv = v->v_next;
			free((char *) v);
		}
        }
        strcpy(tempplus, temp);
        strcat(tempplus, SUFFIX);
        link(tempplus, f->f_save);
        unlink(tempplus);
}
/*
 *  deltas - get the pertinent information out of the sccsfile.
 */
deltas(f, fp)
struct files *f;
FILE *fp;
{
	char    line[MAXLINE];
	char    deltype[10];
	struct  delta   *i;
	struct  comment *c;
	struct  comment **cptr;

        fgets(line, sizeof(line), fp);
        while (line[0] == SOH) {
                switch(line[1]) {
                case DEE:
                        i = (struct delta *) malloc(sizeof(struct delta));
                        sscanf(&line[2], "%s %s %s %s %s",
                                deltype, i->i_rel, i->i_date,
				i->i_time, i->i_owner);
                        if (deltype[0] != RMDEL) {
                                i->i_next = f->f_delta;
                                f->f_delta = i;
                                i->i_cmt = NULL;
			}
                        cptr = &i->i_cmt;
                        break;
                case CEE:
                        c = (struct comment *) malloc(sizeof(struct comment));
                        c->c_next = NULL;
                        *cptr = c;
                        cptr = &c->c_next;
                        c->c_text = malloc(strlen(line) + 1);
                        strcpy(c->c_text, &line[3]);
                        break;
                }
                fgets(line, sizeof(line), fp);
        }
}
/*
 *  wrinfo - write the info line
 *  Write the owner and date associate with a delta.
 *  SCCS keeps the date in yy/mm/dd form.  Timec wants it
 *  in mm/dd/yy form, thus some weirdness.
 */
wrinfo(fp)
FILE    *fp;
{
	char    timebuf[25];
	char    *ctime();
	int     t;

	strcpy(timebuf, &cdelta->i_date[3]);
	strcat(timebuf, "/");
	strncat(timebuf, cdelta->i_date, 2);
	strcat(timebuf, " ");
	strcat(timebuf, cdelta->i_time);
	t = timec(timebuf, 0);
	fprintf(fp, "%c%c %s %s", CNTRLCHAR, INFO,
		cdelta->i_owner, ctime((time_t) t));
}
/*
 *  getcmt - get comments
 *  Feed save the comments extracted from the SCCS file.
 */
getcmt(fp)
FILE    *fp;
{
	struct comment *c;

	for (c = cdelta->i_cmt; c != NULL; c = c->c_next)
                fprintf(fp, "%c%c %s", CNTRLCHAR, CMT, c->c_text);
}
