#include <errno.h>
#include <stdio.h>
#include <ctype.h>

#define CMDLEN 132   /* Max command length allowed by CP. */

/*
 * CP commands.
 * Entire command line is passed to CP
 * and resulting CP output is displayed.
 * A list of valid commands is checked
 * against the command name so that a user
 * cannot link to this program with an unscrupulous
 * name like logoff.
 */

struct cmdlist {
	char *cmdstr;
	int cmdflg;
} cmdlist[] = {
        "q",        0,
	"qu",       0,
	"query",    0,
        "Q",        0,
	"QU",       0,
	"QUERY",    0,
        "ind",      0,
	"indicate", 0,
        "IND",      0,
	"INDICATE", 0,
        "autolog",  0,
	"AUTOLOG",  0,
	"mo",       1,
	"MO",       1,
	"mount",    1,
	"MOUNT",    1,
        0,          0,
};

extern char *cmdname;

char buf[CMDLEN];

main(argc, argv)
int argc;
char **argv;
{
        int i, fd, n, rc, uid, exit();
        extern errno;
        char c, *p, *q;
	struct cmdlist *cmdp;

	uid = getuid();
	if (uid == 0) {
		/*
		 * If command name is "cpcmd", only the arguments go to CP
		 */
		p = rindex(cmdname, '/');
		if (p)
			p++;
		else
			p = cmdname;
		if (strcmp(p, "cpcmd") == 0) {
			argv++;
			argc--;
		}
	} else {
                /*
                 * Check whether command is allowed.
                 */
                for (cmdp = cmdlist; cmdp->cmdstr; cmdp++)
                        if(strcmp(argv[0], cmdp->cmdstr) == 0)
                                break;
                if (cmdp->cmdstr == 0) {
                        printf("Sorry.\n");
                        exit(1);
                }
	}

	/*
	 * Gather command and parameters into buf.
	 */
        p = buf;
        for(i = 0; i < argc; i++) {
                q = *argv++;
                while((c = *q++) && (c != '\n')) {
                        if(islower(c))
				c = toupper(c);
                        *p++ = c;
			if (p >= &buf[CMDLEN]) {
				printf("%s: command too long.\n", cmdname);
				exit(1);
			}
                }
		if (c == '\n')
			break;
                *p++ = ' ';
		if (uid && cmdp->cmdflg)  /* no arguments in this case */
			break;
        }
	*p++ = '\n';
	/*
	 * Issue command.
	 */
        fd = vcfopen();
	n = p - buf;
        if (write(fd, buf, n) < 0)
		rc = errno;
        else
		rc = 0;
	/*
	 * Pass response back to user.
	 */
        while ((n = read(fd, buf, 512)) > 0)
                write(1, buf, n);
        if (rc)
                printf("%s: errno %d\n", cmdname, rc);
}

char vcf[] = "/dev/vcf0";
vcfopen()
{
        int fd;
	extern errno;

        do {
                fd = open(vcf, 2);
                vcf[8]++;
        } while(fd == -1 && errno == EBUSY);
        if(fd == -1) {
                printf("Try later.\n");
                exit(1);
        }
        return(fd);
}
