 /*
  * mvdir:  move directory
  *    mvdir srcdir dstdir
  *
  * This program must run with the set user id bit on.
  */

#include <sys/param.h>
#include <sys/stat.h>
#include <errno.h>
#include <stdio.h>
#define WRITEABLE 2

int errno;
char dpar[64], spar[96];
struct stat status;

main (argc,argv)
char **argv;
{
	int uid, gid;
	int sino, sdev;
	register char *p1, *p2, *p3;

	if (argc != 3)
		error("usage: mvdir src_dir dst_dir");

	uid = getuid();
	gid = getgid();

	if (stat(argv[2], &status) >= 0 || errno != ENOENT)
		error("the destination already exists");

	if (stat(argv[1], &status) < 0)
		error("the source directory does not exist");

	if (!(status.st_mode & S_IFDIR))
		error("the source is not a directory");

	sino = status.st_ino;
	sdev = status.st_dev;

	if (uid && (uid != status.st_uid))
		error("you are not the owner of the directory");

	/* Put the pathname of the destination's parent into dpar: */
	p1 = argv[2];
	p2 = dpar;
	p3 = p2;
	while (*p2 = *p1++)
		if (*p2++ == '/')
			p3 = p2;
	if (p3 == &dpar[0]) {
		/* Check for a move to the parent: */
		if(*p3++ == '.' && *p3++ == '.' && *p3 == 0)
			/* person is trying to create parent link, not a good idea */
			error("cannot create parent link\n\tserious error; contact Au support immediately!");
		dpar[0] = '.';
		dpar[1] = 0;
	} else if (p3 == &dpar[1]) {
		dpar[0] = '/';
		dpar[1] = 0;
	} else {
		*--p3 = 0;
	}

	if (access(dpar, WRITEABLE))
		/* Can't write in the parent directory of the proposed destination. */
		error("no write permission in the destination's parent");

	if (stat(dpar, &status) < 0 || status.st_dev != sdev)
		error("cannot move to a different file system");

	/* Refuse to move the current working directory: */
	if (stat(".", &status) < 0)
		error("cannot find current working directory.\n\tserious error; contact Au support immediately!");

	if (status.st_ino == sino && status.st_dev == sdev)
		error("cannot move current directory");
			/* actually that is not entirely true */

	/* Put the pathname of the source's parent into spar: */
	p1 = argv[1];
	p3 = spar;
	while (*p3++ = *p1++) ;
	*(p3-1) = '/';
	*p3++   = '.';
	*p3++   = '.';
	*p3     = 0;
	if (access(spar, WRITEABLE))
		error("no write permission in the source's parent");

	/* Check for a move into a child directory: */
	p1 = spar;  /* (Reuse source's parent as sequence of ancestors of dest) */
	p2 = dpar;
	while (*p1++ = *p2++) ;
	--p1;
	do {
		if (stat(spar, &status) < 0 || status.st_ino == sino)
			error("cannot move directory inside itself");
		*p1++ = '/';
		*p1++ = '.';
		*p1++ = '.';
		*p1 = 0;
	} while (status.st_ino != ROOTINO) ;

	/* Set spar to a pathname for the destination's parent: */
	p1 = spar;
	p2 = argv[2];
	while (*p1 = *p2++)
		p1++;
	*p1++ = '/';
	*p1++ = '.';
	*p1++ = '.';
	*p1 = 0;

	/* Do the actual moves: */
	if (link(argv[1], argv[2]) < 0 ||   /* make dest name refer to src      */
	    unlink(spar)	   < 0 ||   /* remove link to src's old parent  */
	    link(dpar, spar)       < 0 ||   /* add link to its new parent       */
	    unlink(argv[1])	< 0 )    /* the old src name no longer works */
		error("serious error in link or unlink!\n\tContact Au support immediately!");
}

error(message)
char *message;
{
	fprintf(stderr, "mvdir:  %s\n", message);
	exit(1);
}
