/*
 * ss - text formatting document preparation system
 */

#include <stdio.h>
#include <signal.h>

#define ABSENT   0
#define PRESENT  1
#define NAMED    2
#define NUMERIC  '0'
#define EMPTY    '\0'
#define READABLE 4
#define YES      0

int  a;
int  p;
int  crt     = 1;
int  debug   = 0;
int  ssflag  = 0;
int  msflag  = 0;
int  nopr_flag  = 0;
char *cmdname;
char *arg;
char class;
char *save_arg;
char *this_arg;
char number  [ 30] = "";
char command [999] = "";
char cmnd    [990] = "";
char T_table [ 20] = "";
char r_option[ 20] = "";
char range   [ 20] = "";
char e_option[ 20] = "";
char file    [900] = "";
char name    [100] = "";
char swap    [ 20] = "";
char prf     [ 40] = " | tprf -o-6";
char prf1    [ 20] = "";
char prf2    [ 20] = "";
char T_name  [ 20] = "";
int  pitch           = 10;
int  T_option        = ABSENT;
int  nohup           = ABSENT;

main(argc,argv)
int argc;
char *argv[];
{
	cmdname = argv[0];
	if (strcmp(cmdname, "mm") != 0) {
		ssflag++;
		if (strcmp(cmdname, "ss") != 0) {
			msflag++;
		}
	}
	get_args(argc, argv);
	get_cmnd();

	if (debug)
		fprintf(stderr, "%s\n", command);
	else if (nohup)
		if (fork())
			exit(0);
		else
			exit(system(command));
	else
		exit(system(command));
}

get_args(argc, argv)
int argc;
char *argv[];
{
	for (a=1; a<argc; a++) {
		this_arg = argv[a];
		arg = this_arg;
		get_arg();
		switch (class) {
		case '-':
			dash_opt();
			break;
		case NUMERIC:
			if (range[0] != EMPTY) {
				incomp(2);
			}
			if (ssflag) {
			        strcat(range, " -r91");
			}
			strcat(range, " -o");
			strcat(range, argv[a]);
			get_arg();
			switch (class) {
			case '-':
				get_arg();
				switch (class) {
				case NUMERIC:
					if (*arg != EMPTY) {
						bad_arg();
					}
					break;
				case EMPTY:
					break;
				default:
					bad_arg();
				}
				break;
			case EMPTY:
				break;
			default:
				bad_arg();
			}
			break;
		default:
			if (access(arg-1, READABLE) != YES) {
				bad_file(arg-1);
			}
			if (file[0] == EMPTY) {
				strcpy(name, " -n ");
				strcat(name, arg-1);
			} else {
				strcat(file, " ");
			}
			strcat(file, arg-1);
		}
	}
}

dash_opt()
{
	get_arg();
	switch (class) {
	case 'D':
		if (*arg != EMPTY) {
			bad_arg();
		}
		debug++;
		break;
	case 'T':
		if (*arg == EMPTY) {
			T_option = PRESENT;
		} else {
			T_option = NAMED;
			strcpy(T_name, " -T");
			strcat(T_name, arg);
		}
		break;
	case 'Q':
		if (crt--) {
			nohup = ABSENT;
			pitch = 12;
			strcpy(T_table, " -Tq3270");
			strcpy(e_option, " -e");
			strcpy(swap, " | /usr/lib/ss/swap");
			strcpy(prf, " | tprf");
			strcpy(prf1, " -w102 -o-11");
			strcpy(prf2, "");
			get_arg();
			switch (class) {
			case EMPTY:
				break;
			default:
				bad_arg();
			}
		} else {
			incomp(1);
		}
		break;
	case 'i':
		if (ssflag) {
			if (range[0] != EMPTY) {
				incomp(2);
			}
			if (*arg != EMPTY) {
				bad_arg();
			}
			strcpy(range, " -o999-");
		} else {
			bad_arg();
		}
		break;
	case 'c':
		if (crt--) {
			c_opt();
		} else {
			incomp(1);
		}
		break;
	case 'e':
		if (crt--) {
			e_opt();
		} else {
			incomp(1);
		}
		break;
	case 'p':
		if (crt--) {
			p_opt();
		} else {
			incomp(1);
		}
		break;
	case 'q':
		if (crt--) {
			q_opt();
		} else {
			incomp(1);
		}
		break;
	case 'r':
		if (ssflag) {
			if (*arg != EMPTY) {
				bad_arg();
			}
			strcpy(r_option, " -r81");
		} else {
			bad_arg();
		}
		break;
	case EMPTY:
		if (range[0] != EMPTY) {
			incomp(2);
		}
		if (ssflag) {
		        strcat(range, " -r91");
		}
		break;
	case NUMERIC:
		if (range[0] != EMPTY) {
			incomp(2);
		}
		if (ssflag) {
		        strcat(range, " -r91");
		}
		strcat(range, " -o-");
		strcat(range, number);
		if (*arg != EMPTY) {
			bad_arg();
		}
		break;
	default:
		bad_arg();
	}
}

c_opt()
{
	nohup = ABSENT;
	pitch = 10;
	strcpy(T_table, " -Tcom");
	strcpy(e_option, "");
	strcpy(swap, " | /usr/lib/ss/swap");
	strcpy(prf, " | cprf");
	strcpy(prf1, "");
	strcpy(prf2, "");
	get_arg();
	if (class != EMPTY)
		bad_arg();
}

e_opt()
{
	nohup = PRESENT;
	pitch = 10;
	strcpy(T_table, " -Te1pr");
	strcpy(e_option, "");
	strcpy(swap, " | /usr/lib/ss/swap");
	strcpy(prf, " | oprf | e1opr");
	strcpy(prf1, "");
	strcpy(prf2, "");
	get_arg();
	while (class != EMPTY) {
		switch (class) {
		case 'q':
			pitch = 12;
			strcpy(T_table, " -Tqline");
			strcpy(e_option, " -e");
			break;
		case 'n':
			nopr_flag++;
			strcpy(prf, " | oprf");
			break;
		case NUMERIC:
			if (strcmp(number, "1") != 0) {
				strcpy(prf2, " -p ");
				strcat(prf2, number);
			}
			break;
		default:
			bad_arg();
		}
		get_arg();
	}
}

p_opt()
{
	nohup = PRESENT;
	pitch = 10;
	strcpy(T_table, " -Ttn");
	strcpy(e_option, "");
	strcpy(swap, " | /usr/lib/ss/swap");
	strcpy(prf, " | oprf | opr");
	strcpy(prf1, " -c u");
	strcpy(prf2, "");
	get_arg();
	while (class != EMPTY) {
		switch (class) {
		case 'q':
			pitch = 12;
			strcpy(T_table, " -Tqline");
			strcpy(e_option, " -e");
			strcpy(prf1, "");
			break;
		case 'n':
			nopr_flag++;
			strcpy(prf, " | oprf");
			break;
		case 'g':
			strcpy(prf1, "");
			break;
		case 'w':
	                strcpy(prf1, " -c u");
			break;
		case NUMERIC:
			if (strcmp(number, "1") != 0) {
				strcpy(prf2, " -p ");
				strcat(prf2, number);
			}
			break;
		default:
			bad_arg();
		}
		get_arg();
	}
}

q_opt()
{
	nohup = ABSENT;
	pitch = 12;
	strcpy(T_table, " -Tq12");
	strcpy(e_option, " -e");
	strcpy(swap, " | /usr/lib/ss/swap");
	strcpy(prf, " | qprf");
	strcpy(prf1, "");
	strcpy(prf2, "");
	get_arg();
	switch (class) {
	case NUMERIC:
		q_number();
		break;
	case EMPTY:
		break;
	default:
		bad_arg();
	}
}

q_number()
{
	if (strcmp(number, "10") == 0) {
		pitch = 10;
		strcpy(T_table, " -Tq10");
		strcpy(prf2, " -h10");
	} else if (strcmp(number, "12") != 0) {
		bad_arg();
	}
	if (*arg != EMPTY) {
		bad_arg();
	}
}

get_arg()
{
	save_arg = arg;

	p = 0;
	while ('0'<=arg[0] && arg[0]<='9') {
		number[p] = arg[0];
		arg++;
		p++;
	}
	number[p] = '\0';

	if (arg == save_arg) {
		class = arg[0];
		arg++;
	} else {
		class = '0';
	}
}

get_cmnd()
{
	if (file[0] == EMPTY) {
		if (isatty(fileno(stdin))) {
			no_file();
		} else {
			strcpy(file, "");
			strcpy(name, " -n ");
			strcat(name, cmdname);
		}
	}
	if (range[0] != EMPTY) {
		strcpy(swap, "");
	}
	if (T_option == ABSENT && !nopr_flag) {
		strcat(prf, prf1);
		strcat(prf, prf2);
		if (nohup == PRESENT) {
			strcat(prf, name);
		}
	} else {
		nohup = ABSENT;
		if (T_option == NAMED) {
			strcpy(T_table, T_name);
		}
	}
	
	strcpy(cmnd, "/usr/lib/ss/press ");
	if (pitch != 10)
		sprintf(cmnd, "%s-p%d ", cmnd, pitch);
	strcat(cmnd, file);
	strcat(cmnd, " | tbl");
	if (strlen(e_option) == 0)
		strcat(cmnd, " -TX");
	strcat(cmnd, " | nroff");
	strcat(cmnd, T_table);
	if (ssflag) {
	        strcat(cmnd, r_option);
	}
	strcat(cmnd, range);
	strcat(cmnd, e_option);
	if (!ssflag) {
	        strcat(cmnd, " -mm");
	} else if (!msflag) {
	        strcat(cmnd, " -ms");
	} else {
	        strcat(cmnd, " -m");
	}
	if (ssflag) {
	        strcat(cmnd, swap);
	}
	strcat(cmnd, prf);
	strcpy(command, "");
	signal(SIGPIPE, SIG_IGN);
	if (nohup == PRESENT) {
		signal(SIGHUP,  SIG_IGN);
		signal(SIGINTR, SIG_IGN);
		signal(SIGQUIT, SIG_IGN);
	} else {
		if (crt && isatty(fileno(stdout))) {
			strcat(command, "ascii ff; ");
		}
	}
	strcat(command, cmnd);
}

bad_arg()
{
	fprintf(stderr, "%s:  invalid option:  %s\n", cmdname, this_arg);
	usage();
}

bad_file(name)
char *name;
{
	fprintf(stderr, "%s:  cannot access file `%s\'\n", cmdname, name);
	exit(1);
}

no_file()
{
	fprintf(stderr, "%s:  no source file(s) specified\n", cmdname);
	usage();
}

incomp(sw)
int sw;
{
	switch (sw) {
	case 1:
		fprintf(stderr, "%s:  only one device option (-c, -e, -p, -q, -Q) allowed\n", cmdname);
		break;
	case 2:
		fprintf(stderr, "%s:  only one range of pages or -i option allowed\n", cmdname);
		break;
	}
	usage();
}

usage()
{
	fprintf (stderr, "usage:  %s [option ...] file ... \n", cmdname);
	fprintf (stderr, "   or:  command | %s [option ...]\n", cmdname);
	fprintf (stderr, "where option is one of:\n");
	fprintf (stderr, "        [start page]-[stop page]\n");
	if (ssflag)
	        fprintf (stderr, "        -i\n");
	fprintf (stderr, "        -c\n");
	fprintf (stderr, "        -e[q][n][copies]\n");
	fprintf (stderr, "        -p[q][n][g][w][copies]\n");
	fprintf (stderr, "        -q[pitch]\n");
	fprintf (stderr, "        -Q\n");
	if (ssflag)
	        fprintf (stderr, "        -r\n");
	fprintf (stderr, "        -D\n");
	exit(1);
}
