/*
 * symbol table routines
 */

#include <stdio.h>
#include "sym.h"
#include "opcodes.h"
#include "assem.h"

/*
 * hash macro takes a name string
 * and changes the variable h to the hash value,
 * len has the string length
 * h should be declared as an unsigned
 */

#define hash(cp) {\
	register char *p;\
\
	h = 0;\
	for (p = cp; *p != '\0'; p++)\
		h = (h << 7)+(*p);\
	h %= HSHSIZ;\
	len = p-cp;\
	}

static int nsym, insf;
static SYM *hashp[HSHSIZ];
static SYM *ordsym[HSHSIZ];

#include "defsym.c"
#include "opcodes.c"

SYM *lookup(name, class)
char *name;
char class;{

	register unsigned int h;
	register SYM *s;
	int len;

	insf = 0;
	hash(name);
	for (s = hashp[h]; s != NULL; s = s->s_chain) {
		if (s->s_class==class && strcmp(s->s_name, name)==0)
			break;
		}
	return(s);
	}

SYM *insert(name)
char *name;{

	register unsigned h;
	register SYM *s, *ns;
	char *space, *np, *malloc();
	int len;

	insf = -1;
	hash(name);
	space = malloc(sizeof(SYM)+len+1);
	ns = &space[0];
	np = &space[sizeof(SYM)];
	s = hashp[h];
	hashp[h] = ns;
	ns->s_chain = s;
	strcpy(np, name);
	ns->s_name = np;
	return(ns);
	}

/*
 * delete a symbol (this should eventually disappear)
 */

deletesym(name)
char *name;{

	register unsigned h;
	register SYM *s;
	SYM *lasts;
	int len;

	if (!insf) return;
	insf = 0;
	hash(name);
	lasts = NULL;
	for (s = hashp[h]; s != NULL; lasts = s, s = s->s_chain)
		if (s->s_class==USYM && strcmp(s->s_name, name)==0)
			break;
	if (s == NULL) return;
	if (lasts == NULL) hashp[h] = s->s_chain;
	else lasts->s_chain = s->s_chain;
	free(s);
	ordsym[--nsym] = NULL;
	}

SYM *usersym(name, type, val, len)
char *name;
short type;
int val, len;{

	register SYM *s;

	if (nsym >= HSHSIZ)
		error(1, "too many symbols");
	s = insert(name);
	s->s_class = USYM;
	s->s_type = type;
	s->s_val = val;
	s->s_len = len;
	ordsym[nsym] = s;
	s->s_symno = nsym++;
	return(s);
	}

/*
 * turn a predefined symbol into a true user symbol
 * true in the sense that it will get dumped in the symbol table
 */

mkusym(s)
register SYM *s;{

	if (nsym >= HSHSIZ)
		error(1, "too many symbols");
	ordsym[nsym] = s;
	s->s_symno = nsym++;
	}

/*
 * initialize the symbol table with opcodes and predefined symbols
 */

syminit() {

	register SYM *s, *t;
	SYM *last;

	last = &opcode[sizeof(opcode)/sizeof(SYM)];
	for (s = &opcode[0]; s < last; s++) {
		t = insert(s->s_name);
	        t->s_class = OPCODE;
		t->s_type = s->s_type;
		t->s_val = s->s_val;
		}
	last = &defsym[sizeof(defsym)/sizeof(SYM)];
	for (s = &defsym[0]; s < last; s++) {
		t = insert(s->s_name);
		t->s_class = s->s_class;
	        t->s_type = s->s_type;
		t->s_val = s->s_val;
	        t->s_len = 0;
		t->s_symno = -1;
		}
	symfil = memopen("symfil", "w");
	}

/*
 * dump the symbol table in order to a.out file
 */

dumpsym() {

	register SYM *s;
	register int n, i;
	register char *p;

	if (sflag) {   /* new symbol table */
		int total;
		char *buf;

		memreopen(symfil, "r");
		buf = malloc(BUFSIZ);
		total = 0;
		while ((n = fread(buf, 1, BUFSIZ, symfil)) > 0) {
			fwrite(buf, 1, n, outfil);
			total += n;
			}
		return((total+7)/8*8);  /* round to double word */
		}
	for (n = 0; n < nsym; n++) {
		s = ordsym[n];
		i = s->s_type & LOCAL;
		if (i > TEXTSEG){
			s->s_val += oseek[i-TEXTSEG]-oseek[0];
			if (s->s_len < 0)
				s->s_len = size[i-TEXTSEG];
			if (i > BSSSEG)
				s->s_type = (s->s_type&EXTERN)|TEXTSEG;
			}
		else if (s->s_type == EXTERN+UNDEFINED)
			s->s_val = s->s_len;
		for (p = s->s_name; *p!='\0' && p < s->s_name+NAMESIZE; )
			putc(*p++, outfil);
		while (p++ < s->s_name+NAMESIZE) putc('\0', outfil);
		putw(s->s_type, outfil);
		putw(s->s_val, outfil);
		}
	return(nsym*(NAMESIZE+2*sizeof(int)));
	}
