/*
 * defines for assembler scanner
 * note this header file assumes "sym.h" has been previously included
 */
 
#define SYMSTART 01000
#define USYMSTART 05000

#ifndef LINESIZE
#define LINESIZE 256
#endif

#ifndef LOCSYM
#define LOCSYM '~'
#endif
 
typedef struct token {
/*      double t_dval;    no floating point today */
	int t_state;
	SYM *t_sym;
	int t_val;
	char t_name[LINESIZE];
	int t_namep;
	} TOKEN;
 
/*
 * character types
 */
 
#define END 0
#define ALPH 1
#define DIGIT 2
#define DOT 3
#define SQ 4
#define COLON 5
#define SEMI 6
#define SLASH 7
#define BLANK 8
#define OTHER 9
#define UNKN 11
 
/*
 * symbol types
 */
 
#define START 257
#define ID 258
#define DIG 259
#define ABS 260
#define NUM 261
#define BIN 270
#define HEX 271
#define CHAR 272
#define COM 273
#define FQ 274
#define DQ 275
#define HQ 276
#define ADOT 277
#define LQ 278
 
/*
 * special characters
 */
 
#define SQS 3
#define NEWLINE '\n'
#define BACKSLASH '\\'
#define TAB 011
#define RETURN 015
#define BACKSPACE 010
 
/*
 * globals
 */
 
char **curarg;
int nargs;
int lineno;
int errflg;
int peekchar;
FILE *infil;
FILE *txtfil;
int lntype, prtype, ready, comment, printc, listflg;  /* for listing */
TOKEN curtoke;

#define nextchar()      (listflg ? outchar(getc(infil)) : getc(infil))
