/*
 * numeric label handling
 */

#include <stdio.h>
#include "numlab.h"

static NLAB *nlabhead, *nlabtail;

fbmiddle() {

	register int i, j;
	register NLAB *p;

	memreopen(fbfil, "r");
	while ((i = getc(fbfil)) != EOF) {
		if (i == 10) {
		/*
		 * 10 is not a legal numeric label, rather it signifies
		 * that some previously seen labels need alignment
		 * next byte in input tells how many labels, following word
		 * contains value to which they must be aligned
		 */
			i = getc(fbfil);
			j = getw(fbfil);
			for (p = nlabtail; p!=NULL && i-- > 0; p = p->nlab_last)
				p->nlab_addr = j;
			}
		else {
			j = getc(fbfil);
			addlist(i, j, getw(fbfil));
			}
		}
	memclose(fbfil);
	for (i = 0; i < 10; i++) {
		for (p = nlabhead; p != NULL; p = p->nlab_next) {
			if (p->nlab_num == i){
				nxtfb[i].fb_rel = p->nlab_seg;
				nxtfb[i].fb_addr = p->nlab_addr;
				break;
				}
			}
		}
	}

/*
 * found a numeric label, 'f's are in nxtfb[], 'b's in curfb[]
 */

fbadv(n)
register int n;{

	register NLAB *p;

	move((char *)&nxtfb[n], (char *)&curfb[n], sizeof(struct fb));
	nlabhead = nlabhead->nlab_next;
	for (p = nlabhead; p != NULL; p = p->nlab_next) {
		if (p->nlab_num == n){
			nxtfb[n].fb_rel = p->nlab_seg;
			nxtfb[n].fb_addr = p->nlab_addr;
			return;
			}
		}
	nxtfb[n].fb_rel = 0;
	}

static addlist(num, seg, addr)
char num, seg;
int addr;{

	register NLAB *p;

	p = (NLAB *) malloc(sizeof(NLAB));
	p->nlab_num = num;
	p->nlab_seg = seg;
	p->nlab_addr = addr;
	if (nlabhead == NULL) {
		nlabhead = p;
		p->nlab_next = NULL;
		p->nlab_last = NULL;
		}
	else {
		p->nlab_next = NULL;
		p->nlab_last = nlabtail;
		nlabtail->nlab_next = p;
		}
	nlabtail = p;
	}
