	user
	pagetab
	entry	sbreak1,freesgs,protect,grow1,copysgs
	entry	zeropag,copypag
	gbla	&fnum
	eject
sbreak1	startup
sbreak1	prolog	4	0 args
	l	r7,=v(u)		find u pointer
	l	r7,0(,r7)		address u struct
	using	user,r7			tell assembler
	l	r2,ss$&fnum+0(r12)	load amount to be added to data
	ltr	r2,r2			is it positive?
	bl	less			no, branch
	using	pagetab,r3
*
*	The following code finds the end of the current
*	string of page tables, so we know where to add more.
*
more	l	r3,udpages
morelp	ltr	r3,r3			any more pagetabs
	bz	nomore			no, branch
	sr	r4,r4			zero count
morent	lh	r5,ptinfo(r4)		load page entry
	n	r5,=a(ptimask)		look at invalid bit
	ltr	r5,r5			is it set?
	bnz	addmore			yes, branch
	la	r4,2(,r4)		bump page entry index
	c	r4,=f'30'		last one?
	bnh	morent			no, branch
	l	r3,ptnext		yes, get next pagetab
	b	morelp			branch back
*
*	Loop to add pages, decreasing the amount (r2) by one
*	each time until we hit zero.
*
addmore	l	r15,=v(getpage)		prepare to getpage
	balr	r14,r15			call getpage
	srl	r0,8			shift page addr to 16 bits
	sth	r0,ptinfo(r4)		stuff in the page table
	bct	r2,incmore		decrement count, br > 0
	b	return			if zero, return
incmore	la	r4,2(,r4)		bump page entry index
	c	r4,=f'30'		last one?
	bnh	addmore			no, branch
nomore	l	r15,=v(getptab)		yes, get another pagetab
	balr	r14,r15			call getptab
	ltr	r3,r3			any pagetabs already?
	bz	ptab1			no, branch
	st	r0,ptnext		yes, link in new one
	b	$1			forward
ptab1	st	r0,udpages		first, so store in u_dpages
$1	lr	r3,r0			point to it
	sr	r4,r4			zero entry index
	b	addmore			go add some more pages
*
*	The amount of pages to be added was negative, so
*	find how many pages will remain and remove all
*	pages beyond that point.
*
less	a	r2,udsize		find # of pages
	l	r3,udpages		point at first data pagetab
lesslp	ltr	r3,r3			any more pagetabs?
	bz	return			no, branch
	c	r2,=f'16'		more than 1 table left?
	bnl	nextpt			yes, branch
	sll	r2,1			* 2 for index
	b	frepag			start freeing pages
nextpt	l	r3,ptnext		get next pagetab
	s	r2,=f'16'		decrement page count
	b	lesslp			branch back
freelp	l	r3,ptnext		get next pagetab
	ltr	r3,r3			any more pagetabs?
	bz	return			no, return
frepag	lh	r4,ptinfo(r2)		get page entry
	n	r4,=a(ptamask)		look at the addr
	sll	r4,8			make 24 bit addr
	ltr	r4,r4			is it zero?
	bz	skip			yes, don't free it
	st	r4,0(SP)		store it as argument
	l	r15,=v(freepag)		prepare to free page
	balr	r14,r15			call freepag
	l	r4,=a(ptimask)		load invalid entry model
	sth	r4,ptinfo(r2)		mark entry as invalid
skip	la	r2,2(,r2)		increment entry index
	c	r2,=f'30'		last one?
	bnh	frepag			no, branch
	b	freelp			yes, go to next table
return	epilog	64
	eject
*
*	Free an entire chain of pages and page tables.
*
	space
	drop
freesgs	prolog	4 	1 arg
	l	r2,ss$&fnum+0(R12)	pointer to chain to be freed
loop	ltr	r2,r2			any pagetabs left?
	bz	none			no, branch
	using	pagetab,r2		address page table
	sr	r3,r3			zero entry index
free	lh	r4,ptinfo(r3)		load page entry
	lr	r5,r4			save for posterity
	n	r4,=a(ptimask)		extract invalid bit
	ltr	r4,r4			is it invalid?
	bnz	inv			yes, branch
	n	r5,=a(ptamask)		extract address
	ltr	r5,r5			is it zero?
	bz	inv			yes, branch
	sll	r5,8			make real address
	st	r5,0(sp)		pass as argument
	l	r15,=v(freepag)		prepare to free page
	balr	r14,r15			call freepag
inv	la	r3,2(,r3)		bump entry index
	c	r3,=f'30'		last one?
	bnh	free			no, branch
	l	r3,ptnext		yes, remember next table
	st	r2,0(sp)		store pagetab addr as arg
	l	r15,=v(freptab)		prepare to call freptab
	balr	r14,r15			call freptab
	lr	r2,r3			point at next pagetab
	b	loop			go free it
none	epilog	64			say goodbye
	eject
*
*	Protect a chain of pages by setting their protect keys
*	to a given value.
*
	drop
protect	prolog	0	2 args
	l	r2,ss$&fnum+0(r12)	load pointer to chain
	l	r7,ss$&fnum+4(r12)	load protect key value
	sll	r7,4			shift into proper position
ploop	ltr	r2,r2			any pages remaining?
	bz	nope			no, branch
	using	pagetab,r2		establish addr for pagetab
	sr	r3,r3			zero entry index
setkey	lh	r4,ptinfo(r3)		load page entry
	lr	r5,r4			save for posterity
	n	r4,=a(ptimask)		extract invalid bit
	ltr	r4,r4			is it set?
	bnz	pinv			yes, branch
	n	r5,=a(ptamask)		extract address
	ltr	r5,r5			is it zero?
	bz	pinv			yes, branch
	sll	r5,8			make real addr
	ssk	r7,r5			set key on first 2k
	la	r5,2048(,r5)		add 2048
	ssk	r7,r5			set key on second 2k
pinv	la	r3,2(,r3)		point to next page entry
	c	r3,=f'30'		last one?
	bnh	setkey			no, branch
	l	r2,ptnext		point at next pagetab
	b	ploop			go set its keys
nope	epilog	64
	eject
*
*	Grow the stack by adding r2 pages to the bottom.
*
	drop
grow1	prolog	4	1 arg
	l	r2,ss$&fnum+0(r12)	load amount to be grown
	l	r7,=v(u)		find u pointer
	l	r7,0(,r7)		address u struct
	using	user,r7			tell assembler
	l	r3,uspages		load pointer to stack chain
	using	pagetab,r3		establish addr
	ltr	r3,r3			any there?
	bz	create			no, branch
trundle	l	r4,ptnext		get pointer to next pagetab
	ltr	r4,r4			is it zero?
	bz	fndlast			yes,branch
	lr	r3,r4			trundle down the chain
	b	trundle			branch back
fndlast	la	r4,30			load entry index
findlp	lh	r5,ptinfo(r4)		load page entry
	n	r5,=a(ptimask)		look at invalid bit
	ltr	r5,r5			is it set?
	bnz	grow			yes, branch
	s	r4,=f'2'		look at previous entry
	bnm	findlp			branch back if there
create	l	r15,=v(getptab)		prepare to get pagetab
	balr	r14,r15			branch to getptab
	ltr	r3,r3			did prev pagetab exist?
	bz	$2
	st	r0,ptnext		link in this pagetab
	b	$3
$2	st	r0,uspages		store where we can find it
$3	lr	r3,r0			point at new pagetab
	la	r4,30			load entry index
grow	l	r15,=v(getpage)		prepare to get page
	balr	r14,r15			call getpage
	srl	r0,8			shift for pagetab format
	sth	r0,ptinfo(r4)		store in pagetab
	bct	r2,moregr		dec page count & branch
	b	growret			go away happy
moregr	s	r4,=f'2'		point at prev entry
	bnm	grow			branch if there
	b	create			get pagetab if not
growret	epilog	64
	eject
*
*	Copy one chain of pages to another.
*
next	equ	ptnext-pagetab
info	equ	ptinfo-pagetab
	drop
copysgs	prolog	8	2 args
	lm	r3,r4,ss$&fnum+0(r12)	load from & to pointers
ptlp	ltr	r3,r3			any to copy?
	bz	quit			no, quit
	sr	r5,r5			zero entry index
copylp	lh	r6,info(r5,r3)		load from entry
	lr	r7,r6			save for posterity
	n	r6,=a(ptimask)		extract invalid bit
	ltr	r6,r6			is it set?
	bnz	nocopy			yes, don't copy it
	lh	r6,info(r5,r4)		load to entry
	n	r6,=a(ptamask)		mask addr
	sll	r6,8			shift to to 24 bits
	sll	r7,8			shift from to 24 bits
	st	r7,0(,sp)		store arg 1
	st	r6,4(,sp)		store arg 2
	l	r15,=v(copypag)		prepare to copy page
	balr	r14,r15			call copypag
nocopy	la	r5,2(,r5)		point at next entry
	c	r5,=f'30'		is it last one?
	bnh	copylp			no, branch
	l	r3,next(,r3)		get next from pagetab
	l	r4,next(,r4)		get next to pagetab
	b	ptlp			branch back
quit	epilog	64
	eject
*
*	Zero an entire page.
*
	drop
zeropag	prolog	0	1 arg
	l	r2,ss$&fnum+0(r12)	load addr of page
	l	r3,=f'4096'		load length of page
	sr	r4,r4			no second addr for mvcl
	sr	r5,r5			zero length
	mvcl	r2,r4			pad page with zeroes
	epilog	64			go away
	space 5
*
*	Copy one page to another.
*
	drop
copypag	prolog	0	2 args
	l	r2,ss$&fnum+4(r12)	"to"
	l	r4,ss$&fnum+0(r12)	"from"
	l	r3,=f'4096'		page length
	lr	r5,r3			for both pages
	mvcl	r2,r4			copy
	epilog	64			go away
	end
