/*	pro 350 access code generator
 *		March 29, 1984
 ****************************************************************
 *								*
 *	All rights reserved:	VENTURCOM INC.	1984		*
 *								*
 *	This source listing is supplied in accordance with	*
 *	the Software Agreement you have with VenturCom.		*
 *								*
 ****************************************************************
 *
 * CONFIDENTIAL: PROPRIETARY TO VENTURCOM, INC.
 *
 * proacc - VENIX/PRO access program: generate access number for
 *	    user installation
 * define VAX for 4.2BSD on VAX
 */

#include <ctype.h>

char buf[120];
#define SCRAM (17*17)	/* seed constant */
#define ISMULTI 0400	/* bit set in second part of machine ID to indicate */
			/* that distribution is multi-user */

#ifdef VAX
typedef unsigned short int ushort;
#else
typedef unsigned int ushort;
#endif
ushort scram1(), scram2();

main(){
	register char *p;
	ushort sn, j, k;
	ushort multiflag;
	char *p1;

	printf("VENIX/PRO Access Program\n");
	
startagain:
	while (1){
		printf("\nSoftware ID Number? ");
		gets(buf);
		for (p = buf; *p && !isdigit(*p); ++p)
			;
		if (*p == 0 || (sn = atoi(p)) == 0)
			printf("Invalid number\n");
		else
			break;
	}

	while (1){
		printf("Machine ID Number? ");
		gets(buf);
		for (p = buf; *p && !isdigit(*p); ++p)
			;		/* skip leading non-numeric chars */
		if (*p == 0)
			goto bad;

		p1 = p;			/* start of first half */
		while (isdigit(*p))
			++p;
		if (*p == 0)
			goto bad;
		*p = 0;
		j = atoi(p1);

		for (++p ; *p && !isdigit(*p); ++p)
			;		/* skip leading non-numeric chars */
		if (*p == 0)
			goto bad;
		p1 = p;			/* start of second half */
		while (isdigit(*p))
			++p;
		*p = 0;
		k = atoi(p1);
		break;

	bad:
		printf("Invalid: enter number in form `#####-#####'\n");
	}

	multiflag = k & ISMULTI;
	if ((k & ~ISMULTI) != (scram1(j,j*sn,sn) & ~ISMULTI)){
	   printf("Invalid entry - please recheck and try again\n");
	   goto startagain;
	}
	if (multiflag)
		printf("(multi-user)\n");	
	else
		printf("(1-2 user)\n");

		printf("Access code is %05u\n",
			   scram2(j,j*SCRAM,SCRAM) ^ sn ^ multiflag);
}

ushort scram1(a, b, c)
register ushort a,b,c;
{
	ushort d;

	d = c+a+b;
        while (d){
                switch(d & 03){
                case 0: a += b;
                        break;

                case 1: a *= b;
                        break;

                case 2: b = a^c;
                        break;

                case 3: b = a+c;
                        break;
                }
                d >>= 1;
		c += (a ^ b);
        }
	return(a ^ b);
}

ushort scram2(a, b, c)
register ushort a,b,c;
{
	ushort d;

	d = c+a+b;
        while (d){
                switch(d & 03){
                case 3: a += b;
                        break;

                case 2: a *= b;
                        break;

                case 1: b = a^c;
                        break;

                case 0: b = a+c;
                        break;
                }
                d >>= 1;
		c += (a ^ b);
        }
	return(a ^ b);
}
