/*
 * RAT - Read A Tape.
 * Small tool found with the Ultrix-11 V3.0 binary kit in the PUPS
 * archive.  Basically, reads a tape, writes its contents in a dump
 * file, and also writes down the block size of each block, in a
 * separate log file.  With these two files, one can later rewrite
 * the tape on new media.
 *
 * I only added stuff and cleaned up the code so it would run on the
 * PDP-11 again.  --Fred van Kempen 2001/03/04.
 */
#include <stdio.h>

#define MAX_BLK	32
#define BLK_SIZE 512

int blocksize = BLK_SIZE;
int notreally = 0;


main (argc,argv)
  int argc ;
  char ** argv ;
{
        register int fd, bytes, eof ;
        FILE * ofd ;
        char * buffer ;
	char * tapefile ;
        extern char * malloc() ;

        blocksize *= MAX_BLK;
        buffer = malloc(blocksize);

	tapefile = argv[1];
	if (! strcmp(tapefile, "-n")) {
		notreally = 1;
		tapefile = argv[2];
	}

        if ( ( fd = open (tapefile,0) ) < 0 )
        {
                fprintf (stderr,"%s: can't open tape file\n", argv[0]) ;
                exit (1) ;
        }

	if (! notreally) {
        	if ( ( ofd = fopen ("./tapedump","a") ) == NULL ) {
                	perror ("./tapedump") ;
                	exit (1) ;
		}
        }

        for ( eof = 0 ; ; )
        {
                bytes = read (fd,buffer,blocksize) ;

                if ( bytes == 0 )
                {
                        if ( eof++ > 0 )
                        {
                                printf ("EOT\n") ;
                                break ;
                        }

                        printf ("EOF\n") ;
                }
                else
                        if ( bytes < 0 )
                        {
                                printf ("I/O-ERROR\n") ;
                        }
                        else
                        {
                                printf ("%d\n",bytes) ;
                                eof = 0 ;

				if (! notreally) {
                                	if ( fwrite (buffer,1,bytes,ofd) != bytes )
                                        fprintf (stderr,"write error\n") ;
				}
                        }
        }

        (void) close (fd) ;
        if (! notreally)
		(void) fclose (ofd) ;

        exit (0) ;
}
