/***************************************************************************
 *   Copyright (C) 2005 by Alexander Dymo                                  *
 *   adymo@kdevelop.org                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU Library General Public     *
 *   License along with this program; if not, write to the                 *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/
#include "viewer.h"

#include <tqdir.h>
#include <tqlineedit.h>
#include <tqlistbox.h>
#include <tqfiledialog.h>
#include <tqtextedit.h>
#include <tqfile.h>
#include <tqtextstream.h>
#include <tqlistview.h>
#include <tqtabwidget.h>

#include <autotoolsast.h>
#include <autotoolsdriver.h>

using namespace AutoTools;

Viewer::Viewer(TQWidget *parent, const char *name)
    :ViewerBase(parent, name)
{
    if (TQFile::exists(TQDir::currentDirPath() + "/" + "qtlist"))
    {
        TQFile f(TQDir::currentDirPath() + "/" + "qtlist");
        f.open(IO_ReadOnly);
        TQTextStream str(&f);
        while (!str.eof())
            files->insertItem(str.readLine());
    }
    ast->setSorting(-1);
    parentProject.push((TQListViewItem*)0);
}

void Viewer::addAll_clicked()
{
    if (allLocation->text().isEmpty())
        return;
    TQDir d(allLocation->text());
    TQStringList l = d.entryList("*.am");
    for (TQStringList::iterator it = l.begin(); it != l.end(); ++it)
        (*it) = TQDir::cleanDirPath(allLocation->text() + "/" + (*it));
    files->insertStringList(l);
}

void Viewer::choose_clicked()
{
    TQString fileName = TQFileDialog::getOpenFileName(TQDir::currentDirPath(), "*.am", this);
    if (!fileName.isEmpty())
        files->insertItem(fileName);
}

void Viewer::files_currentChanged(TQListBoxItem* item)
{
    ast->clear();
    
    TQFile f(item->text());
    f.open(IO_ReadOnly);
    TQTextStream str(&f);
    source->setText(str.read());
    f.close();
    
    int result = Driver::parseFile(item->text().ascii(), &projectAST);
    if (projectAST && (result == 0))
    {
        processAST(projectAST);
    }
    if (tabWidget2->currentPageIndex() == 1)
        tabWidget2_selected("Source to be written back");
}

void Viewer::tabWidget2_selected(const TQString& text)
{
    if ((text == "Source to be written back") && projectAST)
    {
        TQString buffer;
        projectAST->writeBack(buffer);
        writeBack->setText(buffer);
    }
}

void Viewer::processAST(ProjectAST *projectAST, TQListViewItem *globAfter)
{
    TQListViewItem *projectIt;
    if (!parentProject.top())
        projectIt = new TQListViewItem(ast, "Project");
    else
    {
        if ( projectAST->isConditionalScope() || projectAST->isRule() )
            projectIt = new TQListViewItem(parentProject.top(), globAfter, projectAST->scopedID);
    }
    projectIt->setOpen(true);
    
    TQListViewItem *after = 0;
    for (TQValueList<AST*>::const_iterator it = projectAST->statements.constBegin();
            it != projectAST->statements.constEnd(); ++it)
    {
        AST *ast = *it;
        if (ast == 0)
            continue;
	switch (ast->nodeType()) {
	case AST::AssignmentAST: {
		AssignmentAST *assignmentAST = static_cast<AssignmentAST*>(ast);
		TQListViewItem *item = new TQListViewItem(projectIt, after,
			assignmentAST->scopedID, assignmentAST->op, assignmentAST->values.join(""));
		item->setMultiLinesEnabled(true);
		after = item; }
		break;

	case AST::TargetAST:
		{
			AutomakeTargetAST* ata = static_cast<AutomakeTargetAST*>(ast);
			TQListViewItem* item = new TQListViewItem(projectIt, after,
					ata->target, TQString(), ata->deps.join(""));
			after = item;
		}
		break;
		
	case AST::NewLineAST:
//                 after = new TQListViewItem(projectIt, after, "<newline>");
		break;
		
	case AST::CommentAST:
//                 after = new TQListViewItem(projectIt, after, "<comment>");
		break;
		
	case AST::MakefileConditionalAST:
		{
			ConditionAST* ata = static_cast<ConditionAST*>(ast);
			TQListViewItem* item = new TQListViewItem(projectIt, after,
					ata->type, ata->conditionName, TQString() );
			after = item;
		}
	case AST::ProjectAST: {
		ProjectAST *projectAST = static_cast<ProjectAST*>(ast);
		parentProject.push(projectIt);
		processAST(projectAST, after);
		parentProject.pop(); }
		break;
	}
    }
}

#include "viewer.moc"

