%{CPP_TEMPLATE}

#include <tqpixmap.h>
#include <tqlayout.h>

#include <kiconloader.h>
#include <tdelocale.h>
#include <tdemdichildview.h>
#include <kdebug.h>
#include <klibloader.h>
#include <tdemessagebox.h>

#include "%{APPNAMELC}tdemdiView.h"


	%{APPNAMELC}tdemdiView::%{APPNAMELC}tdemdiView( TQWidget *parentWidget, const char *name )
: KMdiChildView( parentWidget, name )
{
	m_part = NULL;

	// this routine will find and load our Part.  it finds the Part by
	// name which is a bad idea usually.. but it's alright in this
	// case since our Part is made for this Shell
	KLibFactory *factory = KLibLoader::self()->factory("lib%{APPNAMELC}part");
	//KLibFactory *factory = KLibLoader::self()->factory("libkatepart");
	if (factory)
	{
		// now that the Part is loaded, we cast it to a Part to get
		// our hands on it
		m_part = static_cast<KParts::ReadWritePart *>(factory->create(
			this, "katepart", "KParts::ReadWritePart" ));

		if (m_part)
		{
			part()->widget()->setFocus();
			setFocusProxy(part()->widget());

			TQBoxLayout* layout = new TQHBoxLayout(this, 0, -1, "kdissertviewlayout" );
			part()->widget()->reparent( this, TQPoint(0, 0) );
			layout->addWidget( part()->widget() );

			// connect( m_part, TQ_SIGNAL(stateChanged()), this, TQ_SLOT(updateCaption()) );
		}
		else
		{
			KMessageBox::error(this, i18n("Could not find our part."));
		}
	}
	else
	{
		// if we couldn't find our Part, we exit since the Shell by
		// itself can't do anything useful
		KMessageBox::error(this, i18n("Could not find our part."));
		return;
	}
}

%{APPNAMELC}tdemdiView::~%{APPNAMELC}tdemdiView()
{
	delete m_part->widget();
}

#include "%{APPNAMELC}tdemdiView.moc"
