#ifndef _PreviewLoadBase_H
#define _PreviewLoadBase_H

#include <kdialogbase.h>

#include <tqframe.h>

#include "Tileset.h"
#include "BoardLayout.h"
#include "Background.h"

class TQComboBox;
class TQPixmap;

class FrameImage: public TQFrame
{
	TQ_OBJECT
  
public:
	FrameImage(TQWidget *parent=NULL, const char *name = NULL);
	~FrameImage();
	void setGeometry(int x, int y, int w, int h);
	TQPixmap *getPreviewPixmap() {return thePixmap;}
	void setRect(int x, int y, int w, int h, int ss, int type);
signals:
	void mousePressed(TQMouseEvent *e);
	void mouseMoved(TQMouseEvent *e);
protected:
	void mousePressEvent(TQMouseEvent *e);
	void mouseMoveEvent(TQMouseEvent *e);
	void paintEvent( TQPaintEvent* pa );
private:
	TQPixmap *thePixmap;
	int rx;
	int ry;
	int rw;
	int rh;
	int rs;
	int rt;
};



class Preview: public KDialogBase
{
    TQ_OBJECT
  

public:
	enum PreviewType {background, tileset, board, theme};

	Preview(TQWidget* parent);
	~Preview();

	void initialise(const PreviewType type);
	void saveTheme();

protected:
	void markUnchanged();
	void markChanged();
	bool isChanged();
	TQPixmap *getPreviewPixmap() {return m_drawFrame->getPreviewPixmap(); }
	virtual void drawPreview();
	void applyChange() ;
	void renderBackground(const TQString &bg);
	void renderTiles(const TQString &file, const TQString &layout);
	void paintEvent( TQPaintEvent* pa );

signals:
	void boardRedraw(bool);
	void loadTileset(const TQString &);
	void loadBackground(const TQString &, bool);
	void loadBoard(const TQString &);
	void layoutChange();

public slots:
	void selectionChanged(int which);

protected slots:
	void slotApply();
	void slotOk();
	
private slots:
	void load();

protected:
	FrameImage *m_drawFrame;
	TQComboBox *m_combo;

	TQString m_selectedFile;
	Tileset m_tiles;
	BoardLayout m_boardLayout;
	Background m_back;

private:
	TQString m_fileSelector;
	bool m_changed;
	TQStringList m_fileList;
	PreviewType m_previewType;

	TQString m_themeBack;
	TQString m_themeLayout;
	TQString m_themeTileset;
};

#endif
