iconName = 'about_kde'
labelText = 'TDEAboutTDE'

from PyTQt.tqt import TQFrame, TQHBoxLayout, TQVBoxLayout, TQ_SIGNAL
from tdecore import i18n
from tdeui import TDEAboutKDE, KPushButton, KTextEdit


helpText = ("Typically available via the applications 'Help' menu, this "
            "dialog presents the user with the standard TDE About dialog.")


class MainFrame(TQFrame):
    def __init__(self, parent=None):
        TQFrame.__init__(self, parent)
        self.button = KPushButton(i18n('About TDE'), self)
        self.help = KTextEdit(helpText, '', self)
        layout = TQVBoxLayout(self, 4)
        layout.addWidget(self.help)
        buttonlayout = TQHBoxLayout(layout, 4)
        buttonlayout.addWidget(self.button)
        buttonlayout.addStretch(1)
        layout.addStretch(1)
        self.connect(self.button, TQ_SIGNAL('clicked()'), self.showAboutDialog)

    def showAboutDialog(self):
        dlg = TDEAboutKDE(self)
        dlg.show()
