/***************************************************************************
 *   Copyright (C) 2005 by Daniel Stöckel                                  *
 *   the_docter@gmx.net                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef KOMMANDOVIEW_H
#define KOMMANDOVIEW_H

#include <tqlistview.h>
#include <tdemacros.h>

/**
	@author Daniel Stöckel <the_docter@gmx.net>
*/
class TDE_EXPORT KommandoView : public TQListView
{
    public:
        KommandoView(TQWidget* parent, const TQString& name);

        void setAppName(const TQString& theValue){ m_AppName = theValue; }
        TQString appName() const{ return m_AppName; }

    private:
        TQString m_AppName;
};

class TDE_EXPORT KommandoViewList : public TQPtrList<KommandoView>
{
    public:
        KommandoViewList(bool autoDelete = false);

        bool contains(const TQString& view);

        KommandoView* getView(const TQString& view);
        KommandoView* getViewOrDefault(const TQString& view);
        void removeView(const TQString& view);

};

#endif
