// Copyright (c) 2000 Phil Thompson <phil@river-bank.demon.co.uk>
//
// This file contains the definition of the interface to the Kugar KPart.


#ifndef _KUGAR_FACTORY_H
#define _KUGAR_FACTORY_H


#include <KoFactory.h>
#include <tdeaboutdata.h>

class TDEInstance;


class KugarFactory : public KoFactory
{
    TQ_OBJECT
  
public:
    KugarFactory( TQObject* parent = 0, const char* name = 0 );
    ~KugarFactory();

    virtual KParts::Part *createPartObject( TQWidget *parentWidget = 0, const char *widgetName = 0,
                                            TQObject *parent = 0, const char *name = 0, const char *classname = "KoDocument",
                                            const TQStringList &args = TQStringList() );

    static TDEInstance* global();

    // _Creates_ a TDEAboutData but doesn't keep ownership
    static TDEAboutData* aboutData();
private:
    static TDEInstance* s_instance;
    static TDEAboutData* s_aboutdata;
};

#endif
