/***************************************************************************
                          knowittree.cpp  -  description
                             -------------------
    begin                : sob gru 20 2003
    copyright            : (C) 2003 by Micha Rudolf
    email                : mrudolf@kdewebdev.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <tdelocale.h>
#include <tqevent.h>
#include <tqdragobject.h>
#include <tqheader.h>
#include <tqwhatsthis.h>
#include "knowittree.h"

KnowitTree::KnowitTree(TQWidget* parent, const char* name)
   : TDEListView(parent, name)
{
   setMinimumSize(150, 150);
   addColumn(i18n("Notes"));
   setRootIsDecorated(true);
   setItemsRenameable(true);
   setDragEnabled(true);
   setAcceptDrops(true);
   setFullWidth(true);
   setSorting(-1);
   setDragAutoScroll(true);
   prevItem = 0;
   TQWhatsThis::add(this, i18n("<h2>Notes hierarchy</h2>"
      "Here you can browse notes tree. "
      "You can also add notes using right-click menu, or reorganize them using "
      "drag and drop."));
}


void KnowitTree::takeNode(TQListViewItem* item)
{
   if (item->parent())
      item->parent()->takeItem(item);
   else
      takeItem(item);
}

void KnowitTree::insertNode(TQListViewItem* parent, TQListViewItem* item, TQListViewItem* after)
{
   if (parent)
      parent->insertItem(item);
   else
      insertItem(item);
   if (after)
      item->moveItem(after);
}


void KnowitTree::contentsDragMoveEvent(TQDragMoveEvent* event)
{
   TQListViewItem* item = itemAt(event->pos());
   /* check if on root decoration */
   if (!item || event->pos().x() > header()->cellPos(header()->mapToActual(0)) +
         treeStepSize() * (item->depth() + 1) + itemMargin() ||
      event->pos().x() < header()->cellPos(header()->mapToActual(0)))
      return;
   if (item && item->childCount() && !item->isOpen())
      item->setOpen(true);
}

void KnowitTree::slotCollapseAll()
{
   TQListViewItem* it = firstChild();
   while(it) {
      it->setOpen(false);
      it = it->nextSibling();
      }
}

void KnowitTree::slotCollapse()
{
   if (currentItem())
      currentItem()->setOpen(false);
}


void KnowitTree::slotExpandAll()
{
   TQListViewItem* it = firstChild();
   while(it) {
      it->setOpen(true);
      it = it->nextSibling();
      }
}

void KnowitTree::slotExpand()
{
   if (currentItem())
      currentItem()->setOpen(true);
}

void KnowitTree::slotItemUp()
{
   if (currentItem())
      setCurrentItem(currentItem()->itemAbove());
}

void KnowitTree::slotItemDown()
{
   if (currentItem())
      setCurrentItem(currentItem()->itemBelow());
}

void KnowitTree::slotItemBegin()
{
   setCurrentItem(firstChild());
}

void KnowitTree::slotItemEnd()
{
   TQListViewItem* elt = firstChild();
   if (elt)
      while (elt->itemBelow())
         elt = elt->itemBelow();
   setCurrentItem(elt);
}

void KnowitTree::slotItemLeft()
{
   if (currentItem())
      setCurrentItem(currentItem()->parent());
}

void KnowitTree::slotItemRight()
{
   if (currentItem())
      setCurrentItem(currentItem()->firstChild());
}

#include "knowittree.moc"

