/* ============================================================
 * Author: Gilles Caulier <caulier dot gilles at gmail dot com>
 *         from digiKam project.
 * Date  : 2003-10-01
 * Description : a kipi plugin to export image collections
 *               on CD/DVD.
 *
 * Copyright 2003-2005 by Gilles Caulier <caulier dot gilles at gmail dot com>
 * Copyright 2003-2004 by Gregory Kokanosky
 *                        <gregory dot kokanosky at free.fr>
 *                        for HTML interface navigation mode
 * Copyright 2005      by Owen Hirst <n8rider at sbcglobal.net>
 *                        about bugfix.
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * ============================================================ */

#ifndef CDARCHIVINGDIALOG_H
#define CDARCHIVINGDIALOG_H

// TQt includes

#include <tqguardedptr.h>

// KDE includes

#include <kdialogbase.h>
#include <tdeio/global.h>

// KIPI includes

#include "kpaboutdata.h"
#include <libkipi/interface.h>

class KColorButton;
class KFileItem;
class KFilePreview;
class KIntNumInput;
class TDEListView;
class KSqueezedTextLabel;
class KURL;
class KURLRequester;

class TQCheckBox;
class TQLineEdit;
class TQProgressDialog;
class TQPushButton;
class TQSpinBox;
class TQString;


namespace KIPI
{
class ImageCollectionSelector;
}

namespace KIPICDArchivingPlugin
{

class CDArchivingDialog : public KDialogBase
{
    TQ_OBJECT
  

public:

    CDArchivingDialog( KIPI::Interface* interface, TQWidget *parent=0);
    ~CDArchivingDialog();

    TQString getK3bBinPathName() const;
    TQString getK3bParameters() const;

    void  setK3bBinPathName(const TQString &Value);
    void  setK3bParameters(const TQString &Value);

    int   getImagesPerRow() const;
    void  setImagesPerRow(int Value);

    int   getThumbnailsSize() const;
    void  setThumbnailsSize(int Value);

    const TQString getFontName() const;
    void  setFontName(TQString Value);

    const TQString getFontSize() const;
    void  setFontSize(int Value);

    const TQString getBordersImagesSize() const;
    void  setBordersImagesSize(int Value);

    const TQColor getBackgroundColor() const;
    void  setBackgroundColor(TQColor Value);

    const TQColor getForegroundColor() const;
    void  setForegroundColor(TQColor Value);

    const TQColor getBordersImagesColor() const;
    void  setBordersImagesColor(TQColor Value);

    const TQString getImageFormat() const;
    void  setImageFormat(TQString Value);

    const TQString getMainTitle() const;
    void  setMainTitle(TQString Value);

    bool  getUseHTMLInterface() const;
    void  setUseHTMLInterface(bool Value);

    bool  getUseAutoRunWin32() const;
    void  setUseAutoRunWin32(bool Value);

    const TQString getVolumeID() const;
    void  setVolumeID(TQString Value);

    const TQString getVolumeSetID() const;
    void  setVolumeSetID(TQString Value);

    const TQString getSystemID() const;
    void  setSystemID(TQString Value);

    const TQString getApplicationID() const;
    void  setApplicationID(TQString Value);

    const TQString getPublisher() const;
    void  setPublisher(TQString Value);

    const TQString getPreparer() const;
    void  setPreparer(TQString Value);

    const TQString getMediaFormat() const;
    void  setMediaFormat(TQString Value);

    bool  getUseOnTheFly() const;
    void  setUseUseOnTheFly(bool Value);

    bool  getUseCheckCD() const;
    void  setUseCheckCD(bool Value);

    bool  getUseStartBurningProcess() const;
    void  setUseStartBurningProcess(bool Value);

    TQValueList<KIPI::ImageCollection> getSelectedAlbums() const
    {
        return m_selectedAlbums;
    }

    void ShowMediaCapacity(void);

protected slots:

    void slotHelp();
    void slotAlbumSelected(void);
    void mediaFormatActived( const TQString& item );
    void slotOk();
    void UrlChanged(const TQString &url );

private:

    KColorButton                        *m_backgroundColor;
    KColorButton                        *m_bordersImagesColor;
    KColorButton                        *m_foregroundColor;

    TDEIO::filesize_t                      MaxMediaSize;

    KIPI::ImageCollectionSelector       *m_imageCollectionSelector;

    KIPI::Interface                     *m_interface;

    KIPIPlugins::KPAboutData            *m_about;

    KIntNumInput                        *m_imagesPerRow;
    KIntNumInput                        *m_thumbnailsSize;

    TDEListView                           *m_AlbumsList;

    KSqueezedTextLabel                  *m_AlbumCollection;
    KSqueezedTextLabel                  *m_AlbumComments;
    KSqueezedTextLabel                  *m_AlbumDate;
    KSqueezedTextLabel                  *m_AlbumItems;
    KSqueezedTextLabel                  *m_AlbumSize;

    KURLRequester                       *m_K3bBinPath;

    TQCheckBox                           *m_burnOnTheFly;
    TQCheckBox                           *m_checkCDBurn;
    TQCheckBox                           *m_startBurningProcess;
    TQCheckBox                           *m_useAutoRunWin32;
    TQCheckBox                           *m_useHTMLInterface;
    TQComboBox                           *m_fontName;
    TQComboBox                           *m_imageFormat;
    TQComboBox                           *m_mediaFormat;

    TQFrame                              *page_CDInfos;
    TQFrame                              *page_burning;
    TQFrame                              *page_setupLook;
    TQFrame                              *page_setupSelection;

    TQLabel                              *m_albumPreview;
    TQLabel                              *m_labelBackgroundColor;
    TQLabel                              *m_labelFontName;
    TQLabel                              *m_labelFontSize;
    TQLabel                              *m_labelForegroundColor;
    TQLabel                              *m_labelImageBorderSize;
    TQLabel                              *m_labelImageBorderSizeColor;
    TQLabel                              *m_labelThumbsFileFormat;
    TQLabel                              *m_labelTitle;
    TQLabel                              *m_mediaSize;

    TQLineEdit                           *m_K3bParameters;
    TQLineEdit                           *m_application_id;
    TQLineEdit                           *m_preparer;
    TQLineEdit                           *m_publisher;
    TQLineEdit                           *m_system_id;
    TQLineEdit                           *m_title;
    TQLineEdit                           *m_volume_id;
    TQLineEdit                           *m_volume_set_id;

    TQProgressDialog                     *m_progressDlg;

    TQPushButton                         *m_helpButton;

    TQSpinBox                            *m_bordersImagesSize;
    TQSpinBox                            *m_fontSize;

    TQString                              m_ImagesFilesSort;
    TQString                              m_TempFolder;

    TQValueList<KIPI::ImageCollection>    m_selectedAlbums;

private:

    void setupBurning(void);
    void setupCDInfos(void);
    void setupLookPage(void);
    void setupSelection(void);
};

}  // NameSpace KIPICDArchivingPlugin

#endif /* CDARCHIVINGDIALOG_H */
