
/***************************************************************************
 *                                                                         *
 *   KCPULoad is copyright (c) 1999-2000, Markus Gustavsson                *
 *                         (c) 2002, Ben Burton                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kcpuload.h"

#include <tdeaboutdata.h>
#include <tdecmdlineargs.h>
#include <tdelocale.h>
#include <tdeuniqueapplication.h>

static const char *description =
    I18N_NOOP("A small CPU usage meter for Kicker (the TDE panel).");
static const char *message =
    I18N_NOOP("KCPULoad was first released on the 8th of August, 1999.");
static const char *version = "2.00";

int main(int argc, char **argv) {
    TDEAboutData aboutData("kcpuload", I18N_NOOP("KCPULoad"), version,
        description, TDEAboutData::License_GPL,
        "(c) 1999-2000, Markus Gustavsson\n"
        "(c) 2002, Ben Burton\n"
	"(c) 2009, Timothy Pearson",
        message, 0 /* TODO: Website */, "bab@debian.org");

    aboutData.addAuthor("Markus Gustavsson", "Original author",
        "mighty@fragzone.se");
    aboutData.addAuthor("Ben Burton", "KDE3 rewrite, current maintainer",
        "bab@debian.org");
    aboutData.addAuthor("Andy Fawcett", "BSD support",
        "andy@athame.co.uk");
    aboutData.addAuthor("Robbie Ward", "BSD support",
        "linuxphreak@gmx.co.uk");

    aboutData.addCredit("Njaard, Charles Samuels",
        "Support and help with KDE", "charles@kde.org");
    aboutData.addCredit("rikkus, Rik Hemsley",
        "Support and help with KDE", "rik@kde.org");
    aboutData.addCredit("Mark Halpaap",
        "Independent port to KDE3", "mark.halpaap@gmx.net");
    aboutData.addCredit("Thanks to everyone in #KDE OpenProjects for "
        "being supportive and helpful!");

    TDECmdLineArgs::init(argc, argv, &aboutData);
    TDEUniqueApplication::addCmdLineOptions();

    if (! TDEUniqueApplication::start()) {
        fprintf(stderr, I18N_NOOP("KCPULoad is already running!\n"));
        return 1;
    }

    TDEUniqueApplication app;
    app.setMainWidget(new KCPULoad());
    return app.exec();
}
