/**************************************************************************
*   Copyright (C) 2005 by Jean-Michel Petit                               *
*   jm_petit@laposte.net                                                  *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
***************************************************************************/

#include "tdeconfigdlg.h"
#include "tdemessagebox.h"

#include <kiconloader.h>
#include <kpushbutton.h>

#include <kstdguiitem.h>
#include <kguiitem.h>
#include "k9config.h"

kConfigDlg::kConfigDlg(TQWidget *parent)
    : configDlg(parent)
{
  TQStringList ldev;
  TQStringList llabels;
  TQStringList lIO;
  tblDevices->setColumnWidth(0,150);
  tblDevices->setColumnWidth(1,210);
  tblDevices->setColumnWidth(2,40);
  tblDevices->setColumnWidth(3,45);
  k9Config config;
  
  ldev=config.getDevices();
  llabels=config.getDevicesLabels();
  lIO=config.getDevicesIO();
  int row=0;
  for ( TQStringList::Iterator it = ldev.begin(); it != ldev.end(); ++it )
  {
    tblDevices->setNumRows(row+1);
    tblDevices->setText(row,0,(*it));
    TQStringList::Iterator it2=llabels.at(row);
    tblDevices->setText(row,1,(*it2));

    row++;

  }
  for ( int j = 0; j < tblDevices->numRows(); ++j )
  {
    TQCheckTableItem *I = new TQCheckTableItem( tblDevices, "" );
    TQCheckTableItem *O = new  TQCheckTableItem( tblDevices, "" ) ;
    TQStringList::Iterator it=lIO.at(j);
    TQString c=(*it);
    if((c =="I") || (c =="IO")) I->setChecked(true);
    if((c =="O") || (c =="IO")) O->setChecked(true);
    tblDevices->setItem( j, 2, I );
    tblDevices->setItem( j, 3, O);
  }


//    buttonCancel->setIconSet(KStdGuiItem::cancel().iconSet());
//    buttonOk->setIconSet(KStdGuiItem::ok().iconSet());
}


kConfigDlg::~kConfigDlg()
{}




/*!
    \fn kConfigDlg::bAddClick()
 */
void kConfigDlg::bAddClick()
{
  tblDevices->setNumRows(tblDevices->numRows()+1);
  TQCheckTableItem *I = new TQCheckTableItem( tblDevices, "" );
  TQCheckTableItem *O = new  TQCheckTableItem( tblDevices, "" ) ;
  tblDevices->setItem( tblDevices->numRows()-1, 2, I );
  tblDevices->setItem( tblDevices->numRows()-1, 3, O);
}


/*!
    \fn kConfigDlg::bRemoveClick()
 */
void kConfigDlg::bRemoveClick()
{
  tblDevices->removeRow(tblDevices->currentRow());
}


void kConfigDlg::save()
{
  TQStringList ldev;
  TQStringList llabels;
  TQStringList lIO;
  k9Config config;
  ldev.clear();
  llabels.clear();
  for (int i=0;i<tblDevices->numRows();i++)
  {
    TQString c=tblDevices->text(i,0);
    if (!c.isEmpty())
    {
      if (TQFile::exists(c))
      {
        ldev.append(tblDevices->text(i,0));
        c=tblDevices->text(i,1);
        if (c.isEmpty()) c=tblDevices->text(i,0);
        llabels.append(c);
        TQCheckTableItem *I = (TQCheckTableItem*)tblDevices->item(i,2);
        TQCheckTableItem *O = (TQCheckTableItem*)tblDevices->item(i,3);
        if (O->isChecked() && I->isChecked())
        {
          lIO.append("IO");
        }
        else
        {
          if (O->isChecked()) lIO.append("O");
          if (I->isChecked()) lIO.append("I");
          if ((!O->isChecked()) && (!I->isChecked()))
          {
            lIO.append("x");
          }
        }
      }
      else
      {
        KMessageBox::error( this, c + " is not a valid device", "Devices");
      }
    }
  }
  
  config.setDevicesLabels(llabels);
  config.setDevices(ldev);
  config.setDevicesIO(lIO);
  config.save();
}
