/***************************************************************************
 *   Copyright (C) 2006 by Peter Penz                                      *
 *   peter.penz@gmx.at                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/

#include "detailsviewsettingspage.h"
#include <tqcheckbox.h>
#include <tdelocale.h>
#include <kdialog.h>
#include <tdefontcombo.h>
#include <tqspinbox.h>
#include <tqlabel.h>
#include <tqgrid.h>
#include <assert.h>
#include <tqbuttongroup.h>
#include <tqradiobutton.h>
#include <tqcombobox.h>
#include <tqgroupbox.h>
#include <tqgroupbox.h>
#include "dolphinsettings.h"
#include "dolphindetailsviewsettings.h"
#include "dolphindetailsview.h"

DetailsViewSettingsPage::DetailsViewSettingsPage(TQWidget *parent) :
    TQVBox(parent),
    m_dateBox(0),
    m_permissionsBox(0),
    m_ownerBox(0),
    m_groupBox(0),
    m_smallIconSize(0),
    m_mediumIconSize(0),
    m_largeIconSize(0)
{
    const int spacing = KDialog::spacingHint();
    const int margin = KDialog::marginHint();
    const TQSizePolicy sizePolicy(TQSizePolicy::Preferred, TQSizePolicy::Fixed);

    setSpacing(spacing);
    setMargin(margin);

    DolphinDetailsViewSettings* settings = DolphinSettings::instance().detailsView();
    assert(settings != 0);

    // create "Columns" properties
    TQGroupBox* columnsGroup = new TQGroupBox(4, TQt::Vertical, i18n("Columns"), this);
    columnsGroup->setSizePolicy(sizePolicy);
    columnsGroup->setMargin(margin);

    TQHBox* visibleColumnsLayout = new TQHBox(columnsGroup);
    m_dateBox = new TQCheckBox(i18n("Date"), visibleColumnsLayout);
    m_dateBox->setChecked(settings->isColumnEnabled(DolphinDetailsView::DateColumn));

    m_permissionsBox = new TQCheckBox(i18n("Permissions"), visibleColumnsLayout);
    m_permissionsBox->setChecked(settings->isColumnEnabled(DolphinDetailsView::PermissionsColumn));

    m_ownerBox = new TQCheckBox(i18n("Owner"), visibleColumnsLayout);
    m_ownerBox->setChecked(settings->isColumnEnabled(DolphinDetailsView::OwnerColumn));

    m_groupBox = new TQCheckBox(i18n("Group"), visibleColumnsLayout);
    m_groupBox->setChecked(settings->isColumnEnabled(DolphinDetailsView::GroupColumn));

    // Create "Icon" properties
    TQButtonGroup* iconSizeGroup = new TQButtonGroup(3, TQt::Horizontal, i18n("Icon Size"), this);
    iconSizeGroup->setSizePolicy(sizePolicy);
    iconSizeGroup->setMargin(margin);
    m_smallIconSize  = new TQRadioButton(i18n("Small"), iconSizeGroup);
    m_mediumIconSize = new TQRadioButton(i18n("Medium"), iconSizeGroup);
    m_largeIconSize  = new TQRadioButton(i18n("Large"), iconSizeGroup);
    switch (settings->iconSize()) {
        case TDEIcon::SizeLarge:
            m_largeIconSize->setChecked(true);
            break;

        case TDEIcon::SizeMedium:
            m_mediumIconSize->setChecked(true);
            break;

        case TDEIcon::SizeSmall:
        default:
            m_smallIconSize->setChecked(true);
    }

    //new TQLabel(i18n("Icon size:"), iconGroup);
    //m_iconSizeBox = new TQComboBox(iconGroup);
    //m_iconSizeBox->insertItem(i18n("Small"));
    //m_iconSizeBox->insertItem(i18n("Medium"));
    //m_iconSizeBox->insertItem(i18n("Large"));

    // create "Text" properties
    TQGroupBox* textGroup = new TQGroupBox(2, TQt::Horizontal, i18n("Text"), this);
    textGroup->setSizePolicy(sizePolicy);
    textGroup->setMargin(margin);

    new TQLabel(i18n("Font family:"), textGroup);
    m_fontFamilyBox = new TDEFontCombo(textGroup);
    m_fontFamilyBox->setCurrentFont(settings->fontFamily());

    new TQLabel(i18n("Font size:"), textGroup);
    m_fontSizeBox = new TQSpinBox(6, 99, 1, textGroup);
    m_fontSizeBox->setValue(settings->fontSize());

    // Add a dummy widget with no restriction regarding
    // a vertical resizing. This assures that the dialog layout
    // is not stretched vertically.
    new TQWidget(this);
}


DetailsViewSettingsPage::~DetailsViewSettingsPage()
{
}

void DetailsViewSettingsPage::applySettings()
{
    DolphinDetailsViewSettings* settings = DolphinSettings::instance().detailsView();
    assert(settings != 0);

    settings->setColumnEnabled(DolphinDetailsView::DateColumn,
                               m_dateBox->isChecked());
    settings->setColumnEnabled(DolphinDetailsView::PermissionsColumn,
                               m_permissionsBox->isChecked());
    settings->setColumnEnabled(DolphinDetailsView::OwnerColumn,
                               m_ownerBox->isChecked());
    settings->setColumnEnabled(DolphinDetailsView::GroupColumn,
                               m_groupBox->isChecked());

    int iconSize = TDEIcon::SizeSmall;
    if (m_mediumIconSize->isChecked()) {
        iconSize = TDEIcon::SizeMedium;
    }
    else if (m_largeIconSize->isChecked()) {
        iconSize = TDEIcon::SizeLarge;
    }
    settings->setIconSize(iconSize);

    settings->setFontFamily(m_fontFamilyBox->currentFont());
    settings->setFontSize(m_fontSizeBox->value());
}

#include "detailsviewsettingspage.moc"
